/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import java.io.IOException;

public class CircularByteBuffer {
    private int readOffset = 0;
    private int writeOffset = 0;
    private boolean writeIsAhead = false;
    private final byte[] buf;

    public CircularByteBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size " + size + " <= 0");
        }
        this.buf = new byte[size];
    }

    public int size() {
        return this.buf.length;
    }

    public int unusedBytes() {
        return this.buf.length - this.usedBytes();
    }

    public int usedBytes() {
        if (this.readOffset == this.writeOffset) {
            if (this.writeIsAhead) {
                return this.buf.length;
            }
            return 0;
        }
        if (this.readOffset < this.writeOffset) {
            return this.writeOffset - this.readOffset;
        }
        return this.buf.length - (this.readOffset - this.writeOffset);
    }

    public int write(byte[] data, int offset, int length) throws IOException {
        int chunkLength = Math.min(length, this.unusedBytes());
        int toWrite = chunkLength;
        if (this.writeOffset + toWrite >= this.buf.length) {
            int remainingToEnd = this.buf.length - this.writeOffset;
            System.arraycopy(data, offset, this.buf, this.writeOffset, remainingToEnd);
            this.writeOffset = 0;
            this.writeIsAhead = true;
            toWrite -= remainingToEnd;
            offset += remainingToEnd;
        }
        System.arraycopy(data, offset, this.buf, this.writeOffset, toWrite);
        this.writeOffset += toWrite;
        return chunkLength;
    }

    public int read(byte[] buffer, int offset, int length) {
        int chunkLength = Math.min(length, this.usedBytes());
        int toRead = chunkLength;
        if (this.readOffset + toRead >= this.buf.length) {
            int remainingToEnd = this.buf.length - this.readOffset;
            System.arraycopy(this.buf, this.readOffset, buffer, offset, remainingToEnd);
            this.readOffset = 0;
            this.writeIsAhead = false;
            toRead -= remainingToEnd;
            offset += remainingToEnd;
        }
        System.arraycopy(this.buf, this.readOffset, buffer, offset, toRead);
        this.readOffset += toRead;
        return chunkLength;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[ ");
        boolean first = true;
        for (int i = 0; i < this.buf.length; ++i) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(this.buf[i]);
            if (i == this.readOffset) {
                result.append("r");
            }
            if (i != this.writeOffset) continue;
            result.append("w");
        }
        result.append(" ]");
        if (this.readOffset == this.writeOffset) {
            if (this.writeIsAhead) {
                result.append(" FULL");
            } else {
                result.append(" EMPTY");
            }
        }
        return result.toString();
    }
}

