/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.Exceptions;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RawStreamMuncher
extends Thread {
    private final InputStream in;
    private final OutputStream out;

    public RawStreamMuncher(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        try {
            StreamUtil.copy(this.in, this.out);
        }
        catch (IOException e) {
            Exceptions.ignore(e, "When the process exits, a harmless IOException will occur here");
        }
        finally {
            FileUtil.close(this.in);
            FileUtil.close(this.out);
        }
    }
}

