/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.Exceptions;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.BufferedLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamMuncher
extends Thread {
    private final InputStream is;
    private PrintStream output;
    private BufferedLineReader reader;

    public StreamMuncher(InputStream is, OutputStream output) {
        this.is = is;
        if (output != null) {
            this.output = new PrintStream(output);
        }
    }

    @Override
    public void run() {
        InputStreamReader isr = null;
        try {
            String line;
            isr = new InputStreamReader(this.is);
            this.reader = new BufferedLineReader(isr);
            while ((line = this.reader.readLineAndTerminator()) != null) {
                if (this.output == null) continue;
                this.output.print(line);
                this.output.flush();
            }
        }
        catch (IOException e) {
            Exceptions.ignore(e, "When the process exits, a harmless IOException will occur here");
        }
        finally {
            FileUtil.close(this.reader);
            FileUtil.close(isr);
        }
    }
}

