/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.data.IntRef;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.regex.Pattern;

public class WholeIO {
    private IOException e;
    private static final Pattern rpLineEndingCRLF = Pattern.compile("\r\n");
    private final String defaultEncoding;
    private final boolean fatalDecodingErrors;

    public WholeIO() {
        this("UTF-8");
    }

    public WholeIO(String encoding) {
        this(encoding, false);
    }

    public WholeIO(String encoding, boolean fatalDecodingErrors) {
        this.defaultEncoding = encoding;
        this.fatalDecodingErrors = fatalDecodingErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAndTrim(File file) {
        String string;
        this.e = null;
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            String contents = this.readString(f);
            string = contents == null ? null : contents.trim();
        }
        catch (IOException e) {
            String string2;
            try {
                this.e = e;
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(f);
                throw throwable;
            }
            FileUtil.close(f);
            return string2;
        }
        FileUtil.close(f);
        return string;
    }

    public boolean write(String filename, String contents) {
        return this.write(new File(filename), contents);
    }

    public boolean write(File file, String contents) {
        return this.write(file, contents, false);
    }

    public boolean write(Path path, String contents) {
        return this.write(path, contents, false);
    }

    public void strictwrite(File file, String contents) {
        this.strictwrite(file, contents, false);
    }

    public void strictwrite(Path path, String contents) {
        this.strictwrite(path, contents, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File file, String contents, boolean append) {
        boolean bl;
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, append);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.defaultEncoding));
            ((Writer)writer).append(contents);
            ((Writer)writer).close();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                this.e = e;
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(fos);
                throw throwable;
            }
            FileUtil.close(fos);
            return bl2;
        }
        FileUtil.close(fos);
        return bl;
    }

    public boolean write(Path path, String contents, boolean append) {
        try {
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.forName(this.defaultEncoding), StandardOpenOption.CREATE, StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
                writer.append(contents);
            }
        }
        catch (IOException e) {
            this.e = e;
            return false;
        }
        return true;
    }

    public void strictwrite(File file, String contents, boolean append) {
        if (!this.write(file, contents, append)) {
            throw new ResourceError("Failed to write file " + file, this.getLastException());
        }
    }

    public void strictwrite(Path path, String contents, boolean append) {
        if (!this.write(path, contents, append)) {
            throw new ResourceError("Failed to write path " + path, this.getLastException());
        }
    }

    public IOException getLastException() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(File file) {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            string = this.readString(is);
        }
        catch (IOException e) {
            String string2;
            try {
                this.e = e;
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
            FileUtil.close(is);
            return string2;
        }
        FileUtil.close(is);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(Path path) {
        String string;
        InputStream is = null;
        try {
            is = Files.newInputStream(path, new OpenOption[0]);
            string = this.readString(is);
        }
        catch (IOException e) {
            String string2;
            try {
                this.e = e;
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
            FileUtil.close(is);
            return string2;
        }
        FileUtil.close(is);
        return string;
    }

    public String readText(File file) {
        String result = this.read(file);
        return result != null ? result.replaceAll("\r\n", "\n") : null;
    }

    public String readText(Path path) {
        String result = this.read(path);
        return result != null ? result.replaceAll("\r\n", "\n") : null;
    }

    public String strictread(File f) {
        String content = this.read(f);
        if (content == null) {
            throw new ResourceError("Failed to read file " + f, this.getLastException());
        }
        return content;
    }

    public String strictread(Path f) {
        String content = this.read(f);
        if (content == null) {
            throw new ResourceError("Failed to read path " + f, this.getLastException());
        }
        return content;
    }

    public String strictreadText(File file) {
        return rpLineEndingCRLF.matcher(this.strictread(file)).replaceAll("\n");
    }

    public String strictreadText(Path path) {
        return rpLineEndingCRLF.matcher(this.strictread(path)).replaceAll("\n");
    }

    public String readString(InputStream stream) {
        IntRef length = new IntRef(0);
        byte[] bytes = this.readBinary(stream, length);
        if (bytes == null) {
            return null;
        }
        try {
            IntRef start = new IntRef(0);
            String charset = this.determineCharset(bytes, length.get(), start);
            if (this.fatalDecodingErrors) {
                return Charset.forName(charset).newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(bytes, start.get(), length.get() - start.get())).toString();
            }
            return new String(bytes, start.get(), length.get() - start.get(), charset);
        }
        catch (UnsupportedEncodingException | CharacterCodingException e) {
            this.e = e;
            return null;
        }
    }

    public String strictReadString(InputStream stream) {
        String content = this.readString(stream);
        if (content == null) {
            throw new ResourceError("Could not read from stream", this.getLastException());
        }
        return content;
    }

    public byte[] readBinary(InputStream stream) {
        IntRef length = new IntRef(0);
        byte[] bytes = this.readBinary(stream, length);
        return bytes == null ? null : Arrays.copyOf(bytes, length.get());
    }

    public byte[] strictReadBinary(InputStream stream) {
        byte[] result = this.readBinary(stream);
        if (result == null) {
            throw new ResourceError("Couldn't read from stream", this.e);
        }
        return result;
    }

    public byte[] strictReadBinary(File file) {
        byte[] byArray;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            byte[] result = this.readBinary(stream);
            if (result == null) {
                throw new ResourceError("Couldn't read from file " + file + ".", this.e);
            }
            byArray = result;
        }
        catch (FileNotFoundException e) {
            try {
                throw new ResourceError("Couldn't read from file " + file + ".", e);
            }
            catch (Throwable throwable) {
                FileUtil.close(stream);
                throw throwable;
            }
        }
        FileUtil.close(stream);
        return byArray;
    }

    public byte[] strictReadBinary(Path path) {
        byte[] byArray;
        InputStream stream = null;
        try {
            stream = Files.newInputStream(path, new OpenOption[0]);
            byte[] result = this.readBinary(stream);
            if (result == null) {
                throw new ResourceError("Couldn't read from path " + path + ".", this.e);
            }
            byArray = result;
        }
        catch (IOException e) {
            try {
                throw new ResourceError("Couldn't read from path " + path + ".", e);
            }
            catch (Throwable throwable) {
                FileUtil.close(stream);
                throw throwable;
            }
        }
        FileUtil.close(stream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBinary(Path path) throws IOException {
        byte[] byArray;
        InputStream stream = null;
        try {
            stream = Files.newInputStream(path, new OpenOption[0]);
            byte[] result = this.readBinary(stream);
            if (result == null) {
                throw new ResourceError("Couldn't read from path " + path + ".", this.e);
            }
            byArray = result;
        }
        catch (Throwable throwable) {
            FileUtil.close(stream);
            throw throwable;
        }
        FileUtil.close(stream);
        return byArray;
    }

    private byte[] readBinary(InputStream stream, IntRef offsetHolder) {
        try {
            int readThisTime;
            byte[] bytes = new byte[16384];
            int offset = 0;
            do {
                if ((readThisTime = stream.read(bytes, offset, bytes.length - offset)) <= 0 || (offset += readThisTime) != bytes.length) continue;
                bytes = this.safeArrayDouble(bytes);
            } while (readThisTime > 0);
            offsetHolder.set(offset);
            return bytes;
        }
        catch (IOException e) {
            this.e = e;
            return null;
        }
    }

    private byte[] safeArrayDouble(byte[] array) {
        if (array.length >= 0x7FFFFFF7) {
            throw new ResourceError("Cannot stream into array as it exceed the maximum array size");
        }
        long newCapacity = (long)array.length * 2L;
        if (newCapacity < 16L) {
            newCapacity = 16L;
        }
        if (newCapacity > 0x7FFFFFF7L) {
            newCapacity = 0x7FFFFFF7L;
        }
        return Arrays.copyOf(array, (int)newCapacity);
    }

    private String determineCharset(byte[] bom, int length, IntRef start) {
        start.set(0);
        String ret = this.defaultEncoding;
        if (length < 2) {
            return ret;
        }
        if (length >= 3 && WholeIO.byteToInt(bom[0]) == 239 && WholeIO.byteToInt(bom[1]) == 187 && WholeIO.byteToInt(bom[2]) == 191) {
            ret = "UTF-8";
            start.set(3);
        } else if (WholeIO.byteToInt(bom[0]) == 254 && WholeIO.byteToInt(bom[1]) == 255) {
            ret = "UTF-16BE";
            start.set(2);
        } else if (WholeIO.byteToInt(bom[0]) == 255 && WholeIO.byteToInt(bom[1]) == 254) {
            ret = "UTF-16LE";
            start.set(2);
        }
        return ret;
    }

    private static int byteToInt(byte b) {
        return b & 0xFF;
    }
}

