/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io.csv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private StringBuilder buf = new StringBuilder(128);
    public static final char DEFAULT_SEPARATOR = ',';
    private static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final boolean DEFAULT_STRICT_QUOTES = false;

    CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
    }

    public boolean isPending() {
        return this.buf.length() != 0;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.isPending()) {
            this.clear();
        }
        if (nextLine == null) {
            if (!this.isPending()) return null;
            String s = this.buf.toString();
            this.clear();
            return new String[]{s};
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        boolean inQuotes = this.isPending();
        for (int i = 0; i < nextLine.length(); ++i) {
            char c = nextLine.charAt(i);
            if (c == this.escape && this.isNextCharacterEscapable(nextLine, inQuotes, i)) {
                this.buf.append(nextLine.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, inQuotes, i)) {
                    this.buf.append(nextLine.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl = inQuotes = !inQuotes;
                if (this.strictQuotes || i <= 2 || nextLine.charAt(i - 1) == this.separator || nextLine.length() <= i + 1 || nextLine.charAt(i + 1) == this.separator) continue;
                this.buf.append(c);
                continue;
            }
            if (c == this.separator && !inQuotes) {
                tokensOnThisLine.add(this.buf.toString());
                this.clear();
                continue;
            }
            if (this.strictQuotes && !inQuotes) continue;
            this.buf.append(c);
        }
        if (inQuotes) {
            if (!multi) throw new IOException("Un-terminated quoted field at end of CSV line");
            this.buf.append('\n');
            return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
        } else {
            tokensOnThisLine.add(this.buf.toString());
            this.clear();
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && (nextLine.charAt(i + 1) == this.quotechar || nextLine.charAt(i + 1) == this.escape);
    }

    private void clear() {
        this.buf.setLength(0);
    }
}

