/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.logging;

import com.semmle.util.exception.CatastrophicError;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Stack;

public class Streams {
    public static final PrintStream origOut = System.out;
    public static final PrintStream origErr = System.err;
    private static final InheritableThreadLocal<PrintStream> out = new InheritableThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return System.out;
        }
    };
    private static final InheritableThreadLocal<PrintStream> err = new InheritableThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return System.err;
        }
    };
    private static final InheritableThreadLocal<InputStream> in = new InheritableThreadLocal<InputStream>(){

        @Override
        protected InputStream initialValue() {
            return System.in;
        }
    };
    private static final ThreadLocal<Stack<SavedContext>> contexts = new ThreadLocal<Stack<SavedContext>>(){

        @Override
        protected Stack<SavedContext> initialValue() {
            return new Stack<SavedContext>();
        }
    };

    public static PrintStream out() {
        return (PrintStream)out.get();
    }

    public static PrintStream err() {
        return (PrintStream)err.get();
    }

    public static InputStream in() {
        return (InputStream)in.get();
    }

    public static void pushContext(OutputStream stdout, OutputStream stderr, InputStream stdin) {
        SavedContext context = new SavedContext();
        context.out = (PrintStream)out.get();
        context.err = (PrintStream)err.get();
        context.in = (InputStream)in.get();
        contexts.get().push(context);
        out.set(Streams.asPrintStream(stdout));
        err.set(Streams.asPrintStream(stderr));
        in.set(stdin);
    }

    private static PrintStream asPrintStream(OutputStream stdout) {
        return stdout instanceof PrintStream ? (PrintStream)stdout : new PrintStream(stdout);
    }

    public static void popContext() {
        Stack<SavedContext> context = contexts.get();
        ((PrintStream)out.get()).flush();
        ((PrintStream)err.get()).flush();
        if (context.isEmpty()) {
            throw new CatastrophicError("Popping logging context without preceding push.");
        }
        SavedContext old = context.pop();
        out.set(old.out);
        err.set(old.err);
        in.set(old.in);
    }

    private static class SavedContext {
        public PrintStream out;
        public PrintStream err;
        public InputStream in;

        private SavedContext() {
        }
    }
}

