/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.Exceptions;
import com.semmle.util.exception.InterruptedError;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.RawStreamMuncher;
import com.semmle.util.process.Env;
import com.semmle.util.process.LeakPrevention;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractProcessBuilder.class);
    protected static final long MUNCH_TIMEOUT = 20L;
    private final ProcessBuilder builder;
    private boolean logFailure = true;
    private InputStream in;
    private LeakPrevention leakPrevention;
    private volatile boolean interrupted = false;
    private volatile Thread threadToInterrupt = null;
    private volatile boolean hitTimeout = false;
    private final Map<String, String> canonicalEnvVarNames = new LinkedHashMap<String, String>();
    private RawStreamMuncher inMuncher;

    public AbstractProcessBuilder(List<String> args, File cwd, Map<String, String> env) {
        CatastrophicError.throwIfNull(args);
        for (int i = 0; i < args.size(); ++i) {
            CatastrophicError.throwIfNull(args.get(i));
        }
        this.leakPrevention = LeakPrevention.NONE;
        this.builder = new ProcessBuilder(new ArrayList<String>(args));
        if (cwd != null) {
            this.builder.directory(cwd);
        }
        Map<String, String> keepThese = Env.systemEnv().getenv();
        Iterator<String> it = this.builder.environment().keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (keepThese.containsKey(name)) continue;
            it.remove();
        }
        if (env != null) {
            this.addEnvironment(env);
        }
    }

    public void setLeakPrevention(LeakPrevention leakPrevention) {
        CatastrophicError.throwIfNull(leakPrevention);
        this.leakPrevention = leakPrevention;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.builder.redirectErrorStream(redirectErrorStream);
    }

    public final boolean hasEnvVar(String name) {
        return this.builder.environment().containsKey(this.getCanonicalVarName(name));
    }

    public final void addEnvVar(String name, String value) {
        this.builder.environment().put(this.getCanonicalVarName(name), value);
    }

    public void prependArgs(List<String> args) {
        this.builder.command().addAll(0, args);
    }

    public String getCanonicalVarName(String name) {
        if (!Env.getOS().isEnvironmentCaseSensitive()) {
            String canonical;
            if (this.canonicalEnvVarNames.isEmpty()) {
                for (String var : this.builder.environment().keySet()) {
                    this.canonicalEnvVarNames.put(StringUtil.lc(var), var);
                }
            }
            if ((canonical = this.canonicalEnvVarNames.get(StringUtil.lc(name))) == null) {
                this.canonicalEnvVarNames.put(StringUtil.lc(name), name);
            } else {
                name = canonical;
            }
        }
        return name;
    }

    public Map<String, String> getCanonicalCurrentEnv() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.builder.environment().entrySet()) {
            result.put(this.getCanonicalVarName(e.getKey()), e.getValue());
        }
        return result;
    }

    public final void setIn(InputStream in) {
        this.in = in;
    }

    public final void setEnvironment(Map<String, String> env) {
        this.builder.environment().clear();
        this.canonicalEnvVarNames.clear();
        this.addEnvironment(env);
    }

    public final void addEnvironment(Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            this.addEnvVar(entry.getKey(), entry.getValue());
        }
    }

    public final int execute() {
        return this.execute(0L);
    }

    public final void expectFailure() {
        this.logFailure = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int execute(long timeout) {
        Process process = null;
        boolean processStopped = true;
        Timer timer = null;
        AbstractProcessBuilder abstractProcessBuilder = this;
        // MONITORENTER : abstractProcessBuilder
        if (this.interrupted) {
            throw new InterruptedException();
        }
        this.threadToInterrupt = Thread.currentThread();
        // MONITOREXIT : abstractProcessBuilder
        processStopped = false;
        String directory = this.builder.directory() == null ? "current directory ('" + System.getProperty("user.dir") + "')" : "'" + this.builder.directory().toString() + "'";
        this.setupRedirections(this.builder);
        logger.debug("Running command: '" + this.toString() + "' in " + directory);
        process = this.builder.start();
        this.setupInputHandling(process.getOutputStream());
        this.setupOutputHandling(process.getInputStream(), process.getErrorStream());
        if (timeout != 0L) {
            timer = new Timer(true);
            final Thread current = Thread.currentThread();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AbstractProcessBuilder.this.hitTimeout = true;
                    current.interrupt();
                }
            }, timeout);
        }
        int result = process.waitFor();
        processStopped = true;
        if (result != 0 && this.logFailure) {
            logger.error("Spawned process exited abnormally (code " + result + "; tried to run: " + this.getBuilderCommand() + ")");
        }
        int n = result;
        if (timer != null) {
            timer.cancel();
        }
        AbstractProcessBuilder abstractProcessBuilder2 = this;
        // MONITORENTER : abstractProcessBuilder2
        this.threadToInterrupt = null;
        Thread.interrupted();
        // MONITOREXIT : abstractProcessBuilder2
        if (process != null && !processStopped) {
            this.killProcess(process);
        }
        try {
            this.cleanupInputHandling();
            this.cleanupOutputHandling();
            return n;
        }
        finally {
            if (process != null) {
                FileUtil.close(process.getErrorStream());
                FileUtil.close(process.getInputStream());
                FileUtil.close(process.getOutputStream());
            }
        }
        catch (IOException e) {
            try {
                throw new ResourceError("IOException while executing process with args: " + this.getBuilderCommand(), e);
                catch (InterruptedException e2) {
                    throw new InterruptedError("InterruptedException while executing process with args: " + this.getBuilderCommand(), e2);
                }
            }
            catch (Throwable throwable) {
                if (timer != null) {
                    timer.cancel();
                }
                AbstractProcessBuilder abstractProcessBuilder3 = this;
                // MONITORENTER : abstractProcessBuilder3
                this.threadToInterrupt = null;
                Thread.interrupted();
                // MONITOREXIT : abstractProcessBuilder3
                if (process != null && !processStopped) {
                    this.killProcess(process);
                }
                try {
                    this.cleanupInputHandling();
                    this.cleanupOutputHandling();
                    throw throwable;
                }
                finally {
                    if (process != null) {
                        FileUtil.close(process.getErrorStream());
                        FileUtil.close(process.getInputStream());
                        FileUtil.close(process.getOutputStream());
                    }
                }
            }
        }
    }

    protected void killProcess(Process process) {
        process.destroy();
    }

    protected void setupRedirections(ProcessBuilder builder) {
    }

    protected void setupInputHandling(OutputStream outputStream) {
        if (this.in == null) {
            FileUtil.close(outputStream);
            return;
        }
        this.inMuncher = new RawStreamMuncher(this.in, outputStream);
        this.inMuncher.start();
    }

    protected abstract void setupOutputHandling(InputStream var1, InputStream var2);

    protected abstract void cleanupOutputHandling();

    private void cleanupInputHandling() {
        if (this.inMuncher != null && this.inMuncher.isAlive()) {
            this.inMuncher.interrupt();
        }
    }

    protected void waitForMuncher(String which, Thread muncher, long timeout) {
        try {
            muncher.join(timeout);
        }
        catch (InterruptedException e) {
            Exceptions.ignore(e, "Further interruption attempts are ineffective -- we're already waiting for termination.");
        }
        if (muncher.isAlive()) {
            muncher.interrupt();
            logger.error("Standard {} stream hasn't closed {}s after termination of subprocess '{}'.", which, 20L, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void kill() {
        AbstractProcessBuilder abstractProcessBuilder = this;
        synchronized (abstractProcessBuilder) {
            this.interrupted = true;
            if (this.threadToInterrupt != null) {
                this.threadToInterrupt.interrupt();
            }
        }
    }

    public boolean processTimedOut() {
        return this.hitTimeout;
    }

    public String toString() {
        return AbstractProcessBuilder.commandLineToString(this.getBuilderCommand());
    }

    private List<String> getBuilderCommand() {
        return this.leakPrevention.cleanUpArguments(this.builder.command());
    }

    private static String commandLineToString(List<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : commandLine) {
            boolean tricky;
            boolean bl = tricky = s.isEmpty() || s.contains(" ");
            if (!first) {
                sb.append(" ");
            }
            first = false;
            if (tricky) {
                sb.append("\"");
            }
            sb.append(s.replace("\"", "\\\""));
            if (!tricky) continue;
            sb.append("\"");
        }
        return sb.toString();
    }
}

