/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.projectstructure;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.UserError;
import com.semmle.util.io.WholeIO;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProjectLayout {
    public static final char PROJECT_NAME_PREFIX = '@';
    private String project;
    private final LinkedHashMap<String, Section> sections = new LinkedHashMap();
    private String source;

    public ProjectLayout(File file) {
        this(StringUtil.lines(new WholeIO().strictread(file)), file.toString());
    }

    public ProjectLayout(String ... lines) {
        this(lines, (String)null);
    }

    private ProjectLayout(String[] lines, String source) {
        this.source = source;
        String virtual = "";
        Section section = new Section("");
        this.sections.put("", section);
        int num = 0;
        block5: for (String line : lines) {
            ++num;
            if ((line = line.trim()).isEmpty()) continue;
            switch (line.charAt(0)) {
                case '@': {
                    if (this.project != null) {
                        throw ProjectLayout.error("Only one project name is allowed", source, num);
                    }
                    this.project = ProjectLayout.tail(line);
                    continue block5;
                }
                case '#': {
                    virtual = ProjectLayout.tail(line);
                    if (this.sections.containsKey(virtual)) {
                        throw ProjectLayout.error("Duplicate virtual path prefix " + virtual, source, num);
                    }
                    section = new Section(virtual);
                    this.sections.put(virtual, section);
                    continue block5;
                }
                case '-': {
                    section.add(new Rewrite(ProjectLayout.tail(line), source, num));
                    continue block5;
                }
                default: {
                    section.add(new Rewrite(line, virtual, source, num));
                }
            }
        }
    }

    private static String tail(String line) {
        return line.substring(1).trim();
    }

    public String projectName() {
        if (this.project == null) {
            throw ProjectLayout.error("No project name is defined", this.source);
        }
        return this.project;
    }

    public String projectName(String defaultName) {
        return this.project == null ? defaultName : this.project;
    }

    public List<String> sections() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.sections.keySet());
        return result;
    }

    public boolean sectionIsEmpty(String section) {
        if (!this.sections.containsKey(section)) {
            throw new CatastrophicError("Section does not exist: " + section);
        }
        return this.sections.get(section).isEmpty();
    }

    public void renameSection(String oldName, String newName) {
        if (!this.sections.containsKey(oldName)) {
            throw new CatastrophicError("Section does not exist: " + oldName);
        }
        Section section = (Section)this.sections.remove(oldName);
        section.rename(newName);
        this.sections.put(newName, section);
    }

    public String subLayout(String sectionName) {
        Section section = this.sections.get(sectionName);
        if (section == null) {
            throw new CatastrophicError("Section does not exist: " + section);
        }
        return section.toLayout();
    }

    public String artificialPath(String path) {
        if (path.length() > 0 && path.charAt(0) != '/') {
            return null;
        }
        List prefixes = Section.prefixes(path);
        for (Section section : this.sections.values()) {
            Rewrite rewrite = section.match(prefixes);
            String rewritten = null;
            if (rewrite != null) {
                rewritten = rewrite.rewrite(path);
            }
            if (rewritten == null) continue;
            return rewritten;
        }
        return null;
    }

    public boolean includeFile(String path) {
        return this.artificialPath(path) != null;
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.project != null) {
            writer.write(64);
            writer.write(this.project);
            writer.write("\n");
        }
        for (Section section : this.sections.values()) {
            if (!section.virtual.isEmpty()) {
                writer.write("#");
                writer.write(section.virtual);
                writer.write("\n");
            }
            section.outputRules(writer);
        }
    }

    public void addPattern(String section, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("ProjectLayout.addPattern: pattern must be a non-empty string");
        }
        boolean exclude = pattern.charAt(0) == '-';
        Rewrite rewrite = exclude ? new Rewrite(pattern.substring(1), null, 0) : new Rewrite(pattern, section, null, 0);
        Section s = this.sections.get(section);
        if (s == null) {
            s = new Section(section);
            this.sections.put(section, s);
        }
        s.add(rewrite);
    }

    private static UserError error(String message, String source) {
        return ProjectLayout.error(message, source, 0);
    }

    private static UserError error(String message, String source, int line) {
        if (source == null) {
            return new UserError(message);
        }
        StringBuilder sb = new StringBuilder(message);
        sb.append(" (");
        if (line > 0) {
            sb.append("line ").append(line).append(" of ");
        }
        sb.append(source).append(")");
        return new UserError(sb.toString());
    }

    private static class Section {
        private String virtual;
        private final Map<String, Rewrite> simpleRewrites;
        private final List<Rewrite> complexRewrites;

        public Section(String virtual) {
            this.virtual = virtual;
            this.simpleRewrites = new LinkedHashMap<String, Rewrite>();
            this.complexRewrites = new ArrayList<Rewrite>();
        }

        public String toLayout() {
            StringWriter result = new StringWriter();
            result.append('@').append(this.virtual).append('\n');
            try {
                this.outputRules(result);
            }
            catch (IOException e) {
                throw new CatastrophicError("StringWriter.append threw an IOException", e);
            }
            return result.toString();
        }

        private void outputRules(Writer writer) throws IOException {
            ArrayList<Rewrite> all = new ArrayList<Rewrite>();
            all.addAll(this.simpleRewrites.values());
            all.addAll(this.complexRewrites);
            Collections.sort(all, Rewrite.COMPARATOR);
            for (Rewrite rewrite : all) {
                writer.append(rewrite.toString()).append('\n');
            }
        }

        public void rename(String newName) {
            this.virtual = newName;
            for (Rewrite rewrite : this.simpleRewrites.values()) {
                rewrite.virtual = newName;
            }
            for (Rewrite rewrite : this.complexRewrites) {
                rewrite.virtual = newName;
            }
        }

        public void add(Rewrite rewrite) {
            int index = this.simpleRewrites.size() + this.complexRewrites.size();
            rewrite.setIndex(index);
            if (rewrite.isSimple()) {
                this.simpleRewrites.put(rewrite.simplePrefix(), rewrite);
            } else {
                this.complexRewrites.add(rewrite);
            }
        }

        public boolean isEmpty() {
            return this.simpleRewrites.isEmpty() && this.complexRewrites.isEmpty();
        }

        private static List<String> prefixes(String path) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(path);
            int i = path.length();
            while (i > 1) {
                i = path.lastIndexOf(47, i - 1);
                result.add(path.substring(0, i));
            }
            result.add("/");
            return result;
        }

        public Rewrite match(List<String> prefixes) {
            Rewrite best = null;
            for (String prefix : prefixes) {
                Rewrite match = this.simpleRewrites.get(prefix);
                if (match == null || best != null && best.index >= match.index) continue;
                best = match;
            }
            for (int i = this.complexRewrites.size() - 1; i >= 0; --i) {
                Rewrite rewrite = this.complexRewrites.get(i);
                if (!rewrite.matches(prefixes.get(0))) continue;
                if (best != null && best.index >= rewrite.index) break;
                best = rewrite;
                break;
            }
            return best;
        }
    }

    private static class Rewrite {
        private static final Comparator<Rewrite> COMPARATOR = new Comparator<Rewrite>(){

            @Override
            public int compare(Rewrite t, Rewrite o) {
                if (t.index < o.index) {
                    return -1;
                }
                if (t.index == o.index) {
                    return 0;
                }
                return 1;
            }
        };
        private int index;
        private final String original;
        private final Pattern pattern;
        private String virtual;
        private final String simple;
        private static final Pattern verifyStars = Pattern.compile(".*(?:\\*\\*[^/].*|\\*\\*$|[^/]\\*\\*.*)");

        public Rewrite(String exclude, String source, int line) {
            this.original = '-' + exclude;
            if (!exclude.startsWith("/")) {
                exclude = '/' + exclude;
            }
            if (exclude.indexOf("//") != -1) {
                throw ProjectLayout.error("Illegal '//' in exclude path", source, line);
            }
            if (verifyStars.matcher(exclude).matches()) {
                throw ProjectLayout.error("Illegal use of '**' in exclude path", source, line);
            }
            if (exclude.endsWith("/")) {
                exclude = exclude.substring(0, exclude.length() - 1);
            }
            this.pattern = Rewrite.compilePrefix(exclude);
            if ((exclude = exclude.replace("//", "/")).length() > 1 && exclude.endsWith("/")) {
                exclude = exclude.substring(0, exclude.length() - 1);
            }
            this.simple = exclude.contains("*") ? null : exclude;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Rewrite(String include, String virtual, String source, int line) {
            int doubleslash;
            this.original = include;
            if (!include.startsWith("/")) {
                include = '/' + include;
            }
            if ((doubleslash = include.indexOf("//")) != include.lastIndexOf("//")) {
                throw ProjectLayout.error("More than one '//' in include path", source, line);
            }
            if (verifyStars.matcher(include).matches()) {
                throw ProjectLayout.error("Illegal use of '**' in include path", source, line);
            }
            if (!virtual.startsWith("/")) {
                virtual = "/" + virtual;
            }
            if (virtual.endsWith("/")) {
                virtual = virtual.substring(0, virtual.length() - 1);
            }
            this.virtual = virtual;
            this.pattern = Rewrite.compilePrefix(include);
            if ((include = include.replace("//", "/")).length() > 1 && include.endsWith("/")) {
                include = include.substring(0, include.length() - 1);
            }
            this.simple = include.contains("*") ? null : include;
        }

        private static Pattern compilePrefix(String pattern) {
            if ((pattern = (pattern = StringUtil.escapeStringLiteralForRegexp(pattern, "*")).contains("//") ? pattern.replace("//", "(/") : "(" + pattern).endsWith("/")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            pattern = pattern.replace("/**", "-///-").replace("*", "[^/]*").replace("-///-", "(?:|/.*)");
            return Pattern.compile(pattern + "(?:/.*|$))");
        }

        public boolean isSimple() {
            return this.simple != null;
        }

        public String simplePrefix() {
            return this.simple;
        }

        public boolean matches(String path) {
            return this.pattern.matcher(path).matches();
        }

        public String rewrite(String path) {
            if (this.virtual == null) {
                return null;
            }
            Matcher matcher = this.pattern.matcher(path);
            if (!matcher.matches()) {
                return null;
            }
            return this.virtual + matcher.group(1);
        }

        public String toString() {
            return this.original;
        }
    }
}

