/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.trap.pathtransformers;

import com.semmle.util.files.FileUtil;
import com.semmle.util.process.Env;
import com.semmle.util.trap.pathtransformers.NoopTransformer;
import com.semmle.util.trap.pathtransformers.ProjectLayoutTransformer;
import java.io.File;
import java.util.regex.Pattern;

public abstract class PathTransformer {
    private static final Pattern SPECIAL_PATH = Pattern.compile("^[/\\\\]modules[/\\\\].*");
    private static final PathTransformer DEFAULT_TRANSFORMER;

    public abstract String transform(String var1);

    public String fileAsDatabaseString(File file) {
        String path = file.getPath();
        if (SPECIAL_PATH.matcher(path).matches()) {
            return path.replace('\\', '/');
        }
        path = Boolean.valueOf(Env.systemEnv().get(Env.Var.SEMMLE_PRESERVE_SYMLINKS)) != false ? FileUtil.simplifyPath(file) : FileUtil.tryMakeCanonical(file).getPath();
        return this.transform(FileUtil.normalisePath(path));
    }

    public File canonicalFile(String path) {
        return new File(this.fileAsDatabaseString(new File(path)));
    }

    public static PathTransformer std() {
        return DEFAULT_TRANSFORMER;
    }

    static {
        String layout = Env.systemEnv().get(Env.Var.SEMMLE_PATH_TRANSFORMER);
        DEFAULT_TRANSFORMER = layout == null ? new NoopTransformer() : new ProjectLayoutTransformer(new File(layout));
    }
}

