/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.xml;

import com.semmle.util.exception.UserError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XmlErrorHandler {
    private List<String> errors = new ArrayList<String>();

    public void report(String error) {
        this.errors.add(error);
    }

    public List<String> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean successful() {
        return this.errors.isEmpty();
    }

    public void reportErrorsIfAny(String xmlResource) {
        if (!this.successful()) {
            throw new UserError("Error processing " + xmlResource + ": " + this.toString());
        }
    }

    public String toString() {
        if (this.errors.isEmpty()) {
            return "no errors were found";
        }
        if (this.errors.size() == 1) {
            return this.errors.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("the following errors were detected:");
        for (String error : this.errors) {
            sb.append("\n  - ").append(error);
        }
        return sb.toString();
    }
}

