/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.xml;

import com.semmle.util.exception.ResourceError;
import com.semmle.util.exception.UserError;
import com.semmle.util.expansion.ExpansionEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlNode {
    private final Document document;
    private final Element element;
    private ExpansionEnvironment env;

    public XmlNode(Document document, Element element) {
        this.document = document;
        this.element = element;
    }

    public static XmlNode fromInputStream(InputStream is) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ResourceError("Could not create XML document builder while trying to read XML", e);
        }
        try {
            Document doc = db.parse(is);
            return new XmlNode(doc, doc.getDocumentElement());
        }
        catch (SAXParseException e) {
            throw new UserError("Error parsing XML: " + e.getMessage() + " (at line " + e.getLineNumber() + " and column " + e.getColumnNumber() + ")");
        }
        catch (SAXException e) {
            throw new ResourceError("Error parsing XML", e);
        }
        catch (IOException e) {
            throw new ResourceError("Error while reading XML", e);
        }
    }

    public static XmlNode fromFile(File f) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ResourceError("Could not create XML document builder while trying to read XML file " + f, e);
        }
        try {
            Document doc = db.parse(f);
            return new XmlNode(doc, doc.getDocumentElement());
        }
        catch (SAXParseException e) {
            throw new UserError("Error parsing XML file " + f + ": " + e.getMessage() + " (at line " + e.getLineNumber() + " and column " + e.getColumnNumber() + ")");
        }
        catch (SAXException e) {
            throw new ResourceError("Error parsing XML file " + f, e);
        }
        catch (IOException e) {
            throw new ResourceError("Error while reading XML file " + f, e);
        }
    }

    public static XmlNode fromString(String s) {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ResourceError("Could not create XML document builder while trying to read XML", e);
        }
        try {
            Document doc = db.parse(new InputSource(new StringReader(s)));
            return new XmlNode(doc, doc.getDocumentElement());
        }
        catch (SAXParseException e) {
            throw new UserError("Error parsing XML: " + e.getMessage() + " (at line " + e.getLineNumber() + " and column " + e.getColumnNumber() + ")");
        }
        catch (SAXException e) {
            throw new UserError("Error parsing XML", e);
        }
        catch (IOException e) {
            throw new ResourceError("Error while reading XML", e);
        }
    }

    public List<XmlNode> children() {
        ArrayList<XmlNode> children = new ArrayList<XmlNode>();
        NodeList nodes = this.element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            XmlNode child = new XmlNode(this.document, (Element)n);
            child.setExpansionEnvironment(this.env);
            children.add(child);
        }
        return children;
    }

    public boolean is(String name) {
        return name.equals(this.name());
    }

    public String name() {
        return this.element.getNodeName();
    }

    public boolean hasAttribute(String key) {
        return this.element.hasAttribute(key);
    }

    public String attribute(String key) {
        return this.element.getAttribute(key);
    }

    public String expandedAttribute(String key) {
        return this.expand(this.attribute(key));
    }

    public String textContent() {
        return this.element.getTextContent();
    }

    public String expandedTextContent() {
        return this.expand(this.textContent());
    }

    public Integer intContent() {
        try {
            return Integer.valueOf(this.textContent());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer expandedIntContent() {
        try {
            return Integer.valueOf(this.expandedTextContent());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Element getDomElement() {
        return this.element;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        NamedNodeMap atts = this.element.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr attribute = (Attr)atts.item(i);
            result.put(attribute.getName(), attribute.getValue());
        }
        return result;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setExpansionEnvironment(ExpansionEnvironment env) {
        this.env = env;
    }

    private String expand(String value) {
        if (this.env == null) {
            return value;
        }
        return this.env.strExpand(value);
    }
}

