/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.xml;

import com.semmle.util.xml.XmlEscape;
import com.semmle.util.xml.XmlNode;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

public class XmlPrinter
implements Closeable {
    private StringWriter writer = null;
    protected PrintWriter printer;
    private boolean useIndent = true;
    private int indent = 0;

    public XmlPrinter() {
        this.writer = new StringWriter();
        this.printer = new PrintWriter(this.writer);
    }

    public XmlPrinter(Writer writer) {
        this.printer = new PrintWriter(writer);
    }

    public void disableIndentation() {
        this.useIndent = false;
    }

    @Override
    public void close() {
        this.printer.close();
    }

    public void flush() {
        this.printer.flush();
    }

    public String toString() {
        if (this.writer != null) {
            return this.writer.toString();
        }
        return "<xmlDocumentWasNotKeptInMemory/>";
    }

    public void newLine() {
        this.printer.println();
    }

    public void open(String element, String ... attributes) {
        this.openImpl(element, true, false, attributes);
    }

    public void openAndClose(String element, String ... attributes) {
        this.openImpl(element, true, true, attributes);
    }

    public void close(String element) {
        this.closeImpl(true, element);
    }

    protected void closeImpl(boolean newline, String element) {
        if (newline) {
            this.dec();
            this.indent();
        }
        this.printer.append("</");
        this.printer.append(element);
        this.printer.append(">");
        if (newline) {
            this.printer.append("\n");
        }
    }

    public void elementWithContent(String element, Object content, String ... attributes) {
        this.openImpl(element, false, false, attributes);
        String printed = content == null ? "null" : content.toString();
        this.printer.append(XmlPrinter.escapeChars(printed));
        this.closeImpl(false, element);
        this.printer.append("\n");
    }

    public void domElement(XmlNode node) {
        Map<String, String> atts = node.getAttributes();
        String[] attributes = new String[2 * atts.size()];
        int i = 0;
        for (Map.Entry<String, String> e : atts.entrySet()) {
            attributes[i++] = e.getKey();
            attributes[i++] = e.getValue();
        }
        this.open(node.name(), attributes);
        for (XmlNode child : node.children()) {
            this.domElement(child);
        }
        this.close(node.name());
    }

    private void openImpl(String element, boolean newline, boolean close, String ... attributes) {
        if (attributes.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid key/value mapping list: " + Arrays.toString(attributes) + " for XML element " + element);
        }
        this.indent();
        this.printer.append("<");
        this.printer.append(element);
        for (int i = 0; i < attributes.length; i += 2) {
            String key = attributes[i];
            String value = XmlPrinter.escapeAttribute(attributes[i + 1]);
            this.printer.append(' ');
            this.printer.append(key);
            this.printer.append("=");
            this.printer.append(value);
        }
        this.printer.append(close ? "/>" : ">");
        if (newline) {
            this.printer.append("\n");
        }
        if (!close && newline) {
            this.inc();
        }
    }

    protected void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.printer.append(' ');
        }
    }

    private void inc() {
        if (this.useIndent) {
            this.indent += 2;
        }
    }

    private void dec() {
        if (this.useIndent) {
            this.indent = this.indent > 0 ? (this.indent -= 2) : 0;
        }
    }

    private static String escapeChars(String s) {
        return XmlPrinter.escape(s, '<', '&', '>');
    }

    private static String escapeAttribute(String value) {
        boolean hasSingleQuote;
        boolean hasDoubleQuote = value.indexOf(34) != -1;
        boolean bl = hasSingleQuote = value.indexOf(39) != -1;
        if (hasDoubleQuote && !hasSingleQuote) {
            return "'" + XmlPrinter.escape(value, '<', '&', '>') + "'";
        }
        if (!hasDoubleQuote) {
            return "\"" + XmlPrinter.escape(value, '<', '&', '>') + "\"";
        }
        return "\"" + XmlPrinter.escape(value, '<', '&', '>', '\"') + "\"";
    }

    private static String escape(String s, char ... forbidden) {
        s = XmlEscape.removeIllegalControlCharacters(s);
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean wasForbidden = false;
            for (char aForbidden : forbidden) {
                if (aForbidden != c) continue;
                wasForbidden = true;
                break;
            }
            if (wasForbidden) {
                sb.append(XmlPrinter.escapeChar(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String escapeChar(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\"': {
                return "&quot;";
            }
        }
        return "&" + c + ";";
    }
}

