/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import uk.co.flamingpenguin.jewel.cli.ArgumentPresenter;
import uk.co.flamingpenguin.jewel.cli.ArgumentSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionNotPresentException;
import uk.co.flamingpenguin.jewel.cli.OptionSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.TypedArguments;
import uk.co.flamingpenguin.jewel.cli.Unparsed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentPresenterImpl<O>
implements ArgumentPresenter<O> {
    private final OptionsSpecification<O> m_specification;
    private final Class<O> m_klass;

    public ArgumentPresenterImpl(Class<O> klass, OptionsSpecification<O> specification) {
        this.m_specification = specification;
        this.m_klass = klass;
    }

    @Override
    public O presentArguments(final TypedArguments arguments) {
        Object result = Proxy.newProxyInstance(this.m_klass.getClassLoader(), new Class[]{this.m_klass}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null && args.length != 0) {
                    throw new UnsupportedOperationException(String.format("Method (%s) with arguments not supported for reading argument values", method.toGenericString()));
                }
                if (method.isAnnotationPresent(Unparsed.class)) {
                    return arguments.getUnparsedValue();
                }
                if (ArgumentPresenterImpl.this.m_specification.hasUnparsedSpecification() && ArgumentPresenterImpl.this.m_specification.getUnparsedSpecification().isOptional() && ArgumentPresenterImpl.this.m_specification.getUnparsedSpecification().getOptionalityMethod().equals(method)) {
                    return arguments.hasUnparsedValue();
                }
                if (!ArgumentPresenterImpl.this.m_specification.isSpecified(method)) {
                    throw new UnsupportedOperationException(String.format("Method (%s) is not annotated for option specification", method.toGenericString()));
                }
                OptionSpecification specification = ArgumentPresenterImpl.this.m_specification.getSpecification(method);
                if (ArgumentPresenterImpl.this.m_specification.isExistenceChecker(method) || !specification.hasValue()) {
                    return this.optionPresent(arguments, specification);
                }
                return this.getValue(arguments, method, specification);
            }

            private Object optionPresent(TypedArguments arguments2, ArgumentSpecification specification) {
                return arguments2.contains(specification);
            }

            private Object getValue(TypedArguments arguments2, Method method, ArgumentSpecification specification) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                Object value = arguments2.getValue(specification);
                if (value == null) {
                    throw new OptionNotPresentException(specification);
                }
                return value;
            }
        });
        return (O)result;
    }
}

