/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.ArgumentsImpl;
import uk.co.flamingpenguin.jewel.cli.ParsedArguments;

class ParsedArgumentsBuilder {
    private final Map<String, List<String>> m_arguments = new LinkedHashMap<String, List<String>>();
    private List<String> m_currentValues;
    private final List<String> m_unparsed = new ArrayList<String>();
    private boolean m_moreOptionsExpected = true;

    ParsedArgumentsBuilder() {
    }

    public void add(String argument) throws ArgumentValidationException {
        if (argument.length() > 1 && argument.startsWith("-")) {
            if (argument.length() > 2 && argument.startsWith("--")) {
                if (argument.contains("=")) {
                    int separatorIndex = argument.indexOf("=");
                    this.addOption(argument.substring(2, separatorIndex).trim());
                    if (argument.length() > separatorIndex + 1) {
                        this.addValue(argument.substring(separatorIndex + 1).trim());
                    }
                } else {
                    this.addOption(argument.substring(2, argument.length()).trim());
                }
            } else {
                for (int i = 1; i < argument.length(); ++i) {
                    this.addOption(argument.substring(i, i + 1));
                }
            }
        } else {
            this.addValue(argument);
        }
    }

    private void addValue(String value) {
        if (this.m_currentValues == null) {
            this.m_moreOptionsExpected = false;
            this.m_unparsed.add(value);
        } else {
            this.m_currentValues.add(value);
        }
    }

    private void addOption(final String option) throws ArgumentValidationException {
        if (!this.m_moreOptionsExpected) {
            throw new ArgumentValidationException(new ArgumentValidationException.ValidationError(){

                public ArgumentValidationException.ValidationError.ErrorType getErrorType() {
                    return ArgumentValidationException.ValidationError.ErrorType.MisplacedOption;
                }

                public String getMessage() {
                    return option;
                }

                public String toString() {
                    return String.format("Option not expected in this position: %s", this.getMessage());
                }
            });
        }
        this.m_currentValues = new ArrayList<String>();
        this.m_arguments.put(option, this.m_currentValues);
    }

    public void setUnparsed(String[] unparsed) {
        this.m_unparsed.addAll(Arrays.asList(unparsed));
    }

    public ParsedArguments getParsedArguments() {
        LinkedHashMap<String, List<String>> finalArguments = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.m_arguments.entrySet()) {
            finalArguments.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return new ArgumentsImpl(finalArguments, new ArrayList<String>(this.m_unparsed));
    }
}

