/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.expansion;

import com.semmle.util.data.StringUtil;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.exception.UserError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.process.Builder;
import com.semmle.util.process.Env;
import com.semmle.util.process.LeakPrevention;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpansionEnvironment {
    private final Map<String, String> vars = new LinkedHashMap<String, String>();
    private final Set<String> unexpandedVars = new LinkedHashSet<String>();
    private final boolean commandSubstitutions;

    public ExpansionEnvironment(boolean bl) {
        this.commandSubstitutions = bl;
    }

    @Deprecated
    public ExpansionEnvironment() {
        this(true);
    }

    public ExpansionEnvironment(boolean bl, Map<String, String> map) {
        this(bl);
        this.vars.putAll(map);
    }

    public ExpansionEnvironment(ExpansionEnvironment expansionEnvironment) {
        this(expansionEnvironment.commandSubstitutions);
        this.vars.putAll(expansionEnvironment.vars);
        this.unexpandedVars.addAll(expansionEnvironment.unexpandedVars);
    }

    public void defineVars(Map<String, String> map) {
        this.vars.putAll(map);
    }

    public void defineVar(String string, String string2) {
        this.vars.put(string, string2);
    }

    public void defineVarsFromFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            throw new ResourceError(file + " is a directory, cannot load variables from it.");
        }
        Properties properties = FileUtil.loadProperties(file);
        for (String string : properties.stringPropertyNames()) {
            this.defineVar(string, properties.getProperty(string));
        }
    }

    public void defineVarsFromEnvironment(Env env) {
        String string = env.get(Env.Var.ODASA_EXTRA_VARIABLES);
        if (string != null) {
            this.defineVarsFromFile(new File(string));
        }
        for (Map.Entry<String, String> entry : env.getenv().entrySet()) {
            this.defineVar("env." + entry.getKey(), entry.getValue().replace("$", "${}"));
        }
        env.addEnvironmentToNewEnv(this);
    }

    public void doNotExpand(String ... stringArray) {
        for (String string : stringArray) {
            this.unexpandedVars.add(string);
        }
    }

    public void setDefault(String string, String string2) {
        if (!this.vars.containsKey(string)) {
            this.vars.put(string, string2);
        }
    }

    public String strExpand(String string) {
        try {
            return new Expander().new Expander.ExpansionParser(string).parseAsString().expandAsString();
        }
        catch (UserError userError) {
            throw new UserError("Failed to expand '" + string + "'.", userError);
        }
    }

    public List<String> listExpand(String string) {
        try {
            return new Expander().new Expander.ExpansionParser(string).parseAsList().expandAsList();
        }
        catch (UserError userError) {
            throw new UserError("Failed to expand '" + string + "' as an argument list.", userError);
        }
    }

    public String strExpandVar(String string) {
        return new Expander().new Expander.Variable(string).expandAsString();
    }

    public List<String> listExpandVar(String string) {
        return new Expander().new Expander.SplitVariable(string).expandAsList();
    }

    public void validate(String string) {
        new Expander().new Expander.ExpansionParser(string).parseAsList().validate();
    }

    public synchronized String varLookup(String string) {
        String string2 = this.vars.get(string);
        if (string2 == null) {
            ArrayList<String> arrayList = new ArrayList<String>(this.vars.keySet());
            Collections.sort(arrayList);
            throw new UserError("Attempting to expand unknown variable: " + string + ", available variables are: " + arrayList);
        }
        return string2;
    }

    public boolean definesVar(String string) {
        return this.vars.containsKey(string);
    }

    public File expandPath(File file, String string) {
        String string2 = this.strExpand(string);
        if (FileUtil.isAbsolute(string2)) {
            return new File(string2);
        }
        return FileUtil.fileRelativeTo(file, string2);
    }

    public static String escape(String string) {
        return string.replace("$", "${}");
    }

    public static String escapeArgument(String string) {
        return ExpansionEnvironment.escape(string).replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\")).replaceAll(Matcher.quoteReplacement("\""), Matcher.quoteReplacement("\\\""));
    }

    private class Expander {
        private final Set<String> expansionsInProgress = new LinkedHashSet<String>();

        private Expander() {
        }

        private class ExpansionParser {
            private final ExpansionTokeniser tokens;

            public ExpansionParser(String string) {
                this.tokens = new ExpansionTokeniser(string);
            }

            public Sentence parseAsString() {
                ArrayList<List<Expansion>> arrayList = new ArrayList<List<Expansion>>();
                arrayList.add(this.parseTerminatedString(null));
                return new Sentence(arrayList);
            }

            public Sentence parseAsList() {
                return new Sentence(this.parseTerminatedList(null, false));
            }

            public Sentence splitAsString() {
                return new Sentence(this.parseTerminatedList(null, true));
            }

            private List<Expansion> parseTerminatedString(String string) {
                ArrayList<Expansion> arrayList = new ArrayList<Expansion>();
                while (this.tokens.hasMoreTokens()) {
                    String string2 = this.tokens.nextToken();
                    if (string2.equals(string)) {
                        return arrayList;
                    }
                    if (string2.equals("\\\"")) {
                        arrayList.add(new Literal("\""));
                        continue;
                    }
                    if (string2.equals("\\\\")) {
                        arrayList.add(new Literal("\\"));
                        continue;
                    }
                    if (this.tryParseExpansion(arrayList, string2)) continue;
                    arrayList.add(new Literal(string2));
                }
                if (string != null) {
                    throw new UserError("Premature end of input while looking for matching '" + string + "'.");
                }
                return arrayList;
            }

            private List<List<Expansion>> parseTerminatedList(String string, boolean bl) {
                ArrayList<List<Expansion>> arrayList = new ArrayList<List<Expansion>>();
                ArrayList<Expansion> arrayList2 = new ArrayList<Expansion>();
                boolean bl2 = false;
                while (this.tokens.hasMoreTokens()) {
                    String string2 = this.tokens.nextToken();
                    if (string2.equals(string)) {
                        if (arrayList2.size() > 0) {
                            arrayList.add(arrayList2);
                        }
                        return arrayList;
                    }
                    if (bl2 && !Character.isWhitespace(string2.charAt(0))) {
                        throw new UserError("The quoted string ending at " + this.tokens.pos() + " must be surrounded by whitespace.");
                    }
                    if (string2.length() > 0 && Character.isWhitespace(string2.charAt(0))) {
                        bl2 = false;
                        if (arrayList2.size() <= 0) continue;
                        arrayList.add(arrayList2);
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    if (string2.equals("\"")) {
                        if (!arrayList2.isEmpty()) {
                            throw new UserError("At position " + this.tokens.pos() + ", the quote should either be preceded by a space (if it is intended to start an argument) or escaped as \\\".");
                        }
                        arrayList2.add(new QuotedString(this.parseTerminatedString("\"")));
                        arrayList.add(arrayList2);
                        arrayList2 = new ArrayList();
                        bl2 = true;
                        continue;
                    }
                    if (string2.equals("\\\"")) {
                        arrayList2.add(new Literal("\""));
                        continue;
                    }
                    if (string2.equals("\\\\")) {
                        arrayList2.add(new Literal("\\"));
                        continue;
                    }
                    if (!bl && this.tryParseExpansion(arrayList2, string2)) continue;
                    arrayList2.add(new Literal(string2));
                }
                if (string != null) {
                    throw new UserError("Premature end of expansion while looking for '" + string + "'.");
                }
                if (arrayList2.size() > 0) {
                    arrayList.add(arrayList2);
                }
                return arrayList;
            }

            private boolean tryParseExpansion(List<Expansion> list, String string) {
                if (string.equals("${}")) {
                    list.add(new Literal("$"));
                } else if (string.equals("$(=") && ExpansionEnvironment.this.commandSubstitutions) {
                    list.add(new SplitCommand(this.parseTerminatedList(")", false)));
                } else if (string.equals("$(") && ExpansionEnvironment.this.commandSubstitutions) {
                    list.add(new Command(this.parseTerminatedList(")", false)));
                } else if (string.equals("${=")) {
                    list.add(new SplitVariable(this.parseVarName()));
                } else if (string.equals("${")) {
                    list.add(new Variable(this.parseVarName()));
                } else {
                    if (string.equals("$")) {
                        throw new UserError("Malformed expansion: A standalone '$' character should be escaped as '${}'.");
                    }
                    return false;
                }
                return true;
            }

            protected String parseVarName() {
                if (!this.tokens.hasMoreTokens()) {
                    throw new UserError("Malformed variable substitution: stray '${' at " + this.tokens.pos());
                }
                String string = this.tokens.nextToken();
                if (this.tokens.isDelimiter(string)) {
                    throw new UserError("Malformed variable substitution: Unexpected '" + string + "' at " + this.tokens.pos());
                }
                if (!this.tokens.hasMoreTokens()) {
                    throw new UserError("Malformed variable substitution for '" + string + "': Missing '}' at " + this.tokens.pos());
                }
                String string2 = this.tokens.nextToken();
                if (!string2.equals("}")) {
                    throw new UserError("Malformed variable substitution: Expecting '}' at " + this.tokens.pos() + ", found '" + string2 + "'.");
                }
                return string;
            }
        }

        class SplitCommand
        extends Command {
            public SplitCommand(List<List<Expansion>> list) {
                super(list);
            }

            @Override
            public String expandAsString() {
                return StringUtil.glue(" ", this.expandAsList());
            }

            @Override
            public List<String> expandAsList() {
                return new ExpansionParser(this.run()).splitAsString().expandAsList();
            }
        }

        class Command
        extends Expansion {
            private final Sentence argv;

            public Command(List<List<Expansion>> list) {
                this.argv = new Sentence(list);
            }

            @Override
            public void validate() {
                this.argv.validate();
            }

            protected String run() {
                List<String> list = this.argv.expandAsList();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                Builder builder = new Builder(list, byteArrayOutputStream, byteArrayOutputStream2);
                builder.setLeakPrevention(LeakPrevention.ALL);
                try {
                    int n = builder.execute();
                    if (n != 0) {
                        throw new UserError("Exit code " + n + " from command " + builder.toString());
                    }
                    if (byteArrayOutputStream2.size() > 0) {
                        throw new UserError("Command \"" + builder.toString() + "\" produced output on stderr: " + byteArrayOutputStream2.toString());
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new UserError("Could not execute command " + builder.toString(), runtimeException);
                }
                return byteArrayOutputStream.toString();
            }

            @Override
            public String expandAsString() {
                return this.run();
            }

            @Override
            public List<String> expandAsList() {
                return Collections.singletonList(this.expandAsString());
            }
        }

        class SplitVariable
        extends Variable {
            public SplitVariable(String string) {
                super(string);
            }

            @Override
            protected String ref() {
                return "${=" + this.name + "}";
            }

            @Override
            public String expandAsStringImpl() {
                return StringUtil.glue(" ", this.expandAsListImpl());
            }

            @Override
            public List<String> expandAsListImpl() {
                return ExpansionEnvironment.this.listExpand(ExpansionEnvironment.this.varLookup(this.name));
            }
        }

        class Variable
        extends Expansion {
            protected final String name;

            public Variable(String string) {
                this.name = string;
            }

            @Override
            public void validate() {
                ExpansionEnvironment.this.varLookup(this.name);
            }

            protected void startExpanding(String string) {
                if (!Expander.this.expansionsInProgress.add(string)) {
                    throw new UserError("Circular expansion of variable " + string);
                }
            }

            protected void doneWith(String string) {
                if (!Expander.this.expansionsInProgress.remove(string)) {
                    throw new CatastrophicError("Not currently expanding " + string);
                }
            }

            protected String ref() {
                return "${" + this.name + "}";
            }

            @Override
            public final String expandAsString() {
                if (ExpansionEnvironment.this.unexpandedVars.contains(this.name)) {
                    return this.ref();
                }
                this.startExpanding(this.name);
                String string = this.expandAsStringImpl();
                this.doneWith(this.name);
                return string;
            }

            public String expandAsStringImpl() {
                return new ExpansionParser(ExpansionEnvironment.this.varLookup(this.name)).parseAsString().expandAsString();
            }

            @Override
            public final List<String> expandAsList() {
                if (ExpansionEnvironment.this.unexpandedVars.contains(this.name)) {
                    return Collections.singletonList(this.ref());
                }
                this.startExpanding(this.name);
                List<String> list = this.expandAsListImpl();
                this.doneWith(this.name);
                return list;
            }

            public List<String> expandAsListImpl() {
                return Collections.singletonList(this.expandAsStringImpl());
            }
        }

        class QuotedString
        extends Sentence {
            public QuotedString(List<Expansion> list) {
                super(Collections.singletonList(list));
            }

            @Override
            public List<String> expandAsList() {
                return Collections.singletonList(this.expandAsString());
            }
        }

        class Literal
        extends Expansion {
            private final String value;

            public Literal(String string) {
                this.value = string;
            }

            @Override
            public void validate() {
            }

            @Override
            public String expandAsString() {
                return this.value;
            }

            @Override
            public List<String> expandAsList() {
                return Collections.singletonList(this.value);
            }
        }

        class Sentence
        extends Expansion {
            private final List<List<Expansion>> words;

            public Sentence(List<List<Expansion>> list) {
                this.words = new ArrayList<List<Expansion>>();
                this.words.addAll(list);
            }

            @Override
            public void validate() {
                for (List<Expansion> list : this.words) {
                    for (Expansion expansion : list) {
                        expansion.validate();
                    }
                }
            }

            private String expandWord(List<Expansion> list) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Expansion expansion : list) {
                    stringBuilder.append(expansion.expandAsString());
                }
                return stringBuilder.toString();
            }

            @Override
            public String expandAsString() {
                StringBuilder stringBuilder = new StringBuilder();
                for (List<Expansion> list : this.words) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(this.expandWord(list));
                }
                return stringBuilder.toString();
            }

            @Override
            public List<String> expandAsList() {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (List<Expansion> list : this.words) {
                    ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
                    for (Expansion expansion : list) {
                        arrayList2.add(expansion.expandAsList());
                    }
                    arrayList.addAll(this.glue(arrayList2));
                }
                return arrayList;
            }

            private List<String> glue(List<List<String>> list) {
                String string = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (List<String> list2 : list) {
                    string = this.glue_join_accum(arrayList, list2, string);
                }
                if (string != null) {
                    arrayList.add(string);
                }
                return arrayList;
            }

            private String glue_join_accum(List<String> list, List<String> list2, String string) {
                int n = list2.size();
                switch (n) {
                    case 0: {
                        return string;
                    }
                    case 1: {
                        return this.combine(string, list2.get(0));
                    }
                }
                list.add(this.combine(string, list2.get(0)));
                list.addAll(list2.subList(1, n - 1));
                return list2.get(n - 1);
            }

            private String combine(String string, String string2) {
                if (string == null) {
                    return string2;
                }
                return string + string2;
            }
        }

        abstract class Expansion {
            Expansion() {
            }

            public abstract String expandAsString();

            public abstract List<String> expandAsList();

            public abstract void validate();
        }
    }

    private static class ExpansionTokeniser {
        private static final Pattern delims = Pattern.compile("\\\\\\\\|\\\\\"|\"|\\$\\{\\}|\\$\\{=|\\$\\{|\\$\\(=|\\$\\(|\\$|\\}|\\)|\\s+");
        private final List<String> tokens = new ArrayList<String>();
        private final int[] positions;
        private int nextToken = 0;

        public ExpansionTokeniser(String string) {
            Matcher matcher = delims.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "");
                if (stringBuffer.length() > 0) {
                    this.tokens.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                this.tokens.add(matcher.group());
            }
            matcher.appendTail(stringBuffer);
            if (stringBuffer.length() > 0) {
                this.tokens.add(stringBuffer.toString());
            }
            this.positions = new int[this.tokens.size()];
            int n = 0;
            for (int i = 0; i < this.tokens.size(); ++i) {
                this.positions[i] = n;
                n += this.tokens.get(i).length();
            }
        }

        public boolean hasMoreTokens() {
            return this.nextToken < this.tokens.size();
        }

        public String nextToken() {
            return this.tokens.get(this.nextToken++);
        }

        public boolean isDelimiter(String string) {
            return delims.matcher(string).matches();
        }

        public int pos() {
            return this.positions[this.nextToken - 1] + 1;
        }
    }

    public static interface VariableSource {
        public void fillIn(ExpansionEnvironment var1);
    }
}

