/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVWriter
implements Closeable {
    private static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    private static final char NO_ESCAPE_CHARACTER = '\u0000';
    private static final String DEFAULT_LINE_END = "\n";
    private boolean[] eagerQuotingFlags = new boolean[0];

    public CSVWriter(Writer writer) {
        this(writer, ',', '\"', '\"');
    }

    public CSVWriter(Writer writer, char c, char c2, char c3) {
        this(writer, c, c2, c3, DEFAULT_LINE_END);
    }

    private CSVWriter(Writer writer, char c, char c2, char c3, String string) {
        this.rawWriter = writer;
        this.separator = c;
        this.quotechar = c2;
        this.escapechar = c3;
        this.lineEnd = string;
    }

    public void setEagerQuotingColumns(boolean ... blArray) {
        this.eagerQuotingFlags = blArray;
    }

    public void writeAll(List<String[]> list) throws IOException {
        for (String[] stringArray : list) {
            this.writeNext(stringArray);
        }
    }

    public void writeNext(String ... stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i != 0) {
                stringBuilder.append(this.separator);
            }
            if ((string = stringArray[i]) == null) continue;
            boolean bl = this.stringContainsSpecialCharacters(string);
            if (bl || i >= this.eagerQuotingFlags.length || this.eagerQuotingFlags[i] || this.stringContainsSomewhatSpecialCharacter(string)) {
                if (this.quotechar != '\u0000') {
                    stringBuilder.append(this.quotechar);
                }
                stringBuilder.append(bl ? this.processLine(string) : string);
                if (this.quotechar == '\u0000') continue;
                stringBuilder.append(this.quotechar);
                continue;
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(this.lineEnd);
        this.rawWriter.write(stringBuilder.toString());
    }

    private boolean stringContainsSpecialCharacters(String string) {
        return string.indexOf(this.quotechar) != -1 || string.indexOf(this.escapechar) != -1;
    }

    private boolean stringContainsSomewhatSpecialCharacter(String string) {
        return string.indexOf(34) != -1 || string.indexOf(39) != -1 || string.indexOf(9) != -1 || string.indexOf(this.separator) != -1;
    }

    protected StringBuilder processLine(String string) {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.escapechar != '\u0000' && c == this.quotechar) {
                stringBuilder.append(this.escapechar).append(c);
                continue;
            }
            if (this.escapechar != '\u0000' && c == this.escapechar) {
                stringBuilder.append(this.escapechar).append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public void flush() throws IOException {
        this.rawWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.rawWriter.close();
    }
}

