/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.logging;

import com.semmle.util.exception.CatastrophicError;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Stack;

public class Streams {
    private static final InheritableThreadLocal<PrintStream> out = new InheritableThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return System.out;
        }
    };
    private static final InheritableThreadLocal<PrintStream> err = new InheritableThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return System.err;
        }
    };
    private static final InheritableThreadLocal<InputStream> in = new InheritableThreadLocal<InputStream>(){

        @Override
        protected InputStream initialValue() {
            return System.in;
        }
    };
    private static final ThreadLocal<Stack<SavedContext>> contexts = new ThreadLocal<Stack<SavedContext>>(){

        @Override
        protected Stack<SavedContext> initialValue() {
            return new Stack<SavedContext>();
        }
    };

    public static PrintStream out() {
        return (PrintStream)out.get();
    }

    public static PrintStream err() {
        return (PrintStream)err.get();
    }

    public static InputStream in() {
        return (InputStream)in.get();
    }

    public static void pushContext(OutputStream outputStream, OutputStream outputStream2, InputStream inputStream) {
        SavedContext savedContext = new SavedContext();
        savedContext.out = (PrintStream)out.get();
        savedContext.err = (PrintStream)err.get();
        savedContext.in = (InputStream)in.get();
        contexts.get().push(savedContext);
        out.set(Streams.asPrintStream(outputStream));
        err.set(Streams.asPrintStream(outputStream2));
        in.set(inputStream);
    }

    private static PrintStream asPrintStream(OutputStream outputStream) {
        return outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
    }

    public static void popContext() {
        Stack<SavedContext> stack = contexts.get();
        ((PrintStream)out.get()).flush();
        ((PrintStream)err.get()).flush();
        if (stack.isEmpty()) {
            throw new CatastrophicError("Popping logging context without preceding push.");
        }
        SavedContext savedContext = stack.pop();
        out.set(savedContext.out);
        err.set(savedContext.err);
        in.set(savedContext.in);
    }

    private static class SavedContext {
        public PrintStream out;
        public PrintStream err;
        public InputStream in;

        private SavedContext() {
        }
    }
}

