/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.FileLogger;
import com.github.codeql.TrapFileWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/github/codeql/GZipCompressedTrapFileWriter;", "Lcom/github/codeql/TrapFileWriter;", "logger", "Lcom/github/codeql/FileLogger;", "trapName", "", "(Lcom/github/codeql/FileLogger;Ljava/lang/String;)V", "getReader", "Ljava/io/BufferedReader;", "file", "Ljava/io/File;", "getWriter", "Ljava/io/BufferedWriter;", "codeql-kotlin-extractor"})
final class GZipCompressedTrapFileWriter
extends TrapFileWriter {
    public GZipCompressedTrapFileWriter(@NotNull FileLogger logger, @NotNull String trapName) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)trapName, (String)"trapName");
        super(logger, trapName, ".gz");
    }

    @Override
    @NotNull
    protected BufferedReader getReader(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))));
    }

    @Override
    @NotNull
    protected BufferedWriter getWriter(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file)))));
    }
}

