/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.LoggerBase;
import com.github.codeql.TrapWriter;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/github/codeql/Logger;", "", "loggerBase", "Lcom/github/codeql/LoggerBase;", "tw", "Lcom/github/codeql/TrapWriter;", "(Lcom/github/codeql/LoggerBase;Lcom/github/codeql/TrapWriter;)V", "getLoggerBase", "()Lcom/github/codeql/LoggerBase;", "getTw", "()Lcom/github/codeql/TrapWriter;", "debug", "", "msg", "", "error", "extraInfo", "exn", "", "flush", "info", "trace", "warn", "codeql-kotlin-extractor"})
public class Logger {
    @NotNull
    private final LoggerBase loggerBase;
    @NotNull
    private final TrapWriter tw;

    public Logger(@NotNull LoggerBase loggerBase, @NotNull TrapWriter tw) {
        Intrinsics.checkNotNullParameter((Object)loggerBase, (String)"loggerBase");
        Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
        this.loggerBase = loggerBase;
        this.tw = tw;
    }

    @NotNull
    public final LoggerBase getLoggerBase() {
        return this.loggerBase;
    }

    @NotNull
    public TrapWriter getTw() {
        return this.tw;
    }

    public final void flush() {
        this.getTw().flush();
        this.loggerBase.flush();
    }

    public final void trace(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.loggerBase.trace(this.getTw(), msg);
    }

    public final void trace(@NotNull String msg, @NotNull Throwable exn) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)exn, (String)"exn");
        this.trace(msg + '\n' + ExceptionsKt.stackTraceToString((Throwable)exn));
    }

    public final void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.loggerBase.debug(this.getTw(), msg);
    }

    public final void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.loggerBase.info(this.getTw(), msg);
    }

    private final void warn(String msg, String extraInfo) {
        this.loggerBase.warn(this.getTw(), msg, extraInfo);
    }

    public final void warn(@NotNull String msg, @NotNull Throwable exn) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)exn, (String)"exn");
        this.warn(msg, ExceptionsKt.stackTraceToString((Throwable)exn));
    }

    public final void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.warn(msg, (String)null);
    }

    private final void error(String msg, String extraInfo) {
        this.loggerBase.error(this.getTw(), msg, extraInfo);
    }

    public final void error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.error(msg, (String)null);
    }

    public final void error(@NotNull String msg, @NotNull Throwable exn) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)exn, (String)"exn");
        this.error(msg, ExceptionsKt.stackTraceToString((Throwable)exn));
    }
}

