/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.DbLocation_default;
import com.github.codeql.FileTrapWriter;
import com.github.codeql.Label;
import com.github.codeql.LoggerBase;
import com.github.codeql.TrapLabelManager;
import com.github.codeql.TrapWriter;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/github/codeql/SourceFileTrapWriter;", "Lcom/github/codeql/FileTrapWriter;", "loggerBase", "Lcom/github/codeql/LoggerBase;", "lm", "Lcom/github/codeql/TrapLabelManager;", "bw", "Ljava/io/BufferedWriter;", "diagnosticTrapWriter", "Lcom/github/codeql/TrapWriter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "populateFileTables", "", "(Lcom/github/codeql/LoggerBase;Lcom/github/codeql/TrapLabelManager;Ljava/io/BufferedWriter;Lcom/github/codeql/TrapWriter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Z)V", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getLocation", "Lcom/github/codeql/Label;", "Lcom/github/codeql/DbLocation_default;", "Lcom/github/codeql/DbLocation;", "startOffset", "", "endOffset", "getLocationString", "", "e", "Lorg/jetbrains/kotlin/ir/IrElement;", "codeql-kotlin-extractor"})
public final class SourceFileTrapWriter
extends FileTrapWriter {
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final IrFileEntry fileEntry;

    public SourceFileTrapWriter(@NotNull LoggerBase loggerBase, @NotNull TrapLabelManager lm, @NotNull BufferedWriter bw, @Nullable TrapWriter diagnosticTrapWriter, @NotNull IrFile irFile, boolean populateFileTables) {
        Intrinsics.checkNotNullParameter((Object)loggerBase, (String)"loggerBase");
        Intrinsics.checkNotNullParameter((Object)lm, (String)"lm");
        Intrinsics.checkNotNullParameter((Object)bw, (String)"bw");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        super(loggerBase, lm, bw, diagnosticTrapWriter, IrDeclarationsKt.getPath((IrFile)irFile), populateFileTables);
        this.irFile = irFile;
        this.fileEntry = this.irFile.getFileEntry();
    }

    @NotNull
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @Override
    @NotNull
    public Label<DbLocation_default> getLocation(int startOffset, int endOffset) {
        if (startOffset == -1 || endOffset == -1) {
            if (startOffset != endOffset) {
                this.getLoggerBase().warn(this, "Location with inconsistent offsets (start " + startOffset + ", end " + endOffset + ')', null);
            }
            return this.getWholeFileLocation();
        }
        if (startOffset == -2 || endOffset == -2) {
            if (startOffset != endOffset) {
                this.getLoggerBase().warn(this, "Location with inconsistent offsets (start " + startOffset + ", end " + endOffset + ')', null);
            }
            return this.getWholeFileLocation();
        }
        int endColumnOffset = startOffset == endOffset ? 1 : 0;
        return this.getLocation(this.getFileId(), this.fileEntry.getLineNumber(startOffset) + 1, this.fileEntry.getColumnNumber(startOffset) + 1, this.fileEntry.getLineNumber(endOffset) + 1, this.fileEntry.getColumnNumber(endOffset) + endColumnOffset);
    }

    @Override
    @NotNull
    public String getLocationString(@NotNull IrElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getStartOffset() == -1 || e.getEndOffset() == -1) {
            if (e.getStartOffset() != e.getEndOffset()) {
                this.getLoggerBase().warn(this, "Location with inconsistent offsets (start " + e.getStartOffset() + ", end " + e.getEndOffset() + ')', null);
            }
            return "<unknown location while processing " + this.getFilePath() + '>';
        }
        if (e.getStartOffset() == -2 || e.getEndOffset() == -2) {
            if (e.getStartOffset() != e.getEndOffset()) {
                this.getLoggerBase().warn(this, "Location with inconsistent offsets (start " + e.getStartOffset() + ", end " + e.getEndOffset() + ')', null);
            }
            return "<synthetic location while processing " + this.getFilePath() + '>';
        }
        int startLine = this.fileEntry.getLineNumber(e.getStartOffset()) + 1;
        int startColumn = this.fileEntry.getColumnNumber(e.getStartOffset()) + 1;
        int endLine = this.fileEntry.getLineNumber(e.getEndOffset()) + 1;
        int endColumn = this.fileEntry.getColumnNumber(e.getEndOffset());
        return "file://" + this.getFilePath() + ':' + startLine + ':' + startColumn + ':' + endLine + ':' + endColumn;
    }
}

