/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java;

import com.github.codeql.ClassNamesKt;
import com.github.codeql.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.semmle.util.concurrent.LockDirectory;
import com.semmle.util.data.Pair;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.exception.ResourceError;
import com.semmle.util.extraction.PopulationSpecFile;
import com.semmle.util.extraction.SpecFileEntry;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.WholeIO;
import com.semmle.util.process.Env;
import com.semmle.util.trap.dependencies.TrapDependencies;
import com.semmle.util.trap.dependencies.TrapSet;
import com.semmle.util.trap.pathtransformers.PathTransformer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;

public class OdasaOutput {
    private final File trapFolder;
    private final File sourceArchiveFolder;
    private final PopulationSpecFile specFile;
    private File currentSourceFile;
    private TrapSet trapsCreated;
    private TrapDependencies trapDependenciesForSource;
    private SpecFileEntry currentSpecFileEntry;
    private final boolean trackClassOrigins;
    private final Logger log;
    private static final String CLASSES_DIR = "classes";
    private static final String JARS_DIR = "jars";
    private static final String MODULES_DIR = "modules";
    private final Pattern selectClassVersionComponents = Pattern.compile("(.*)#(-?[0-9]+)\\.(-?[0-9]+)-(-?[0-9]+)-(.*)\\.trap\\.gz");
    private static final String MAJOR_VERSION = "majorVersion";
    private static final String MINOR_VERSION = "minorVersion";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String EXTRACTOR_NAME = "extractorName";

    OdasaOutput(File file, Logger logger) {
        this.trapFolder = new File(file, "trap");
        this.sourceArchiveFolder = new File(file, "src_archive");
        this.specFile = null;
        this.trackClassOrigins = false;
        this.log = logger;
    }

    public OdasaOutput(boolean bl, Logger logger) {
        String string = Env.systemEnv().getFirstNonEmpty("CODEQL_EXTRACTOR_JAVA_TRAP_DIR", Env.Var.TRAP_FOLDER.name());
        if (string != null) {
            String string2 = Env.systemEnv().getFirstNonEmpty("CODEQL_EXTRACTOR_JAVA_SOURCE_ARCHIVE_DIR", Env.Var.SOURCE_ARCHIVE.name());
            if (string2 == null) {
                throw new ResourceError((Object)((Object)Env.Var.TRAP_FOLDER) + " was set to '" + string + "', but " + (Object)((Object)Env.Var.SOURCE_ARCHIVE) + " was not set");
            }
            this.trapFolder = new File(string);
            this.sourceArchiveFolder = new File(string2);
            this.specFile = null;
        } else {
            this.trapFolder = null;
            this.sourceArchiveFolder = null;
            String string3 = Env.systemEnv().get(Env.Var.ODASA_JAVA_LAYOUT);
            if (string3 == null) {
                throw new ResourceError("Neither " + (Object)((Object)Env.Var.TRAP_FOLDER) + " nor " + (Object)((Object)Env.Var.ODASA_JAVA_LAYOUT) + " was set");
            }
            this.specFile = new PopulationSpecFile(new File(string3));
        }
        this.trackClassOrigins = bl;
        this.log = logger;
    }

    public File getTrapFolder() {
        return this.trapFolder;
    }

    public boolean getTrackClassOrigins() {
        return this.trackClassOrigins;
    }

    public void setCurrentSourceFile(File file) {
        this.currentSourceFile = file;
        this.currentSpecFileEntry = this.entryFor();
        this.trapsCreated = new TrapSet();
        this.trapsCreated.addSource(PathTransformer.std().fileAsDatabaseString(file));
        this.trapDependenciesForSource = null;
    }

    private SpecFileEntry entryFor() {
        if (this.specFile != null) {
            return this.specFile.getEntryFor(this.currentSourceFile);
        }
        return new SpecFileEntry(this.trapFolder, this.sourceArchiveFolder, Arrays.asList(PathTransformer.std().fileAsDatabaseString(this.currentSourceFile)));
    }

    public void writeTrapSet() {
        this.trapsCreated.save(this.trapSetFor(this.currentSourceFile).toPath());
    }

    private File trapSetFor(File file) {
        return FileUtil.appendAbsolutePath(this.currentSpecFileEntry.getTrapFolder(), PathTransformer.std().fileAsDatabaseString(file) + ".set");
    }

    public void addDependency(IrDeclaration irDeclaration, String string) {
        String string2 = this.trapFilePathForDecl((IrElement)irDeclaration, string);
        this.trapDependenciesForSource.addDependency(string2);
    }

    public void writeCurrentSourceFileToSourceArchive(String string) {
        if (this.currentSpecFileEntry != null && this.currentSpecFileEntry.getSourceArchivePath() != null) {
            File file = this.sourceArchiveFileFor(this.currentSourceFile);
            file.getParentFile().mkdirs();
            new WholeIO().write(file, string);
        }
    }

    public void writeFileToSourceArchive(File file) {
        File file2 = this.sourceArchiveFileFor(file);
        file2.getParentFile().mkdirs();
        String string = new WholeIO().strictread(file);
        new WholeIO().write(file2, string);
    }

    private File sourceArchiveFileFor(File file) {
        return FileUtil.appendAbsolutePath(this.currentSpecFileEntry.getSourceArchivePath(), PathTransformer.std().fileAsDatabaseString(file));
    }

    private File getTrapFileForCurrentSourceFile() {
        if (this.currentSpecFileEntry == null) {
            return null;
        }
        return this.trapFileFor(this.currentSourceFile);
    }

    private File getTrapFileForJarFile(File file) {
        if (!file.getAbsolutePath().endsWith(".jar")) {
            return null;
        }
        return FileUtil.appendAbsolutePath(this.currentSpecFileEntry.getTrapFolder(), "jars/" + PathTransformer.std().fileAsDatabaseString(file) + ".trap.gz");
    }

    private File getTrapFileForModule(String string) {
        return FileUtil.appendAbsolutePath(this.currentSpecFileEntry.getTrapFolder(), "modules/" + string + ".trap.gz");
    }

    private File trapFileFor(File file) {
        return FileUtil.appendAbsolutePath(this.currentSpecFileEntry.getTrapFolder(), PathTransformer.std().fileAsDatabaseString(file) + ".trap.gz");
    }

    private File getTrapFileForDecl(IrElement irElement, String string) {
        if (this.currentSpecFileEntry == null) {
            return null;
        }
        return this.trapFileForDecl(irElement, string);
    }

    private File trapFileForDecl(IrElement irElement, String string) {
        return FileUtil.fileRelativeTo(this.currentSpecFileEntry.getTrapFolder(), this.trapFilePathForDecl(irElement, string));
    }

    private String trapFilePathForDecl(IrElement irElement, String string) {
        String string2 = ClassNamesKt.getIrElementBinaryName(irElement);
        String string3 = "classes/" + string2.replace('.', '/') + string + ".members.trap.gz";
        return string3;
    }

    private void deleteTrapFileAndDependencies(IrElement irElement, String string) {
        File file = this.trapFileForDecl(irElement, string);
        if (file.exists()) {
            File file2;
            file.delete();
            File file3 = new File(file.getParentFile(), file.getName().replace(".trap.gz", ".dep"));
            if (file3.exists()) {
                file3.delete();
            }
            if ((file2 = new File(file.getParentFile(), file.getName().replace(".trap.gz", ".metadata"))).exists()) {
                file2.delete();
            }
        }
    }

    private TrapFileManager getMembersWriterForDecl(File file, File file2, TrapClassVersion trapClassVersion, IrElement irElement, String string) {
        if (file.exists()) {
            this.log.trace("Not rewriting trap file for " + file.toString() + " as it exists");
            return null;
        }
        File file3 = file.getParentFile();
        File file4 = new File(file3, file.getName().replace(".trap.gz", ".trap-old.gz"));
        if (file4.exists()) {
            this.log.trace("Not rewriting trap file for " + file.toString() + " as the trap-old exists");
            return null;
        }
        if (file2 != null && trapClassVersion != null && file3.exists()) {
            String string2 = file2.getName();
            for (File file5 : FileUtil.list(file3)) {
                TrapClassVersion trapClassVersion2;
                String string3 = file5.getName();
                Matcher matcher = this.selectClassVersionComponents.matcher(string3);
                if (!matcher.matches() || !matcher.group(1).equals(string2) || !(trapClassVersion2 = new TrapClassVersion(Integer.valueOf(matcher.group(2)), Integer.valueOf(matcher.group(3)), Long.valueOf(matcher.group(4)), matcher.group(5))).newerThan(trapClassVersion)) continue;
                this.log.trace("Not rewriting trap file for " + file.toString() + " as " + file5.toString() + " exists");
                return null;
            }
        }
        return this.trapWriter(file, irElement, string);
    }

    private TrapFileManager trapWriter(File file, IrElement irElement, String string) {
        if (!file.getName().endsWith(".trap.gz")) {
            throw new CatastrophicError("OdasaOutput only supports writing to compressed trap files");
        }
        String string2 = FileUtil.relativePath(file, this.currentSpecFileEntry.getTrapFolder());
        file.getParentFile().mkdirs();
        this.trapsCreated.addTrap(string2);
        return this.concurrentWriter(file, string2, this.log, irElement, string);
    }

    private TrapFileManager concurrentWriter(File file, String string, Logger logger, IrElement irElement, String string2) {
        if (file.exists()) {
            return null;
        }
        return new TrapFileManager(file, string, true, logger, irElement, string2);
    }

    public TrapLocker getTrapLockerForCurrentSourceFile() {
        return new TrapLocker((IrElement)((IrClass)null), null, true);
    }

    public TrapLocker getTrapLockerForJarFile(File file) {
        return new TrapLocker(file);
    }

    public TrapLocker getTrapLockerForModule(String string) {
        return new TrapLocker(string);
    }

    public TrapLocker getTrapLockerForDecl(IrElement irElement, String string, boolean bl) {
        return new TrapLocker(irElement, string, bl);
    }

    private TrapClassVersion readVersionInfo(File file) {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        String string = null;
        File file2 = new File(file.getAbsolutePath().replace(".trap.gz", ".metadata"));
        if (file2.exists()) {
            Map<String, String> map = FileUtil.readPropertiesCSV(file2);
            try {
                n = Integer.parseInt(map.get(MAJOR_VERSION));
                n2 = Integer.parseInt(map.get(MINOR_VERSION));
                l = Long.parseLong(map.get(LAST_MODIFIED));
                string = map.get(EXTRACTOR_NAME);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warn("Invalid class file version for " + file.getAbsolutePath(), numberFormatException);
            }
        } else {
            this.log.warn("Trap metadata file does not exist: " + file2.getAbsolutePath());
        }
        return new TrapClassVersion(n, n2, l, string);
    }

    private static class TrapClassVersion {
        private int majorVersion;
        private int minorVersion;
        private long lastModified;
        private String extractorName;
        private static Map<String, Map<String, Long>> jarFileEntryTimeStamps = new HashMap<String, Map<String, Long>>();

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getExtractorName() {
            return this.extractorName;
        }

        private TrapClassVersion(int n, int n2, long l, String string) {
            this.majorVersion = n;
            this.minorVersion = n2;
            this.lastModified = l;
            this.extractorName = string;
        }

        public boolean equals(Object object) {
            if (object instanceof TrapClassVersion) {
                TrapClassVersion trapClassVersion = (TrapClassVersion)object;
                return this.majorVersion == trapClassVersion.majorVersion && this.minorVersion == trapClassVersion.minorVersion && this.lastModified == trapClassVersion.lastModified && this.extractorName.equals(trapClassVersion.extractorName);
            }
            return false;
        }

        private boolean newerThan(TrapClassVersion trapClassVersion) {
            if (trapClassVersion.majorVersion == 0 && this.majorVersion != 0) {
                return false;
            }
            if (this.majorVersion == 0 && trapClassVersion.majorVersion != 0) {
                return true;
            }
            if (!Objects.equals(trapClassVersion.extractorName, this.extractorName)) {
                if (Objects.equals(trapClassVersion.extractorName, "kotlin")) {
                    return false;
                }
                if (Objects.equals(this.extractorName, "kotlin")) {
                    return true;
                }
            }
            return trapClassVersion.majorVersion < this.majorVersion || trapClassVersion.majorVersion == this.majorVersion && trapClassVersion.minorVersion < this.minorVersion || trapClassVersion.majorVersion == this.majorVersion && trapClassVersion.minorVersion == this.minorVersion && trapClassVersion.lastModified < this.lastModified;
        }

        private static Map<String, Long> getZipFileEntryTimeStamps(String string, Logger logger) {
            try {
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                ZipFile zipFile = new ZipFile(string);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    hashMap.put(zipEntry.getName(), zipEntry.getLastModifiedTime().toMillis());
                }
                return hashMap;
            }
            catch (IOException iOException) {
                logger.warn("Failed to get entry timestamps from " + string, iOException);
                return null;
            }
        }

        private static long getVirtualFileTimeStamp(VirtualFile virtualFile, Logger logger) {
            if (virtualFile.getFileSystem().getProtocol().equals("jar")) {
                String[] stringArray = virtualFile.getPath().split("!/");
                if (stringArray.length == 2) {
                    Map<String, Long> map;
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    if (!jarFileEntryTimeStamps.containsKey(string)) {
                        jarFileEntryTimeStamps.put(string, TrapClassVersion.getZipFileEntryTimeStamps(string, logger));
                    }
                    if ((map = jarFileEntryTimeStamps.get(string)) != null) {
                        Long l = map.get(string2);
                        if (l != null) {
                            return l;
                        }
                        logger.warn("Couldn't find timestamp for jar file " + string + " entry " + string2);
                    }
                } else {
                    logger.warn("Expected JAR-file path " + virtualFile.getPath() + " to have exactly one '!/' separator");
                }
            }
            return virtualFile.getTimeStamp();
        }

        private static VirtualFile getVirtualFileIfClass(IrElement irElement) {
            if (irElement instanceof IrClass) {
                return ClassNamesKt.getIrClassVirtualFile((IrClass)irElement);
            }
            return null;
        }

        private static TrapClassVersion fromSymbol(IrElement irElement, Logger logger) {
            VirtualFile virtualFile = TrapClassVersion.getVirtualFileIfClass(irElement);
            if (virtualFile == null && irElement instanceof IrDeclaration) {
                virtualFile = TrapClassVersion.getVirtualFileIfClass((IrElement)((IrDeclaration)irElement).getParent());
            }
            if (virtualFile == null) {
                return new TrapClassVersion(-1, 0, 0L, null);
            }
            final int[] nArray = new int[1];
            try {
                Field field = null;
                int n = -1;
                for (Field field2 : Opcodes.class.getDeclaredFields()) {
                    String string = field2.getName();
                    if (!string.startsWith("ASM")) continue;
                    try {
                        int n2 = Integer.parseInt(string.substring(3));
                        if (n2 <= n) continue;
                        n = n2;
                        field = field2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int n3 = field.getInt(null);
                ClassVisitor classVisitor = new ClassVisitor(n3){

                    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
                        nArray[0] = n;
                    }
                };
                new ClassReader(virtualFile.contentsToByteArray()).accept(classVisitor, 7);
                return new TrapClassVersion(nArray[0] & 0xFFFF, nArray[0] >> 16, TrapClassVersion.getVirtualFileTimeStamp(virtualFile, logger), "kotlin");
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.warn("Failed to read class file version information", illegalAccessException);
                return new TrapClassVersion(-1, 0, 0L, null);
            }
            catch (IOException iOException) {
                logger.warn("Failed to read class file version information", iOException);
                return new TrapClassVersion(-1, 0, 0L, null);
            }
        }

        private boolean isValid() {
            return this.majorVersion >= 0 && this.minorVersion >= 0;
        }

        public String toString() {
            return this.majorVersion + "." + this.minorVersion + "-" + this.lastModified + "-" + this.extractorName;
        }
    }

    public class TrapFileManager
    implements AutoCloseable {
        private TrapDependencies trapDependenciesForClass;
        private File trapFile;
        private IrElement sym;
        private String signature;
        private boolean hasError = false;

        private TrapFileManager(File file, String string, boolean bl, Logger logger, IrElement irElement, String string2) {
            this.trapDependenciesForClass = new TrapDependencies(string);
            this.trapFile = file;
            this.sym = irElement;
            this.signature = string2;
        }

        public File getFile() {
            return this.trapFile;
        }

        public void addDependency(IrElement irElement, String string) {
            this.trapDependenciesForClass.addDependency(OdasaOutput.this.trapFilePathForDecl(irElement, string));
        }

        public void addDependency(IrClass irClass) {
            this.addDependency((IrElement)irClass, "");
        }

        @Override
        public void close() {
            if (this.hasError) {
                return;
            }
            this.writeTrapDependencies(this.trapDependenciesForClass);
        }

        private void writeTrapDependencies(TrapDependencies trapDependencies) {
            String string = trapDependencies.trapFile().replace(".trap.gz", ".dep");
            trapDependencies.save(OdasaOutput.this.currentSpecFileEntry.getTrapFolder().toPath().resolve(string));
        }

        public void setHasError() {
            this.hasError = true;
        }
    }

    public class TrapLocker
    implements AutoCloseable {
        private final IrElement sym;
        private final File trapFile;
        private File trapFileBase = null;
        private TrapClassVersion trapFileVersion = null;
        private final String signature;

        private TrapLocker(IrElement irElement, String string, boolean bl) {
            this.sym = irElement;
            this.signature = string;
            if (this.sym == null) {
                OdasaOutput.this.log.error("Null symbol passed for Kotlin TRAP locker");
                this.trapFile = null;
            } else {
                File file = OdasaOutput.this.getTrapFileForDecl(this.sym, string);
                this.trapFileVersion = bl ? new TrapClassVersion(0, 0, 0L, "kotlin") : TrapClassVersion.fromSymbol(this.sym, OdasaOutput.this.log);
                String string2 = file.getName().replace(".trap.gz", "");
                this.trapFileBase = new File(new File(file.getParentFile(), string2), string2);
                this.trapFile = new File(this.trapFileBase.getPath() + '#' + this.trapFileVersion.toString() + ".trap.gz");
            }
        }

        private TrapLocker(File file) {
            this.sym = null;
            this.signature = null;
            this.trapFile = OdasaOutput.this.getTrapFileForJarFile(file);
        }

        private TrapLocker(String string) {
            this.sym = null;
            this.signature = null;
            this.trapFile = OdasaOutput.this.getTrapFileForModule(string);
        }

        public TrapFileManager getTrapFileManager() {
            if (this.trapFile != null) {
                return OdasaOutput.this.getMembersWriterForDecl(this.trapFile, this.trapFileBase, this.trapFileVersion, this.sym, this.signature);
            }
            return null;
        }

        @Override
        public void close() {
            if (this.trapFile != null && this.sym != null) {
                Object object;
                Object object2;
                File file = this.trapFileBase.getParentFile();
                String string = this.trapFileBase.getName();
                LinkedList<Pair<File, TrapClassVersion>> linkedList = new LinkedList<Pair<File, TrapClassVersion>>();
                for (File file2 : FileUtil.list(file)) {
                    object2 = file2.getName();
                    object = OdasaOutput.this.selectClassVersionComponents.matcher((CharSequence)object2);
                    if (!((Matcher)object).matches()) continue;
                    if (((Matcher)object).group(1).equals(string)) {
                        TrapClassVersion trapClassVersion = new TrapClassVersion(Integer.valueOf(((Matcher)object).group(2)), Integer.valueOf(((Matcher)object).group(3)), Long.valueOf(((Matcher)object).group(4)), ((Matcher)object).group(5));
                        linkedList.add(new Pair<File, TrapClassVersion>(file2, trapClassVersion));
                        continue;
                    }
                    OdasaOutput.this.log.error("Unexpected sibling " + ((Matcher)object).group(1) + " when extracting " + string);
                }
                if (linkedList.isEmpty()) {
                    OdasaOutput.this.log.error("Wrote TRAP file, but no TRAP files exist for " + this.trapFile.getAbsolutePath());
                } else {
                    Comparator<Pair<File, TrapClassVersion>> comparator = new Comparator<Pair<File, TrapClassVersion>>(){

                        @Override
                        public int compare(Pair<File, TrapClassVersion> pair, Pair<File, TrapClassVersion> pair2) {
                            TrapClassVersion trapClassVersion;
                            TrapClassVersion trapClassVersion2 = pair.snd();
                            if (trapClassVersion2.equals(trapClassVersion = pair2.snd())) {
                                return 0;
                            }
                            if (trapClassVersion2.newerThan(trapClassVersion)) {
                                return 1;
                            }
                            return -1;
                        }
                    };
                    TrapClassVersion trapClassVersion = Collections.max(linkedList, comparator).snd();
                    for (Pair pair : linkedList) {
                        if (trapClassVersion.equals(pair.snd())) continue;
                        object2 = (File)pair.fst();
                        object = new File(((File)object2).getParentFile(), ((File)object2).getName().replace(".trap.gz", ".trap-old.gz"));
                        ((File)object2).renameTo((File)object);
                    }
                }
            }
        }

        private LockDirectory getExtractorLockDir() {
            return LockDirectory.instance(OdasaOutput.this.currentSpecFileEntry.getTrapFolder(), OdasaOutput.this.log);
        }

        private void lockTrapFile(File file) {
            this.getExtractorLockDir().blockingLock(LockDirectory.LockingMode.Exclusive, file, "Java extractor lock");
        }

        private void unlockTrapFile(File file) {
            boolean bl = this.getExtractorLockDir().maybeUnlock(LockDirectory.LockingMode.Exclusive, file);
            if (!bl) {
                OdasaOutput.this.log.warn("Trap file was not locked: " + file);
            }
        }
    }
}

