/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.array;

import com.semmle.util.basic.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    public static int findFirst(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            if (bl != blArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            if (by != byArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            if (d != dArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            if (f != fArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int findFirst(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int findFirst(T[] TArray, T t) {
        for (int i = 0; i < TArray.length; ++i) {
            if (!ObjectUtil.equals(t, TArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int findFirstSame(T[] TArray, T t) {
        for (int i = 0; i < TArray.length; ++i) {
            if (t != TArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int n, int ... nArray) {
        return ArrayUtil.findFirst(nArray, n) != -1;
    }

    @SafeVarargs
    public static <T> boolean contains(T t, T ... TArray) {
        return ArrayUtil.findFirst(TArray, t) != -1;
    }

    public static <T> T[] append(T[] TArray, T t) {
        TArray = Arrays.copyOf(TArray, TArray.length + 1);
        TArray[TArray.length - 1] = t;
        return TArray;
    }

    public static byte[] concatenate(byte[] ... byArray) {
        if (byArray == null) {
            return null;
        }
        int n = 0;
        for (byte[] byArray2 : byArray) {
            n += byArray2 == null ? 0 : byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        for (byte[] byArray4 : byArray) {
            if (byArray4 == null) continue;
            System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
            n2 += byArray4.length;
        }
        return byArray3;
    }

    public static <T> T[] toArray(T ... TArray) {
        return TArray;
    }

    public static int[] swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
        return nArray;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... TArray) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collections.addAll(linkedHashSet, TArray);
        return linkedHashSet;
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

