/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.Exceptions;
import com.semmle.util.files.FileUtil;
import com.semmle.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RawStreamMuncher
extends Thread {
    private final InputStream in;
    private final OutputStream out;

    public RawStreamMuncher(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
    }

    @Override
    public void run() {
        try {
            StreamUtil.copy(this.in, this.out);
        }
        catch (IOException iOException) {
            Exceptions.ignore(iOException, "When the process exits, a harmless IOException will occur here");
        }
        finally {
            FileUtil.close(this.in);
            FileUtil.close(this.out);
        }
    }
}

