/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import net.sourceforge.pmd.cpd.AbstractLanguage;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import opencsv.CSVReader;

public class GoLanguage
extends AbstractLanguage {
    public GoLanguage() {
        super(new String[]{".go"});
    }

    public Tokenizer getTokenizer(final boolean bl) {
        return new Tokenizer(){

            public void tokenize(SourceCode sourceCode, List<TokenEntry> list) {
                String string = sourceCode.getFileName();
                String string2 = "linux";
                String string3 = "";
                String string4 = System.getProperty("os.name", "unknown");
                if (string4.contains("Windows")) {
                    string2 = "win";
                    string3 = ".exe";
                } else if (string4.contains("Mac OS X")) {
                    string2 = "osx";
                }
                String string5 = null;
                String string6 = System.getenv("SEMMLE_DIST");
                if (string6 != null && !string6.isEmpty()) {
                    string5 = string6 + "/language-packs/go/tools/platform/" + string2;
                }
                Object object = string5 == null ? "go-tokenizer" : string5 + "/bin/go-tokenizer";
                object = (String)object + string3;
                ProcessBuilder processBuilder = new ProcessBuilder(Paths.get((String)object, new String[0]).toString(), string);
                processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
                try {
                    Process process = processBuilder.start();
                    try (CSVReader cSVReader = new CSVReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));){
                        String[] stringArray;
                        while ((stringArray = cSVReader.readNext()) != null) {
                            String string7 = stringArray[0];
                            String string8 = stringArray[1];
                            int n = Integer.parseInt(stringArray[2]);
                            int n2 = Integer.parseInt(stringArray[3]);
                            int n3 = Integer.parseInt(stringArray[4]);
                            int n4 = Integer.parseInt(stringArray[5]);
                            list.add(new TokenEntry(bl ? string7 : string8, string, n, n2, n3, n4));
                        }
                    }
                    int n = process.waitFor();
                    if (n != 0) {
                        throw new RuntimeException("Tokenizing " + string + " returned " + n + ".");
                    }
                }
                catch (IOException | InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }
}

