/*
 * Decompiled with CFR 0.152.
 */
package opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private StringBuilder buf = new StringBuilder(128);
    public static final char DEFAULT_SEPARATOR = ',';
    private static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final boolean DEFAULT_STRICT_QUOTES = false;

    CSVParser(char c, char c2, char c3, boolean bl) {
        this.separator = c;
        this.quotechar = c2;
        this.escape = c3;
        this.strictQuotes = bl;
    }

    public boolean isPending() {
        return this.buf.length() != 0;
    }

    public String[] parseLineMulti(String string) throws IOException {
        return this.parseLine(string, true);
    }

    public String[] parseLine(String string) throws IOException {
        return this.parseLine(string, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] parseLine(String string, boolean bl) throws IOException {
        if (!bl && this.isPending()) {
            this.clear();
        }
        if (string == null) {
            if (!this.isPending()) return null;
            String string2 = this.buf.toString();
            this.clear();
            return new String[]{string2};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = this.isPending();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.escape && this.isNextCharacterEscapable(string, bl2, i)) {
                this.buf.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(string, bl2, i)) {
                    this.buf.append(string.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl3 = bl2 = !bl2;
                if (this.strictQuotes || i <= 2 || string.charAt(i - 1) == this.separator || string.length() <= i + 1 || string.charAt(i + 1) == this.separator) continue;
                this.buf.append(c);
                continue;
            }
            if (c == this.separator && !bl2) {
                arrayList.add(this.buf.toString());
                this.clear();
                continue;
            }
            if (this.strictQuotes && !bl2) continue;
            this.buf.append(c);
        }
        if (bl2) {
            if (!bl) throw new IOException("Un-terminated quoted field at end of CSV line");
            this.buf.append('\n');
            return arrayList.toArray(new String[arrayList.size()]);
        } else {
            arrayList.add(this.buf.toString());
            this.clear();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && string.charAt(n + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && (string.charAt(n + 1) == this.quotechar || string.charAt(n + 1) == this.escape);
    }

    private void clear() {
        this.buf.setLength(0);
    }
}

