/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.process;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class LeakPrevention {
    static final String REPLACEMENT_STRING = "*****";
    public static final LeakPrevention ALL = new LeakPrevention(){

        @Override
        public List<String> cleanUpArguments(List<String> list) {
            return list.isEmpty() ? list : Collections.singletonList(list.get(0));
        }
    };
    public static final LeakPrevention NONE = new LeakPrevention(){

        @Override
        public List<String> cleanUpArguments(List<String> list) {
            return list;
        }
    };

    public abstract List<String> cleanUpArguments(List<String> var1);

    public static LeakPrevention suppressedArguments(int ... nArray) {
        if (nArray.length == 0) {
            return NONE;
        }
        final BitSet bitSet = new BitSet();
        for (int n : nArray) {
            bitSet.set(n);
        }
        return new LeakPrevention(){

            @Override
            public List<String> cleanUpArguments(List<String> list) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                int n = 0;
                for (String string : list) {
                    if (bitSet.get(n)) {
                        arrayList.add(LeakPrevention.REPLACEMENT_STRING);
                    } else {
                        arrayList.add(string);
                    }
                    ++n;
                }
                return arrayList;
            }
        };
    }

    public static LeakPrevention suppressSubstring(final String string) {
        return new LeakPrevention(){

            @Override
            public List<String> cleanUpArguments(List<String> list) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (String string2 : list) {
                    arrayList.add(string2.replace(string, LeakPrevention.REPLACEMENT_STRING));
                }
                return arrayList;
            }
        };
    }
}

