/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.Compression;
import com.github.codeql.ExtractionProblems;
import com.github.codeql.FileExtractionProblems;
import com.github.codeql.KotlinExtractorDbSchemeKt;
import com.github.codeql.KotlinExtractorExtensionKt;
import com.github.codeql.KotlinExtractorGlobalState;
import com.github.codeql.Label;
import com.github.codeql.LogCounter;
import com.github.codeql.Logger;
import com.github.codeql.LoggerBase;
import com.github.codeql.PrimitiveTypeMapping;
import com.github.codeql.SourceFileTrapWriter;
import com.github.codeql.StringLabel;
import com.github.codeql.TrapLabelManager;
import com.github.codeql.TrapWriter;
import com.semmle.util.files.FileUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/codeql/KotlinExtractorExtension;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "invocationTrapFile", "", "checkTrapIdentical", "", "compilationStartTime", "", "exitAfterExtraction", "(Ljava/lang/String;ZLjava/lang/Long;Z)V", "Ljava/lang/Long;", "generate", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "logPeakMemoryUsage", "logger", "Lcom/github/codeql/Logger;", "time", "runExtractor", "codeql-kotlin-extractor"})
@SourceDebugExtension(value={"SMAP\nKotlinExtractorExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtractorExtension.kt\ncom/github/codeql/KotlinExtractorExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n1#2:458\n1557#3:459\n1588#3,4:460\n*S KotlinDebug\n*F\n+ 1 KotlinExtractorExtension.kt\ncom/github/codeql/KotlinExtractorExtension\n*L\n163#1:459\n163#1:460,4\n*E\n"})
public final class KotlinExtractorExtension
implements IrGenerationExtension {
    @NotNull
    private final String invocationTrapFile;
    private final boolean checkTrapIdentical;
    @Nullable
    private final Long compilationStartTime;
    private final boolean exitAfterExtraction;

    public KotlinExtractorExtension(@NotNull String invocationTrapFile, boolean checkTrapIdentical, @Nullable Long compilationStartTime, boolean exitAfterExtraction) {
        Intrinsics.checkNotNullParameter((Object)invocationTrapFile, (String)"invocationTrapFile");
        this.invocationTrapFile = invocationTrapFile;
        this.checkTrapIdentical = checkTrapIdentical;
        this.compilationStartTime = compilationStartTime;
        this.exitAfterExtraction = exitAfterExtraction;
    }

    public void generate(@NotNull IrModuleFragment moduleFragment, @NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        try {
            this.runExtractor(moduleFragment, pluginContext);
        }
        catch (Throwable e) {
            String msg = "[ERROR] CodeQL Kotlin extractor: Top-level exception.";
            String extractorLogDir = System.getenv("CODEQL_EXTRACTOR_JAVA_LOG_DIR");
            if (extractorLogDir != null && !Intrinsics.areEqual((Object)extractorLogDir, (Object)"")) {
                File logFile = File.createTempFile("kotlin-extractor-top.", ".log", new File(extractorLogDir));
                Intrinsics.checkNotNullExpressionValue((Object)logFile, (String)"logFile");
                FilesKt.writeText$default((File)logFile, (String)msg, null, (int)2, null);
                FilesKt.appendText$default((File)logFile, (String)ExceptionsKt.stackTraceToString((Throwable)e), null, (int)2, null);
            }
            System.err.println(msg);
            e.printStackTrace(System.err);
        }
        if (this.exitAfterExtraction) {
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void runExtractor(IrModuleFragment moduleFragment, IrPluginContext pluginContext) {
        Object object;
        String string;
        long startTimeMs = System.currentTimeMillis();
        String it = string = System.getenv("CODEQL_EXTRACTOR_JAVA_TRAP_DIR");
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            string2 = "kotlin-extractor/trap";
        }
        String string3 = string2;
        File trapDir = new File(string3);
        String compression_env_var = "CODEQL_EXTRACTOR_JAVA_OPTION_TRAP_COMPRESSION";
        String compression_option = System.getenv(compression_env_var);
        Compression defaultCompression = Compression.GZIP;
        if (compression_option == null) {
            object = new Pair((Object)defaultCompression, null);
        } else {
            Compression requested_compression;
            try {
                String string4 = compression_option.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                requested_compression = Compression.valueOf(string4);
                requested_compression = requested_compression == Compression.BROTLI ? new Pair((Object)Compression.GZIP, (Object)"Kotlin extractor doesn't support Brotli compression. Using GZip instead.") : new Pair((Object)requested_compression, null);
            }
            catch (IllegalArgumentException e) {
                requested_compression = new Pair((Object)defaultCompression, (Object)("Unsupported compression type ($" + compression_env_var + ") \"" + compression_option + "\". Supported values are " + ArraysKt.joinToString$default((Object[])Compression.values(), null, null, null, (int)0, null, null, (int)63, null)));
            }
            object = requested_compression;
        }
        Pair pair = object;
        Compression compression = (Compression)((Object)pair.component1());
        String compressionWarning = (String)pair.component2();
        Closeable closeable = new FileOutputStream(new File(this.invocationTrapFile), true);
        Object object2 = Charsets.UTF_8;
        Closeable closeable2 = closeable;
        closeable2 = new OutputStreamWriter((OutputStream)closeable2, (Charset)object2);
        int n = 8192;
        closeable = closeable2 instanceof BufferedWriter ? (BufferedWriter)closeable2 : new BufferedWriter((Writer)closeable2, n);
        object2 = null;
        try {
            void $this$mapIndexedTo$iv$iv;
            String string5;
            Object object3;
            URL uRL;
            BufferedWriter invocationTrapFileBW = (BufferedWriter)closeable;
            boolean bl2 = false;
            ExtractionProblems invocationExtractionProblems = new ExtractionProblems();
            TrapLabelManager lm = new TrapLabelManager();
            LogCounter logCounter = new LogCounter();
            LoggerBase loggerBase = new LoggerBase(logCounter);
            TrapWriter tw = new TrapWriter(loggerBase, lm, invocationTrapFileBW, null);
            Label compilation = new StringLabel("compilation");
            KotlinExtractorDbSchemeKt.writeCompilation_started(tw, compilation);
            String string6 = KotlinCompilerVersion.getVersion();
            if (string6 == null) {
                string6 = "<unknown>";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"KotlinCompilerVersion.getVersion() ?: \"<unknown>\"");
            KotlinExtractorDbSchemeKt.writeCompilation_info(tw, compilation, "Kotlin Compiler Version", string6);
            URL uRL2 = uRL = this.getClass().getResource("extractor.name");
            if (uRL2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"getResource(\"extractor.name\")");
                URL uRL3 = uRL;
                Charset charset = Charsets.UTF_8;
                object3 = TextStreamsKt.readBytes((URL)uRL3);
                string5 = new String((byte[])object3, charset);
            } else {
                string5 = "<unknown>";
            }
            String extractor_name = string5;
            KotlinExtractorDbSchemeKt.writeCompilation_info(tw, compilation, "Kotlin Extractor Name", extractor_name);
            if (this.compilationStartTime != null) {
                KotlinExtractorDbSchemeKt.writeCompilation_compiler_times(tw, compilation, -1.0, (double)(System.currentTimeMillis() - this.compilationStartTime) / 1000.0);
            }
            tw.flush();
            Logger logger = new Logger(loggerBase, tw);
            logger.info("Extraction started");
            logger.flush();
            logger.info("Extraction for invocation TRAP file " + this.invocationTrapFile);
            logger.flush();
            logger.info("Kotlin version " + KotlinCompilerVersion.getVersion());
            logger.flush();
            this.logPeakMemoryUsage(logger, "before extractor");
            if (Intrinsics.areEqual((Object)System.getenv("CODEQL_EXTRACTOR_JAVA_KOTLIN_DUMP"), (Object)"true")) {
                logger.info("moduleFragment:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)moduleFragment), (boolean)false, (boolean)false, (int)3, null));
            }
            if (compressionWarning != null) {
                logger.warn(compressionWarning);
            }
            PrimitiveTypeMapping primitiveTypeMapping = new PrimitiveTypeMapping(logger, pluginContext);
            FileUtil.logger = logger;
            Object it2 = object3 = (Object)System.getenv("CODEQL_EXTRACTOR_JAVA_SOURCE_ARCHIVE_DIR");
            boolean $i$a$-takeUnless-KotlinExtractorExtension$runExtractor$1$srcDir$22 = false;
            CharSequence charSequence2 = (CharSequence)it2;
            Object object4 = (byte[])(!(charSequence2 == null || charSequence2.length() == 0) ? object3 : null);
            if (object4 == null) {
                object4 = "kotlin-extractor/src";
            }
            Object object5 = object4;
            File srcDir = new File((String)object5);
            srcDir.mkdirs();
            KotlinExtractorGlobalState globalExtensionState = new KotlinExtractorGlobalState();
            Iterable $this$mapIndexed$iv = moduleFragment.getFiles();
            boolean $i$f$mapIndexed = false;
            Iterable $i$a$-takeUnless-KotlinExtractorExtension$runExtractor$1$srcDir$22 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void file;
                int n2 = index$iv$iv;
                index$iv$iv = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrFile irFile = (IrFile)item$iv$iv;
                int n3 = n2;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                FileExtractionProblems fileExtractionProblems = new FileExtractionProblems(invocationExtractionProblems);
                SourceFileTrapWriter fileTrapWriter = tw.makeSourceFileTrapWriter((IrFile)file, true);
                loggerBase.setFileNumber((int)index);
                KotlinExtractorDbSchemeKt.writeCompilation_compiling_files(fileTrapWriter, compilation, (int)index, fileTrapWriter.getFileId());
                KotlinExtractorExtensionKt.access$doFile(compression, fileExtractionProblems, this.invocationTrapFile, fileTrapWriter, this.checkTrapIdentical, loggerBase, trapDir, srcDir, (IrFile)file, primitiveTypeMapping, pluginContext, globalExtensionState);
                KotlinExtractorDbSchemeKt.writeCompilation_compiling_files_completed(fileTrapWriter, compilation, (int)index, fileExtractionProblems.extractionResult());
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            loggerBase.printLimitedDiagnosticCounts(tw);
            this.logPeakMemoryUsage(logger, "after extractor");
            logger.info("Extraction completed");
            logger.flush();
            long compilationTimeMs = System.currentTimeMillis() - startTimeMs;
            KotlinExtractorDbSchemeKt.writeCompilation_finished(tw, compilation, -1.0, (double)compilationTimeMs / (double)1000, invocationExtractionProblems.extractionResult());
            tw.flush();
            loggerBase.close();
            closeable2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
    }

    private final void logPeakMemoryUsage(Logger logger, String time) {
        logger.info("Peak memory: Usage " + time);
        List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
        long heap = 0L;
        long nonheap = 0L;
        for (MemoryPoolMXBean bean : beans) {
            String string;
            long peak = bean.getPeakUsage().getUsed();
            MemoryType memoryType = bean.getType();
            switch (memoryType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[memoryType.ordinal()]) {
                case 1: {
                    heap += peak;
                    string = "heap";
                    break;
                }
                case 2: {
                    nonheap += peak;
                    string = "non-heap";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
            String kind = string;
            logger.info("Peak memory: * Peak for " + kind + " bean " + bean.getName() + " is " + peak);
        }
        logger.info("Peak memory: * Total heap peak: " + heap);
        logger.info("Peak memory: * Total non-heap peak: " + nonheap);
    }

    @Nullable
    public IrDeclaration resolveSymbol(@NotNull IrSymbol symbol, @NotNull TranslationPluginContext context) {
        return IrGenerationExtension.DefaultImpls.resolveSymbol((IrGenerationExtension)this, (IrSymbol)symbol, (TranslationPluginContext)context);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MemoryType.values().length];
            try {
                nArray[MemoryType.HEAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryType.NON_HEAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

