/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java;

import com.github.codeql.DbFile;
import com.github.codeql.DbLocation_default;
import com.github.codeql.KotlinExtractorDbSchemeKt;
import com.github.codeql.Label;
import com.github.codeql.TrapWriter;
import com.semmle.util.exception.CatastrophicError;
import com.semmle.util.files.FileUtil;
import com.semmle.util.trap.pathtransformers.PathTransformer;
import java.io.File;
import kotlin.Unit;

public class PopulateFile {
    private TrapWriter tw;
    private PathTransformer transformer;
    private static final String[] keyReplacementMap = new String[127];

    public PopulateFile(TrapWriter trapWriter) {
        this.tw = trapWriter;
        this.transformer = PathTransformer.std();
    }

    public static String escapeKey(String string) {
        StringBuilder stringBuilder = null;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '#': 
                case '&': 
                case '@': 
                case '{': 
                case '}': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(string, n, i);
                    stringBuilder.append(keyReplacementMap[c]);
                    n = i + 1;
                }
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append(string, n, string.length());
            return stringBuilder.toString();
        }
        return string;
    }

    public Label populateFile(File file) {
        return this.getFileLabel(file, true);
    }

    public Label<DbFile> getFileLabel(File file, boolean bl) {
        String string = this.transformer.fileAsDatabaseString(file);
        Label<DbFile> label3 = this.tw.getLabelFor("@\"" + PopulateFile.escapeKey(string) + ";sourcefile\"", label2 -> {
            if (bl) {
                KotlinExtractorDbSchemeKt.writeFiles(this.tw, label2, string);
                this.populateParents(new File(string), (Label)label2);
            }
            return Unit.INSTANCE;
        });
        return label3;
    }

    private Label addFolderTuple(String string) {
        Label label2 = this.tw.getLabelFor("@\"" + PopulateFile.escapeKey(string) + ";folder\"");
        KotlinExtractorDbSchemeKt.writeFolders(this.tw, label2, string);
        return label2;
    }

    private void populateParents(File file, Label label2) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        Label label3 = this.addFolderTuple(FileUtil.normalisePath(file2.getPath()));
        this.populateParents(file2, label3);
        KotlinExtractorDbSchemeKt.writeContainerparent(this.tw, label3, label2);
    }

    public Label relativeFileId(File file, String string) {
        return this.getFileInJarLabel(file, string, true);
    }

    public Label<DbFile> getFileInJarLabel(File file, String string, boolean bl) {
        if (string.contains("\\")) {
            throw new CatastrophicError("Invalid jar path: '" + string + "' should not contain '\\'.");
        }
        String string2 = this.transformer.fileAsDatabaseString(file);
        if (!bl) {
            return this.tw.getLabelFor("@\"" + string2 + "/" + string + ";jarFile\"");
        }
        Label label2 = this.populateFile(file);
        Label<DbLocation_default> label3 = this.tw.getLocation(label2, 0, 0, 0, 0);
        KotlinExtractorDbSchemeKt.writeHasLocation(this.tw, label2, label3);
        StringBuilder stringBuilder = new StringBuilder(string2);
        String[] stringArray = string.split("/");
        Label label4 = label2;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2;
            String string3 = stringArray[i];
            stringBuilder.append("/");
            stringBuilder.append(string3);
            Label label5 = this.tw.getLabelFor("@\"" + stringBuilder + ";jarFile\"");
            boolean bl3 = bl2 = i == stringArray.length - 1;
            if (bl2) {
                KotlinExtractorDbSchemeKt.writeFiles(this.tw, label5, stringBuilder.toString());
            } else {
                KotlinExtractorDbSchemeKt.writeFolders(this.tw, label5, stringBuilder.toString());
            }
            KotlinExtractorDbSchemeKt.writeContainerparent(this.tw, label4, label5);
            label4 = label5;
        }
        return label4;
    }

    static {
        PopulateFile.keyReplacementMap[38] = "&amp;";
        PopulateFile.keyReplacementMap[123] = "&lbrace;";
        PopulateFile.keyReplacementMap[125] = "&rbrace;";
        PopulateFile.keyReplacementMap[34] = "&quot;";
        PopulateFile.keyReplacementMap[64] = "&commat;";
        PopulateFile.keyReplacementMap[35] = "&num;";
    }
}

