/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.exception;

import com.semmle.util.exception.CatastrophicError;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Exceptions {
    public static String printStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String print(Throwable throwable) {
        return Exceptions.printDetailed(throwable, true);
    }

    public static String printShort(Throwable throwable) {
        return Exceptions.printDetailed(throwable, false);
    }

    public static void ignore(Throwable throwable, String string) {
    }

    private static String printDetailed(Throwable throwable, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Throwable throwable2 = throwable;
        while (throwable2 != null) {
            Exceptions.printOneException(throwable2, bl, stringBuilder);
            Throwable throwable3 = throwable2.getCause();
            if ((throwable2 = throwable3 == throwable2 ? null : throwable3) == null) continue;
            if (bl) {
                stringBuilder.append("\n\n ... caused by:\n\n");
                continue;
            }
            stringBuilder.append(", caused by: ");
        }
        return stringBuilder.toString();
    }

    private static void printOneException(Throwable throwable, boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append(bl ? throwable.toString() : throwable.toString().replace('\n', ' ').replace('\r', ' '));
        boolean bl2 = true;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (bl2) {
                stringBuilder.append(bl ? "\n" : " - [");
            } else {
                stringBuilder.append(bl ? "\n" : ", ");
            }
            bl2 = false;
            stringBuilder.append(stackTraceElement.toString());
        }
        if (!bl) {
            stringBuilder.append("]");
        }
    }

    public static void assertion(boolean bl, String string) {
        if (!bl) {
            throw new CatastrophicError(string);
        }
    }

    public static RuntimeException asUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static <T> T rethrowUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }
}

