/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.extraction;

import com.semmle.util.exception.ResourceError;
import com.semmle.util.extraction.SpecFileEntry;
import com.semmle.util.files.FileUtil;
import com.semmle.util.process.Env;
import com.semmle.util.trap.pathtransformers.PathTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PopulationSpecFile {
    private final List<SpecFileEntry> specs = new ArrayList<SpecFileEntry>();

    public PopulationSpecFile(File file) {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            File file2 = null;
            File file3 = null;
            File file4 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                File file5;
                if ((string = string.trim()).length() == 0 || string.startsWith("@")) continue;
                if (string.startsWith("#")) {
                    if (file2 != null) {
                        this.specs.add(new SpecFileEntry(file3, file4, arrayList));
                    }
                    file2 = null;
                    file4 = null;
                    arrayList = new ArrayList();
                    continue;
                }
                if (string.startsWith("TRAP_FOLDER=")) {
                    file3 = new File(string.substring("TRAP_FOLDER=".length()));
                    continue;
                }
                if (string.startsWith("ODASA_DB=")) {
                    file2 = new File(string.substring("ODASA_DB=".length()));
                    continue;
                }
                if (string.startsWith("SOURCE_ARCHIVE=")) {
                    file4 = new File(string.substring("SOURCE_ARCHIVE=".length()));
                    continue;
                }
                if (string.startsWith("BUILD_ERROR_DIR=")) continue;
                if (string.startsWith("-")) {
                    file5 = new File(string.substring(1).trim());
                    arrayList.add("-" + PopulationSpecFile.normalisePathAndCase(file5) + "/");
                    continue;
                }
                file5 = new File(string);
                arrayList.add(PopulationSpecFile.normalisePathAndCase(file5) + "/");
            }
            if (file2 != null) {
                this.specs.add(new SpecFileEntry(file3, file4, arrayList));
            }
        }
        catch (IOException iOException) {
            try {
                throw new ResourceError("I/O error while reading specification file at " + file, iOException);
            }
            catch (Throwable throwable) {
                FileUtil.close(bufferedReader);
                FileUtil.close(fileReader);
                throw throwable;
            }
        }
        FileUtil.close(bufferedReader);
        FileUtil.close(fileReader);
    }

    public SpecFileEntry getEntryFor(File file) {
        String string = PopulationSpecFile.normalisePathAndCase(file);
        for (SpecFileEntry specFileEntry : this.specs) {
            if (!specFileEntry.matches(string)) continue;
            return specFileEntry;
        }
        return null;
    }

    private static String normalisePathAndCase(File file) {
        String string = PathTransformer.std().fileAsDatabaseString(file);
        if (!Env.getOS().isFileSystemCaseSensitive()) {
            string = string.toLowerCase();
        }
        return string;
    }
}

