/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.io;

import com.semmle.util.exception.CatastrophicError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class StreamUtil {
    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        StreamUtil.nullCheck(inputStream, outputStream);
        long l = 0L;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        int n;
        StreamUtil.nullCheck(reader, writer);
        long l = 0L;
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) > 0) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long limitedCopy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n;
        StreamUtil.nullCheck(inputStream, outputStream);
        long l2 = 0L;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l))) > 0) {
            outputStream.write(byArray, 0, n);
            l -= (long)n;
            l2 += (long)n;
        }
        return l2;
    }

    private static void nullCheck(Object object, Object object2) {
        CatastrophicError.throwIfAnyNull(object, object2);
    }

    public static boolean skip(InputStream inputStream, long l) throws IOException {
        long l2;
        if (l <= 0L) {
            return true;
        }
        for (long i = l - 1L; i > 0L; i -= l2) {
            l2 = inputStream.skip(i);
            if (l2 != 0L) continue;
            if (inputStream.read() == -1) {
                return false;
            }
            ++l2;
        }
        return inputStream.read() != -1;
    }

    public static byte[] readN(InputStream inputStream, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.limitedCopy(inputStream, byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        int n4 = 0;
        while ((n3 = inputStream.read(byArray, n, n2)) > 0) {
            n2 -= n3;
            n4 += n3;
        }
        return n4;
    }

    public static BufferedReader newUTF8BufferedReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static BufferedWriter newUTF8BufferedWriter(OutputStream outputStream) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }
}

