/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.trap.dependencies;

import com.semmle.util.exception.ResourceError;
import com.semmle.util.io.StreamUtil;
import com.semmle.util.io.WholeIO;
import com.semmle.util.trap.CompressedFileInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TextFile {
    static final String TRAPS = "TRAPS";
    private static final Pattern HEADER = Pattern.compile("([^\r\n]+?) (\\d\\.\\d)");
    protected String version;
    protected final Set<String> traps = new LinkedHashSet<String>();

    protected abstract Set<String> getSet(Path var1, String var2);

    protected abstract void parseError(Path var1);

    public TextFile(String string) {
        this.version = string;
    }

    protected void load(String string, Path path) {
        try (InputStream inputStream = CompressedFileInputStream.fromFile(path);
             BufferedReader bufferedReader = StreamUtil.newUTF8BufferedReader(inputStream);){
            boolean bl = true;
            Set<String> set = null;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!(string2.isEmpty() || bl && string2.startsWith("//"))) {
                    Set<String> set2;
                    if (bl) {
                        set2 = HEADER.matcher(string2);
                        if (!((Matcher)((Object)set2)).matches() || !((Matcher)((Object)set2)).group(1).equals(string)) {
                            this.parseError(path);
                        }
                        bl = false;
                        this.version = ((Matcher)((Object)set2)).group(2);
                    } else {
                        set2 = this.getSet(path, string2);
                        if (set2 != null) {
                            set = set2;
                        } else if (set == null) {
                            this.parseError(path);
                        } else {
                            set.add(string2);
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new ResourceError("Couldn't read " + path, iOException);
        }
    }

    public String version() {
        return this.version;
    }

    public void save(Path path) {
        new WholeIO().strictwrite(path, this.toString());
    }

    protected void appendHeaderString(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append(' ').append(string2).append('\n');
    }

    protected void appendSet(StringBuilder stringBuilder, String string, Set<String> set) {
        stringBuilder.append('\n').append(string).append('\n');
        for (String string2 : set) {
            stringBuilder.append(string2).append('\n');
        }
    }

    protected void appendSingleton(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('\n').append(string).append('\n');
        stringBuilder.append(string2).append('\n');
    }
}

