/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public class MultiMemberGZIPInputStream
extends GZIPInputStream {
    private MultiMemberGZIPInputStream child;
    private int size;
    private boolean eos;

    public MultiMemberGZIPInputStream(InputStream inputStream, int n) throws IOException {
        super((InputStream)new PushbackInputStream(inputStream, n), n);
        this.size = n;
    }

    public MultiMemberGZIPInputStream(InputStream inputStream) throws IOException {
        super(new PushbackInputStream(inputStream, 1024));
        this.size = -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        if (this.child != null) {
            return this.child.read(byArray, n, n2);
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            int n4 = this.inf.getRemaining() - 8;
            if (n4 > 0) {
                ((PushbackInputStream)this.in).unread(this.buf, this.len - n4, n4);
            } else {
                byte[] byArray2 = new byte[1];
                int n5 = this.in.read(byArray2, 0, 1);
                if (n5 == -1) {
                    this.eos = true;
                    return -1;
                }
                ((PushbackInputStream)this.in).unread(byArray2, 0, 1);
            }
            this.child = this.size == -1 ? new MultiMemberGZIPInputStream(this.in) : new MultiMemberGZIPInputStream(this.in, this.size);
            return this.child.read(byArray, n, n2);
        }
        return n3;
    }
}

