/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java;

import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.ECJInterceptor;
import com.semmle.extractor.java.interceptors.Interceptor;
import com.semmle.extractor.java.interceptors.JasperJdtInterceptor;
import com.semmle.extractor.java.interceptors.JasperJspcInterceptor;
import com.semmle.extractor.java.interceptors.JavacMainInterceptor;
import com.semmle.extractor.java.interceptors.JavacToolInterceptor;
import com.semmle.extractor.java.interceptors.KotlinInterceptor;
import com.semmle.extractor.java.interceptors.SpecificMethodInterceptor;
import com.semmle.extractor.java.interceptors.TakariLifecycleJdtInterceptor;
import com.semmle.extractor.java.interceptors.TracingInterceptor;
import com.semmle.org.objectweb.asm.ClassReader;
import com.semmle.org.objectweb.asm.ClassVisitor;
import com.semmle.org.objectweb.asm.ClassWriter;
import com.semmle.org.objectweb.asm.Label;
import com.semmle.org.objectweb.asm.MethodVisitor;
import com.semmle.org.objectweb.asm.Opcodes;
import com.semmle.org.objectweb.asm.Type;
import com.semmle.org.objectweb.asm.commons.Method;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class InterceptingAgent
implements ClassFileTransformer {
    private static FileOutputStream out = new FileOutputStream(FileDescriptor.out);
    private static final Set<String> bootstrapLoadableClasses = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("com/sun/tools/javac/main/Main", "com/sun/tools/javac/api/JavacTool", "com/sun/source/util/JavacTask", "com/sun/tools/javac/api/JavacTaskImpl", "java/lang/Shutdown", "io/takari/maven/plugins/compile/AbstractCompiler", "io/takari/maven/plugins/compile/jdt/CompilerJdt", "org/apache/jasper/compiler/Compiler", "org/apache/jasper/compiler/JDTCompiler", "org/apache/jasper/JspC", "org/eclipse/jdt/internal/compiler/batch/Main")));
    private final Set<Interceptor> interceptors = new LinkedHashSet<Interceptor>();
    private static final int verbosity;
    private static final File logFile;
    private static final DateFormat df;
    private static final Calendar cal;
    private static final Type BYTE_TYPE;
    private static final Type BOOLEAN_TYPE;
    private static final Type SHORT_TYPE;
    private static final Type CHARACTER_TYPE;
    private static final Type INTEGER_TYPE;
    private static final Type FLOAT_TYPE;
    private static final Type LONG_TYPE;
    private static final Type DOUBLE_TYPE;
    private static final Type OBJECT_TYPE;

    public InterceptingAgent(String agentArgs, Interceptor ... extraInterceptors) {
        if (agentArgs == null) {
            agentArgs = "";
        }
        LinkedHashSet<String> args = new LinkedHashSet<String>(Arrays.asList(agentArgs.split(",")));
        String csvFile = null;
        String logFile = null;
        for (String arg : args) {
            if (arg.equals("ignore-project")) continue;
            if (arg.equals("java")) {
                if (Boolean.parseBoolean(System.getenv("CODEQL_EXTRACTOR_JAVA_AGENT_DISABLE_JAVA"))) continue;
                this.interceptors.add(new JavacMainInterceptor());
                this.interceptors.add(new JavacToolInterceptor());
                this.interceptors.add(new ECJInterceptor());
                this.interceptors.add(new TakariLifecycleJdtInterceptor());
                if (!Boolean.parseBoolean(System.getenv("CODEQL_EXTRACTOR_JAVA_JSP"))) continue;
                this.interceptors.add(new JasperJdtInterceptor());
                this.interceptors.add(new JasperJspcInterceptor());
                continue;
            }
            if (arg.equals("kotlin")) {
                if (Boolean.parseBoolean(System.getenv("CODEQL_EXTRACTOR_JAVA_AGENT_DISABLE_KOTLIN"))) continue;
                this.interceptors.add(new KotlinInterceptor());
                continue;
            }
            if (arg.equals("kotlin:experimental")) {
                if (!Boolean.parseBoolean(System.getenv("CODEQL_EXTRACTOR_JAVA_AGENT_ENABLE_KOTLIN"))) continue;
                this.interceptors.add(new KotlinInterceptor());
                continue;
            }
            if (arg.startsWith("tracing-log:")) {
                logFile = arg.substring("tracing-log:".length());
                continue;
            }
            if (arg.startsWith("tracing-in:")) {
                csvFile = arg.substring("tracing-in:".length());
                continue;
            }
            if (arg.equals("trace")) {
                this.interceptors.add(new TracingInterceptor());
                continue;
            }
            if (arg.startsWith("trace:")) {
                String logDir = arg.substring("trace:".length());
                this.interceptors.add(new TracingInterceptor(new File(logDir)));
                continue;
            }
            InterceptingAgent.warn(1, "Unrecognized agent specification: " + arg);
        }
        if (csvFile != null || logFile != null) {
            if (csvFile != null && logFile != null) {
                this.interceptors.add(new SpecificMethodInterceptor(csvFile, logFile));
            } else {
                InterceptingAgent.warn(1, "Incomplete SpecificMethodInterceptor specification");
            }
        }
        for (Interceptor i : extraInterceptors) {
            this.interceptors.add(i);
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        inst.addTransformer(new InterceptingAgent(agentArgs, new Interceptor[0]));
    }

    public static void log(String msg) {
        if (logFile != null) {
            Utils.FileUtil.append(logFile, df.format(cal.getTime()) + msg + "\n");
        } else {
            try {
                out.write((msg + "\n").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void info(int level, String msg) {
        if (level <= verbosity) {
            InterceptingAgent.log("[INFO] " + msg);
        }
    }

    public static void warn(int level, String msg) {
        if (level <= verbosity) {
            InterceptingAgent.log("[WARN] " + msg);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (loader == null && !bootstrapLoadableClasses.contains(className)) {
            InterceptingAgent.info(2, "Skipping bootstrap-loaded class " + className);
            return null;
        }
        if (className.startsWith("java/") && !className.equals("java/lang/Shutdown") || className.startsWith("javax/") || className.startsWith("sun/")) {
            InterceptingAgent.info(3, "Skipping system class " + className);
            return null;
        }
        if (className.startsWith("com/semmle/extractor/java/interceptors/")) {
            InterceptingAgent.info(3, "Skipping intercept handler class " + className);
            return null;
        }
        if (className.startsWith("jdk/internal/reflect/")) {
            InterceptingAgent.info(3, "Skipping reflection class " + className);
            return null;
        }
        if (className.startsWith("com/semmle/org/objectweb/asm/")) {
            InterceptingAgent.info(3, "Skipping ASM class " + className);
            return null;
        }
        boolean intercept = false;
        for (Interceptor i : this.interceptors) {
            if (!i.interceptType(className, loader)) continue;
            intercept = true;
        }
        if (!intercept) {
            InterceptingAgent.info(3, "Skipping class with no interested interceptor: " + className);
            return null;
        }
        InterceptingAgent.info(2, "Transforming " + className);
        try {
            ClassReader reader = new ClassReader(classfileBuffer);
            if ((reader.getAccess() & 0x200) != 0) {
                InterceptingAgent.info(3, "Skipping interface " + className);
                return null;
            }
            ClassWriter writer = new ClassWriter(reader, 1);
            reader.accept(new RewriteMethods(writer, className, this.collectMemberSignatures(classfileBuffer)), 0);
            return writer.toByteArray();
        }
        catch (RuntimeException ex) {
            InterceptingAgent.log("ERROR: Exception while processing " + className + ": " + ex);
            ex.printStackTrace(System.out);
            InterceptingAgent.log("Current class loader: " + loader);
            throw ex;
        }
    }

    private Set<String> collectMemberSignatures(byte[] classBytecode) {
        ClassReader reader = new ClassReader(classBytecode);
        MemberCollector collector = new MemberCollector();
        reader.accept(collector, 1);
        return collector.results();
    }

    static {
        int v = 1;
        try {
            v = Integer.parseInt(System.getenv("SEMMLE_JAVA_INTERCEPT_VERBOSITY"));
        }
        catch (NumberFormatException e) {
            Utils.Exceptions.ignore(e, "If verbosity cannot be parsed, use default value of 1.");
        }
        verbosity = v;
        File logFileTmp = null;
        String logDir = null;
        String agentLog = System.getenv("CODEQL_JAVA_AGENT_LOG");
        if (agentLog == null || agentLog.isEmpty()) {
            String agentLogDir = System.getenv("CODEQL_JAVA_AGENT_LOG_DIR");
            if (agentLogDir != null && !agentLogDir.isEmpty()) {
                logDir = agentLogDir;
            } else {
                String extractorLogDir = System.getenv("CODEQL_EXTRACTOR_JAVA_LOG_DIR");
                if (extractorLogDir != null && !extractorLogDir.isEmpty()) {
                    logDir = extractorLogDir;
                } else {
                    InterceptingAgent.warn(1, "Cannot find log directory CODEQL_EXTRACTOR_JAVA_LOG_DIR");
                }
            }
        } else if (!agentLog.equals("stdout")) {
            InterceptingAgent.warn(1, "Unrecognized CODEQL_JAVA_AGENT_LOG: " + agentLog);
        }
        if (logDir != null) {
            File logDirFile = new File(logDir);
            logDirFile.mkdirs();
            try {
                logFileTmp = File.createTempFile("agent.", ".log", logDirFile);
            }
            catch (IOException e) {
                InterceptingAgent.warn(1, "Failed to create log file in " + logDir);
            }
        }
        logFile = logFileTmp;
        df = new SimpleDateFormat("[yyyy-MM-dd hh:mm:ss] ");
        cal = new GregorianCalendar(TimeZone.getDefault());
        BYTE_TYPE = Type.getObjectType("java/lang/Byte");
        BOOLEAN_TYPE = Type.getObjectType("java/lang/Boolean");
        SHORT_TYPE = Type.getObjectType("java/lang/Short");
        CHARACTER_TYPE = Type.getObjectType("java/lang/Character");
        INTEGER_TYPE = Type.getObjectType("java/lang/Integer");
        FLOAT_TYPE = Type.getObjectType("java/lang/Float");
        LONG_TYPE = Type.getObjectType("java/lang/Long");
        DOUBLE_TYPE = Type.getObjectType("java/lang/Double");
        OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    }

    private class RewriteMethods
    extends ClassVisitor {
        private final String binaryTypeName;
        private final Set<String> classMembers;
        private final Map<Interceptor.Interception, Integer> applicableInterceptions;
        private boolean computeFrames;

        public RewriteMethods(ClassVisitor cv, String binaryTypeName, Set<String> classMembers) {
            super(458752, cv);
            this.applicableInterceptions = new LinkedHashMap<Interceptor.Interception, Integer>();
            this.binaryTypeName = binaryTypeName;
            this.classMembers = classMembers;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.computeFrames = version >= 50;
            InterceptingAgent.info(2, "Processing class " + name + " (bytecode version " + version + ")...");
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new InterceptMethod(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        }

        @Override
        public void visitEnd() {
            InterceptingAgent.info(3, "Creating wrapper method definitions");
            for (Map.Entry<Interceptor.Interception, Integer> e : this.applicableInterceptions.entrySet()) {
                Interceptor.Interception interception = e.getKey();
                int interceptionID = e.getValue();
                InterceptingAgent.info(3, "Creating wrapper method SEMMLE_INTERCEPT$" + interceptionID);
                Method method = Method.getMethod(interception.methodDecl());
                try {
                    MethodVisitor mv = super.visitMethod(10, "SEMMLE_INTERCEPT$" + interceptionID, method.getDescriptor(), null, null);
                    mv.visitCode();
                    Type[] argTypes = Type.getArgumentTypes(method.getDescriptor());
                    int argIndex = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        mv.visitVarInsn(argTypes[i].getOpcode(21), argIndex);
                        argIndex += argTypes[i].getSize();
                    }
                    Label startTry = new Label();
                    Label endTry = new Label();
                    Label startCatch = new Label();
                    Label afterCatch = new Label();
                    mv.visitLabel(startTry);
                    mv.visitMethodInsn(184, interception.binaryDeclTypeName(), method.getName(), method.getDescriptor(), false);
                    mv.visitJumpInsn(167, afterCatch);
                    mv.visitLabel(endTry);
                    mv.visitLabel(startCatch);
                    mv.visitTryCatchBlock(startTry, endTry, startCatch, "java/lang/NoClassDefFoundError");
                    if (this.computeFrames) {
                        mv.visitFrame(4, 0, null, 1, new Object[]{"java/lang/NoClassDefFoundError"});
                    }
                    mv.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
                    mv.visitLdcInsn("ERROR: Exception during invocation of Semmle Java compiler. Perhaps you need to put odasa-agent.jar on the boot classpath?");
                    mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
                    mv.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
                    mv.visitMethodInsn(182, "java/lang/Throwable", "printStackTrace", "(Ljava/io/PrintStream;)V", false);
                    Type returnType = method.getReturnType();
                    Object frameElementSpec = null;
                    switch (returnType.getSort()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            mv.visitLdcInsn(0);
                            frameElementSpec = Opcodes.INTEGER;
                            break;
                        }
                        case 6: {
                            mv.visitLdcInsn(Float.valueOf(0.0f));
                            frameElementSpec = Opcodes.FLOAT;
                            break;
                        }
                        case 7: {
                            mv.visitLdcInsn(0L);
                            frameElementSpec = Opcodes.LONG;
                            break;
                        }
                        case 8: {
                            mv.visitLdcInsn(0.0);
                            frameElementSpec = Opcodes.DOUBLE;
                            break;
                        }
                        case 9: {
                            mv.visitInsn(1);
                            frameElementSpec = returnType.getDescriptor();
                            break;
                        }
                        case 10: {
                            mv.visitInsn(1);
                            frameElementSpec = returnType.getInternalName();
                        }
                    }
                    if (frameElementSpec != null && this.computeFrames) {
                        mv.visitFrame(4, 0, null, 1, new Object[]{frameElementSpec});
                    }
                    mv.visitLabel(afterCatch);
                    if (this.computeFrames) {
                        mv.visitFrame(3, 0, null, 0, null);
                    }
                    mv.visitInsn(returnType.getOpcode(172));
                    mv.visitMaxs(1, 1);
                    mv.visitEnd();
                }
                catch (RuntimeException ex) {
                    InterceptingAgent.log("ERROR: Failed to process " + interception + "; calls will be missed: " + ex);
                    ex.printStackTrace();
                }
            }
            super.visitEnd();
        }

        private class InterceptMethod
        extends MethodVisitor
        implements Opcodes {
            private final String name;
            private final boolean isStatic;
            private final String desc;
            private final Type[] argTypes;

            protected InterceptMethod(MethodVisitor mv, int access, String name, String desc) {
                super(458752, mv);
                this.name = name;
                this.desc = desc;
                this.argTypes = Type.getArgumentTypes(desc);
                this.isStatic = (access & 8) != 0;
            }

            @Override
            public void visitCode() {
                this.applyInterceptors(true);
                super.visitCode();
            }

            @Override
            public void visitInsn(int opcode) {
                switch (opcode) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        this.applyInterceptors(false);
                    }
                }
                super.visitInsn(opcode);
            }

            private void applyInterceptors(boolean before) {
                InterceptingAgent.info(4, "Considering method " + this.name + this.desc + " in " + RewriteMethods.this.binaryTypeName + ".");
                for (Interceptor i : InterceptingAgent.this.interceptors) {
                    try {
                        this.applyInterceptor(i, before);
                    }
                    catch (Throwable t) {
                        InterceptingAgent.log("ERROR: Interceptor of type " + i.getClass() + " caused an exception: " + t);
                        t.printStackTrace(System.out);
                    }
                }
            }

            private void loadArg(int logicalIndex) {
                int argIndex = this.isStatic ? 0 : 1;
                for (int i = 0; i < logicalIndex; ++i) {
                    argIndex += this.argTypes[i].getSize();
                }
                this.visitVarInsn(this.argTypes[logicalIndex].getOpcode(21), argIndex);
            }

            private void loadArgArray() {
                this.visitLdcInsn(this.argTypes.length);
                this.visitTypeInsn(189, "java/lang/Object");
                for (int i = 0; i < this.argTypes.length; ++i) {
                    this.visitInsn(89);
                    this.visitLdcInsn(i);
                    this.loadArg(i);
                    this.maybeBox(this.argTypes[i]);
                    this.visitInsn(OBJECT_TYPE.getOpcode(79));
                }
            }

            private void loadArgs() {
                for (int i = 0; i < this.argTypes.length; ++i) {
                    this.loadArg(i);
                }
            }

            private void maybeBox(Type t) {
                if (t.getSort() == 10 || t.getSort() == 9) {
                    return;
                }
                Type boxed = this.getBoxedType(t);
                this.visitMethodInsn(184, boxed.getInternalName(), "valueOf", "(" + t.getDescriptor() + ")" + boxed.getDescriptor(), false);
            }

            private Type getBoxedType(Type type) {
                switch (type.getSort()) {
                    case 3: {
                        return BYTE_TYPE;
                    }
                    case 1: {
                        return BOOLEAN_TYPE;
                    }
                    case 4: {
                        return SHORT_TYPE;
                    }
                    case 2: {
                        return CHARACTER_TYPE;
                    }
                    case 5: {
                        return INTEGER_TYPE;
                    }
                    case 6: {
                        return FLOAT_TYPE;
                    }
                    case 7: {
                        return LONG_TYPE;
                    }
                    case 8: {
                        return DOUBLE_TYPE;
                    }
                }
                return type;
            }

            private void applyInterceptor(Interceptor i, boolean before) {
                if (!i.interceptType(RewriteMethods.this.binaryTypeName)) {
                    return;
                }
                Interceptor.Interception interception = i.intercept(RewriteMethods.this.binaryTypeName, RewriteMethods.this.classMembers, this.name, this.desc, before);
                if (interception != null) {
                    InterceptingAgent.info(2, "Interceptor " + i + " wants to call " + interception + " for " + RewriteMethods.this.binaryTypeName + "." + this.name + this.desc + ".");
                    this.instrument(interception);
                } else {
                    InterceptingAgent.info(3, "Interceptor " + i + " is not interested in " + RewriteMethods.this.binaryTypeName + "." + this.name + this.desc + ".");
                }
            }

            private void instrument(Interceptor.Interception interception) {
                Integer idx = (Integer)RewriteMethods.this.applicableInterceptions.get(interception);
                if (idx == null) {
                    idx = RewriteMethods.this.applicableInterceptions.size();
                    RewriteMethods.this.applicableInterceptions.put(interception, idx);
                }
                block11: for (Interceptor.CallWith cw : interception.callWith()) {
                    switch (cw) {
                        case ALL_ARGS: {
                            this.loadArgs();
                            continue block11;
                        }
                        case ALL_ARGS_AS_ARRAY: {
                            this.loadArgArray();
                            continue block11;
                        }
                        case FIRST_ARG: {
                            this.loadArg(0);
                            continue block11;
                        }
                        case CLASS: {
                            this.visitLdcInsn(RewriteMethods.this.binaryTypeName);
                            continue block11;
                        }
                        case METHOD_NAME_AND_DESC: {
                            this.visitLdcInsn(this.name);
                            this.visitLdcInsn(this.desc);
                            continue block11;
                        }
                        case STACK_TOP: {
                            this.visitInsn(89);
                            continue block11;
                        }
                        case THIS: {
                            if (this.isStatic || this.name.equals("<init>")) {
                                this.visitInsn(1);
                                continue block11;
                            }
                            this.visitVarInsn(25, 0);
                            continue block11;
                        }
                        case CONSTANT_I_0: {
                            this.visitInsn(3);
                            continue block11;
                        }
                        case CONSTANT_I_1: {
                            this.visitInsn(4);
                        }
                    }
                }
                Method method = Method.getMethod(interception.methodDecl());
                this.visitMethodInsn(184, RewriteMethods.this.binaryTypeName, "SEMMLE_INTERCEPT$" + idx, method.getDescriptor(), false);
            }
        }
    }

    private static class MemberCollector
    extends ClassVisitor {
        private final Set<String> memberSignatures = new LinkedHashSet<String>();

        public MemberCollector() {
            super(458752);
        }

        public Set<String> results() {
            return this.memberSignatures;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.memberSignatures.add(name + desc);
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

