/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public final class Utils {
    public static final int verbosity;
    private static final boolean inProcess;
    private static final String[] extractorJvmArgs;
    public static final String IN_SCALA_EXTRACTOR_PROPERTY = "semmle.extractor.scala.inextractor";
    public static final FilenameFilter jarFilter;
    private static final int MAX_TOLERATED_VERSION = 19;
    private static final int MAX_VERSION = 18;
    private static final String MIN_VERSION = "7";
    private static final Set<String> ENV_KEYS;
    private static final Set<String> ENV_KEY_PREFIXES;
    private static final Set<String> PROP_KEYS;
    private static final Set<String> PROP_KEY_PREFIXES;

    private Utils() {
    }

    private static Class<?> loadClass(String name) {
        Class<?> result;
        try {
            result = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            URL url;
            String extractorTools = Utils.getExtractorTools();
            if (extractorTools == null) {
                throw new RuntimeException("Failed to determine SEMMLE_DIST", e);
            }
            File extractorJar = new File(extractorTools, "semmle-extractor-java.jar");
            if (!extractorJar.exists() || !extractorJar.canRead()) {
                throw new RuntimeException("Cannot read semmle-extractor-java jar from " + extractorJar + " -- check SEMMLE_DIST", e);
            }
            try {
                url = extractorJar.getAbsoluteFile().toURI().toURL();
            }
            catch (MalformedURLException me) {
                throw new RuntimeException("Failed to convert " + extractorJar + " to URL", me);
            }
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            try {
                result = loader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failed to load " + name + " from " + extractorJar + " -- check SEMMLE_DIST", cnfe);
            }
        }
        return result;
    }

    public static Object runMethod(Class<?> declaringClass, String methodName, Class<?>[] argTypes, Object ... args) {
        return Utils.runMethod(null, declaringClass, methodName, argTypes, args);
    }

    public static Object runMethod(Object receiver, Class<?> declaringClass, String methodName, Class<?>[] argTypes, Object ... args) {
        try {
            return declaringClass.getMethod(methodName, argTypes).invoke(receiver, args);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Security exception while accessing method" + declaringClass + "." + methodName, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find method " + declaringClass + "." + methodName + " with argument types " + Arrays.toString(argTypes), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error while calling method " + declaringClass + "." + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Illegal access while calling method " + declaringClass + "." + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invalid invocation target while calling method " + declaringClass + "." + methodName, e);
        }
    }

    private static String getExtractorTools() {
        String extractorJavaRoot = System.getenv("CODEQL_EXTRACTOR_JAVA_ROOT");
        if (extractorJavaRoot != null) {
            return extractorJavaRoot + File.separator + "tools";
        }
        String semmleDist = System.getenv("SEMMLE_DIST");
        if (semmleDist != null) {
            return semmleDist + File.separator + "tools";
        }
        String odasaHome = System.getenv("ODASA_HOME");
        if (odasaHome != null) {
            Utils.info("Warning: Consider setting SEMMLE_DIST instead of the deprecated ODASA_HOME !", 1);
            return odasaHome + File.separator + "tools";
        }
        return System.getenv("ODASA_TOOLS");
    }

    public static int invokeOdasaJavac(int compilerExitCode, String[] args) {
        return Utils.invokeOdasaJavac(compilerExitCode, args, false);
    }

    public static int invokeOdasaJavac(int compilerExitCode, String[] args, boolean specialSourcepathHandling) {
        return Utils.invokeOdasaJavac(compilerExitCode, args, specialSourcepathHandling, new LinkedHashMap<String, String>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int invokeOdasaJavac(int compilerExitCode, String[] args, boolean specialSourcepathHandling, Map<String, String> addEnv) {
        try {
            int exitCode;
            File javacArgsFile;
            String lastArg;
            Env.OS os;
            String extractorTools = Utils.getExtractorTools();
            if (extractorTools == null) {
                Utils.info("The extractor tools cannot be found; neither CODEQL_EXTRACTOR_JAVA_ROOT nor SEMMLE_DIST are set; skipping extraction.", 1);
                return compilerExitCode;
            }
            String logDir = System.getenv("CODEQL_EXTRACTOR_JAVA_LOG_DIR");
            if (logDir == null) {
                String snapshot = System.getenv("ODASA_SNAPSHOT");
                if (snapshot == null) {
                    Utils.info("Neither CODEQL_EXTRACTOR_JAVA_LOG_DIR nor ODASA_SNAPSHOT are set; skipping extraction.", 1);
                    return compilerExitCode;
                }
                logDir = snapshot + File.separator + "log";
            }
            Utils.info("Invoking ODASA javac with args " + Arrays.toString(args), 2);
            ArrayList<String> indexArgs = new ArrayList<String>();
            indexArgs.add("-Xprefer:source");
            boolean hasJava9args = false;
            boolean hasEnablePreview = false;
            for (String arg : args) {
                if (arg != null && (arg.startsWith("--") || arg.equals("-m") || arg.equals("-p"))) {
                    hasJava9args = true;
                }
                if (!"--enable-preview".equals(arg)) continue;
                hasEnablePreview = true;
            }
            String javaSpecVersion = System.getProperty("java.specification.version");
            String javaHome = System.getProperty("java.home");
            int specVersion = Utils.parseJavaSpecVersion(javaSpecVersion);
            if (javaSpecVersion != null && javaHome != null && specVersion < 9 && !hasJava9args) {
                int srcIndex = -1;
                int tgtIndex = -1;
                String tgtValue = javaSpecVersion;
                for (int i = 0; i < args.length; ++i) {
                    if ("-source".equals(args[i]) && args.length > i + 1) {
                        srcIndex = i;
                    }
                    if (!"-target".equals(args[i]) || args.length <= i + 1) continue;
                    tgtIndex = i;
                    tgtValue = args[i + 1];
                }
                if (srcIndex < 0) {
                    if (tgtIndex < 0) {
                        indexArgs.addAll(Arrays.asList("-source", javaSpecVersion, "-target", javaSpecVersion));
                    } else {
                        indexArgs.addAll(Arrays.asList("-source", tgtValue));
                    }
                }
            }
            if ((os = Env.getOS()) != Env.OS.LINUX && os != Env.OS.WINDOWS && os != Env.OS.MACOS) {
                Utils.warn("Unsupported OS: " + (Object)((Object)os));
                return -1;
            }
            String osName = os.name().toLowerCase();
            String runExtractorJDK = null;
            if (specVersion < 9) {
                String jdkExtractorJava = extractorTools + File.separator + osName + File.separator + "jdk-extractor-java";
                if (!new File(jdkExtractorJava).exists()) {
                    Utils.warn("Extractor JDK not found: " + jdkExtractorJava);
                    return -1;
                }
                runExtractorJDK = jdkExtractorJava;
            } else if (!inProcess) {
                if (!new File(javaHome).exists()) {
                    Utils.warn("Intercepted 'java.home' not found: " + javaHome);
                    return -1;
                }
                runExtractorJDK = javaHome;
            }
            if (specVersion < 9 && !hasJava9args) {
                String jvmBootclasspath;
                String endorsedDirs;
                String envClassPath = System.getProperty("env.class.path");
                if (envClassPath != null && envClassPath.trim().length() > 0) {
                    indexArgs.add("-cp");
                    indexArgs.add(envClassPath);
                } else {
                    String classpathProperty;
                    String applicationHome = System.getProperty("application.home");
                    if (applicationHome == null && (classpathProperty = System.getProperty("java.class.path")) != null && classpathProperty.trim().length() > 0) {
                        indexArgs.add("-classpath");
                        indexArgs.add(classpathProperty);
                    }
                }
                String extDirs = System.getProperty("java.ext.dirs");
                if (extDirs != null && extDirs.trim().length() > 0) {
                    indexArgs.add("-extdirs");
                    indexArgs.add(extDirs);
                }
                if ((endorsedDirs = System.getProperty("java.endorsed.dirs")) != null && endorsedDirs.trim().length() > 0) {
                    indexArgs.add("-endorseddirs");
                    indexArgs.add(endorsedDirs);
                }
                if ((jvmBootclasspath = System.getProperty("sun.boot.class.path")) != null) {
                    indexArgs.add("-bootclasspath");
                    indexArgs.add(jvmBootclasspath);
                }
            }
            indexArgs.addAll(Arrays.asList(args));
            Utils.replaceMinJavaVersion(indexArgs);
            boolean versionOK = Utils.checkMaxJavaVersion(specVersion, hasEnablePreview, indexArgs);
            Utils.createOrigArgsFile(logDir, "javac", Arrays.asList(args));
            File argsFile = Utils.createArgsFile(logDir, "javac", indexArgs);
            if (args.length > 0 && (lastArg = args[args.length - 1]).startsWith("@") && (javacArgsFile = new File(lastArg.substring(1))).isFile()) {
                FileUtil.write(new File(argsFile.getAbsolutePath() + ".aux"), javacArgsFile + "\n\n" + FileUtil.read(javacArgsFile));
            }
            Utils.createPropertiesFile(logDir, "javac");
            Utils.createEnvFile(logDir, "javac");
            if (!versionOK) {
                return -1;
            }
            if (!inProcess) {
                Utils.info("Running ODASA build out of process...", 1);
                String executable = System.getProperty("os.name", "unknown").contains("Windows") ? "java.exe" : "java";
                executable = runExtractorJDK + File.separator + "bin" + File.separator + executable;
                ArrayList<String> cmdLine = new ArrayList<String>(Arrays.asList(executable, Utils.encoding(), "-Xmx1024M", "-Xms256M", "--add-opens", "java.base/sun.reflect.annotation=ALL-UNNAMED"));
                for (String jvmArg : extractorJvmArgs) {
                    cmdLine.add(jvmArg);
                }
                cmdLine.addAll(Arrays.asList("-classpath", extractorTools + File.separator + "semmle-extractor-java.jar", "com.semmle.extractor.java.JavaExtractor"));
                if (specialSourcepathHandling) {
                    cmdLine.add("--special-sourcepath-handling");
                }
                cmdLine.addAll(Arrays.asList("--jdk-version", String.valueOf(specVersion), "--javac-args", "@@@" + argsFile.getAbsolutePath()));
                Utils.info("Process command line: " + cmdLine, 3);
                Builder b = new Builder(cmdLine, System.out, System.err);
                b.removeEnvVar("JAVA_TOOL_OPTIONS");
                for (Map.Entry<String, String> entry : addEnv.entrySet()) {
                    b.putEnvVar(entry.getKey(), entry.getValue());
                }
                exitCode = b.execute();
            } else {
                Utils.info("Running ODASA build in process...", 0);
                Class<?> extractor = Utils.loadClass("com.semmle.extractor.java.JavaExtractor");
                ArrayList<String> cmdLine = new ArrayList<String>(Arrays.asList("--jdk-version", String.valueOf(specVersion), "--javac-args", "@@@" + argsFile.getAbsolutePath()));
                if (specialSourcepathHandling) {
                    cmdLine.add(0, "--special-sourcepath-handling");
                }
                Utils.runMethod(extractor, "main", Utils.allOf(String[].class), new Object[]{cmdLine.toArray(new String[0])});
                exitCode = 0;
            }
            if (exitCode != 0) {
                Utils.warn("Non-zero exit code " + exitCode + " from ODASA javac builder");
            }
            if (compilerExitCode != 0) {
                return compilerExitCode;
            }
            return exitCode;
        }
        catch (Exception e) {
            Utils.warn("Failed to execute ODASA javac builder: " + e);
            if (verbosity > 1) {
                e.printStackTrace();
            }
            return -1;
        }
    }

    private static void replaceMinJavaVersion(List<String> indexArgs) {
        LinkedHashSet<String> oldVersions = new LinkedHashSet<String>();
        oldVersions.addAll(Arrays.asList("1.5", "5", "1.6", "6"));
        String srcOption = null;
        String tgtOption = null;
        for (int i = 0; i < indexArgs.size(); ++i) {
            if ("-source".equals(indexArgs.get(i)) && indexArgs.size() > i + 1 && (srcOption = indexArgs.get(i + 1)) != null && oldVersions.contains(srcOption)) {
                indexArgs.set(i + 1, MIN_VERSION);
            }
            if (!"-target".equals(indexArgs.get(i)) || indexArgs.size() <= i + 1 || (tgtOption = indexArgs.get(i + 1)) == null || !oldVersions.contains(tgtOption)) continue;
            indexArgs.set(i + 1, MIN_VERSION);
        }
    }

    private static boolean checkMaxJavaVersion(int specVersion, boolean hasEnablePreview, List<String> indexArgs) {
        String srcOption = null;
        String tgtOption = null;
        String relOption = null;
        int srcVersion = -1;
        int tgtVersion = -1;
        int relVersion = -1;
        int length = indexArgs.size();
        for (int i = 0; i < length; ++i) {
            String arg = indexArgs.get(i);
            if (("-source".equals(arg) || "--source".equals(arg)) && length > i + 1 && (srcVersion = Utils.parseJavaSpecVersion(srcOption = indexArgs.get(i + 1))) > 18) {
                indexArgs.set(i + 1, String.valueOf(18));
            }
            if (("-target".equals(arg) || "--target".equals(arg)) && length > i + 1 && (tgtVersion = Utils.parseJavaSpecVersion(tgtOption = indexArgs.get(i + 1))) > 18) {
                indexArgs.set(i + 1, String.valueOf(18));
            }
            if (!"--release".equals(arg) || length <= i + 1 || (relVersion = Utils.parseJavaSpecVersion(relOption = indexArgs.get(i + 1))) <= 18) continue;
            indexArgs.set(i, "-source");
            indexArgs.set(i + 1, String.valueOf(18));
            indexArgs.add("-target");
            indexArgs.add(String.valueOf(18));
        }
        boolean checkVersion = true;
        if (specVersion > 19) {
            Utils.warn("Unsupported Java specification version " + specVersion);
            checkVersion = false;
        } else if (srcVersion > 19) {
            Utils.warn("Unsupported source Java version " + srcOption);
            checkVersion = false;
        } else if (tgtVersion > 19) {
            Utils.warn("Unsupported target Java version " + tgtOption);
            checkVersion = false;
        } else if (relVersion > 19) {
            Utils.warn("Unsupported release Java version " + relOption);
            checkVersion = false;
        }
        if (hasEnablePreview) {
            if (srcOption != null && srcVersion < 18) {
                indexArgs.add("-source");
                indexArgs.add(String.valueOf(18));
            }
            if (tgtOption != null && tgtVersion < 18) {
                indexArgs.add("-target");
                indexArgs.add(String.valueOf(18));
            }
            if (relOption != null && relVersion < 18) {
                indexArgs.add("--release");
                indexArgs.add(String.valueOf(18));
            }
        } else if (srcVersion > 18 || relVersion > 18) {
            indexArgs.add("--enable-preview");
        }
        return checkVersion;
    }

    private static int parseJavaSpecVersion(String javaSpecVersion) {
        try {
            if ("1.9".equals(javaSpecVersion)) {
                return 9;
            }
            if ("1.10".equals(javaSpecVersion)) {
                return 10;
            }
            return Integer.parseInt(javaSpecVersion);
        }
        catch (NumberFormatException e) {
            Exceptions.ignore(e, "Java specification version prior to JDK 9.");
            return -1;
        }
    }

    private static File createEnvFile(String logDir, String compiler) throws FileNotFoundException {
        ArrayList<String> env = new ArrayList<String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            env.add(key + (Utils.relevantEnvVar(key) || verbosity > 1 ? "=" + entry.getValue() : ""));
        }
        Collections.sort(env);
        return Utils.createFile(logDir, compiler, env, ".env");
    }

    private static File createPropertiesFile(String logDir, String compiler) throws FileNotFoundException {
        ArrayList<String> properties = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object key = entry.getKey();
            properties.add(key + (Utils.relevantSysProp(key.toString()) || verbosity > 1 ? "=" + entry.getValue() : ""));
        }
        Collections.sort(properties);
        return Utils.createFile(logDir, compiler, properties, ".properties");
    }

    private static File createOrigArgsFile(String logDir, String compiler, List<String> contents) throws FileNotFoundException {
        return Utils.createFile(logDir, compiler, contents, ".orig");
    }

    private static File createArgsFile(String logDir, String compiler, List<String> contents) throws FileNotFoundException {
        return Utils.createFile(logDir, compiler, contents, ".args");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createFile(String logDir, String compiler, List<String> contents, String extension) throws FileNotFoundException {
        File extDir = new File(logDir, "ext");
        extDir.mkdirs();
        File file = FileUtil.createUniqueFile(extDir, compiler + extension).getAbsoluteFile();
        FileOutputStream fileDescriptor = null;
        PrintStream writer = null;
        try {
            fileDescriptor = new FileOutputStream(file);
            writer = new PrintStream(fileDescriptor);
            for (String line : contents) {
                writer.println(line.replace("\n", "\\n"));
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(writer);
            FileUtil.close(fileDescriptor);
            throw throwable;
        }
        FileUtil.close(writer);
        FileUtil.close(fileDescriptor);
        return file;
    }

    private static boolean relevantEnvVar(String key) {
        return Utils.relevantKey(key, ENV_KEYS, ENV_KEY_PREFIXES);
    }

    private static boolean relevantSysProp(String key) {
        return Utils.relevantKey(key, PROP_KEYS, PROP_KEY_PREFIXES);
    }

    private static boolean relevantKey(String key, Set<String> relevantKeys, Set<String> relevantPrefixes) {
        if (relevantKeys.contains(key)) {
            return true;
        }
        for (String prefix : relevantPrefixes) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] allOf(Class<?> ... objects) {
        return objects;
    }

    public static void info(String msg, int level) {
        if (verbosity >= level) {
            System.out.println(msg);
        }
    }

    public static void warn(String msg) {
        System.err.println("[ODASA Javac] " + msg);
    }

    public static String encoding() {
        return "-Dfile.encoding=" + Charset.defaultCharset();
    }

    static {
        inProcess = Boolean.valueOf(System.getenv("ODASA_JAVAC_IN_PROCESS"));
        String verbose = System.getenv("ODASA_JAVAC_VERBOSE");
        if (verbose == null) {
            verbosity = 0;
        } else if (Boolean.valueOf(verbose).booleanValue()) {
            verbosity = 1;
        } else {
            int tmp = 0;
            try {
                tmp = Integer.valueOf(verbose);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            verbosity = tmp;
        }
        String jvmArgs = System.getenv("SEMMLE_JAVA_EXTRACTOR_JVM_ARGS");
        if (jvmArgs != null) {
            String[] args = jvmArgs.split("\\s");
            extractorJvmArgs = args;
        } else {
            extractorJvmArgs = new String[0];
        }
        jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        };
        ENV_KEYS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("PATH", "PWD", "SOURCE_ARCHIVE", "TRAP_FOLDER")));
        ENV_KEY_PREFIXES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("ODASA_", "SEMMLE_", "JAVA_", "CODEQL_")));
        PROP_KEYS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("application.home", "line.separator", "path.separator", "user.dir", "user.home")));
        PROP_KEY_PREFIXES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("file.", "java.", "jdk.", "os.", "sun.")));
    }

    private static class Env {
        private Env() {
        }

        public static String getOSName() {
            return System.getProperty("os.name");
        }

        public static OS getOS() {
            String name = Env.getOSName();
            if (name == null) {
                return OS.UNKNOWN;
            }
            if (name.contains("Windows")) {
                return OS.WINDOWS;
            }
            if (name.contains("Mac OS X")) {
                return OS.MACOS;
            }
            if (name.contains("Linux")) {
                return OS.LINUX;
            }
            return OS.UNKNOWN_UNIX;
        }

        private static enum OS {
            WINDOWS,
            LINUX,
            MACOS,
            UNKNOWN_UNIX,
            UNKNOWN;

        }
    }

    public static class FileUtil {
        private static final Charset UTF8 = Charset.forName("UTF-8");

        public static void close(Closeable c) {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    Exceptions.ignore(e, "Exception during close.");
                }
            }
        }

        public static final File createUniqueFile(File baseDirectory, String fileName) {
            return FileUtil.createUniqueFileImpl(baseDirectory, fileName);
        }

        private static final File createUniqueFileImpl(File baseDirectory, String fileName) {
            String baseName;
            if (!baseDirectory.exists()) {
                throw new IllegalArgumentException("FileUtil.makeUniqueName(" + baseDirectory + ",\"" + fileName + "\"):  directory " + baseDirectory + " does not exist.");
            }
            if (!baseDirectory.isDirectory()) {
                throw new IllegalArgumentException("FileUtil.makeUniqueName(" + baseDirectory + ",\"" + fileName + "\"):  file " + baseDirectory + " is not a directory.");
            }
            if (fileName.contains("/")) {
                throw new IllegalArgumentException("FileUtil.makeUniqueName(" + baseDirectory + ",\"" + fileName + "\"):  file name \"" + fileName + "\" is not a simple file name.");
            }
            String name = baseName = fileName;
            File candidateFile = new File(baseDirectory, name);
            String extension = FileUtil.extension(new File(baseName));
            int i = 1;
            try {
                while (!candidateFile.createNewFile()) {
                    name = extension.length() > 0 ? baseName.substring(0, baseName.length() - extension.length()) + "-" + i + extension : baseName + "-" + i;
                    candidateFile = new File(baseDirectory, name);
                    ++i;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create a unique file in " + baseDirectory, e);
            }
            return candidateFile;
        }

        public static String extension(File f) {
            int i = f.getName().lastIndexOf(46);
            if (i == -1) {
                return "";
            }
            String extension = f.getName().substring(i);
            if (extension.equals(".gz")) {
                int before = f.getName().lastIndexOf(46, i - 1);
                if (before == -1) {
                    return extension;
                }
                String combinedExtension = f.getName().substring(before);
                return combinedExtension;
            }
            if (extension.equals(".zip") && f.getName().endsWith(".xml.zip")) {
                return ".xml.zip";
            }
            return extension;
        }

        public static void write(File f, String contents) {
            FileOutputStream fos = null;
            OutputStreamWriter writer = null;
            try {
                fos = new FileOutputStream(f, false);
                writer = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
                ((Writer)writer).append(contents);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(writer);
                    FileUtil.close(fos);
                    throw throwable;
                }
            }
            FileUtil.close(writer);
            FileUtil.close(fos);
        }

        public static void recursiveFind(File file, String extension, List<File> result) {
            File[] files;
            if (file.isFile()) {
                if (file.getName().endsWith("." + extension)) {
                    result.add(file);
                }
            } else if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    FileUtil.recursiveFind(f, extension, result);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public static String read(File file) {
            String string;
            FileInputStream fis = null;
            long longLength = file.length();
            if (longLength > 0x100000L) {
                Logger.warn("FileUtil", "Refusing to read " + file + " (of size " + longLength + ").");
                return "";
            }
            int length = (int)longLength;
            try {
                fis = new FileInputStream(file);
                byte[] content = new byte[length];
                for (int read = 0; read < length; read += fis.read(content, read, length - read)) {
                }
                string = new String(content, "UTF-8");
            }
            catch (IOException e) {
                Logger.warn("FileUtil", "Reading " + file + " failed: " + e);
                String string2 = "";
                FileUtil.close(fis);
                return string2;
            }
            catch (RuntimeException e2) {
                Logger.warn("FileUtil", "Reading " + file + " failed: " + e2);
                String string3 = "";
                {
                    catch (Throwable throwable) {
                        FileUtil.close(fis);
                        throw throwable;
                    }
                }
                FileUtil.close(fis);
                return string3;
            }
            FileUtil.close(fis);
            return string;
        }

        public static void append(File file, String content) {
            Writer writer = null;
            try {
                writer = FileUtil.openWriterUTF8(file, false, true);
                writer.write(content);
            }
            catch (IOException e) {
                try {
                    throw new ResourceError("Failed to append to file " + file, e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(writer);
                    throw throwable;
                }
            }
            FileUtil.close(writer);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Writer openWriterUTF8(File file, boolean overwrite, boolean append) {
            try {
                FileOutputStream ostream;
                if (file.exists()) {
                    if (append) {
                        ostream = new FileOutputStream(file, true);
                        return new OutputStreamWriter((OutputStream)ostream, UTF8);
                    } else {
                        if (!overwrite) throw new ResourceError("File already exists: " + file);
                        if (!file.delete()) {
                            throw new ResourceError("Could not delete existing file: " + file);
                        }
                        ostream = new FileOutputStream(file, false);
                    }
                    return new OutputStreamWriter((OutputStream)ostream, UTF8);
                } else {
                    ostream = new FileOutputStream(file, false);
                }
                return new OutputStreamWriter((OutputStream)ostream, UTF8);
            }
            catch (SecurityException se) {
                throw new ResourceError("Could not access file " + file, se);
            }
            catch (IOException ioe) {
                throw new ResourceError("Failed to open FileWriter for " + file, ioe);
            }
        }

        private static class ResourceError
        extends RuntimeException {
            public ResourceError(String s) {
                super(s);
            }

            public ResourceError(String s, Throwable t) {
                super(s, t);
            }
        }
    }

    private static class Builder {
        private final ProcessBuilder builder;
        private final List<String> args;
        private final OutputStream err;
        private final OutputStream out;
        private final long timeout;
        private volatile boolean interrupted = false;

        public Builder(List<String> args, OutputStream out, OutputStream err) {
            this.args = new ArrayList<String>(args);
            this.builder = new ProcessBuilder(this.args);
            this.out = out;
            this.err = err;
            this.timeout = 0L;
        }

        public void putEnvVar(String key, String value) {
            this.builder.environment().put(key, value);
        }

        public void removeEnvVar(String name) {
            this.builder.environment().remove(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int execute() {
            int n;
            InputStream inputStream;
            InputStream errorStream;
            block29: {
                block28: {
                    Thread inMuncher;
                    block27: {
                        errorStream = null;
                        inputStream = null;
                        Process process = null;
                        Thread errMuncher = null;
                        inMuncher = null;
                        Timer timer = null;
                        try {
                            Builder builder = this;
                            synchronized (builder) {
                                if (this.interrupted) {
                                    throw new InterruptedException();
                                }
                            }
                            process = this.builder.start();
                            errorStream = process.getErrorStream();
                            errMuncher = new StreamMuncher(errorStream, this.err);
                            errMuncher.start();
                            inputStream = process.getInputStream();
                            inMuncher = new StreamMuncher(inputStream, this.out);
                            inMuncher.start();
                            timer = new Timer();
                            if (this.timeout != 0L) {
                                final Thread current = Thread.currentThread();
                                timer.schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        current.interrupt();
                                    }
                                }, this.timeout);
                            }
                            int result = process.waitFor();
                            Builder builder2 = this;
                            synchronized (builder2) {
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                            }
                            timer.cancel();
                            if (result != 0) {
                                Logger.error("Process Builder", "Spawned process exited abnormally (code " + result + "; tried to run: " + this.args);
                            }
                            n = result;
                            if (errMuncher == null) break block27;
                        }
                        catch (IOException e) {
                            try {
                                throw new RuntimeException("IOException while executing process with args: " + this.args, e);
                                catch (InterruptedException e2) {
                                    if (process != null) {
                                        process.destroy();
                                        process = null;
                                    }
                                    if (timer != null) {
                                        timer.cancel();
                                        timer = null;
                                    }
                                    throw new RuntimeException("InterruptedException while executing process with args: " + this.args, e2);
                                }
                            }
                            catch (Throwable throwable) {
                                if (errMuncher != null && errMuncher.isAlive() || inMuncher != null && inMuncher.isAlive()) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                if (inputStream != null) {
                                    FileUtil.close(inputStream);
                                    inputStream = null;
                                }
                                if (errorStream != null) {
                                    FileUtil.close(errorStream);
                                    errorStream = null;
                                }
                                throw throwable;
                            }
                        }
                        if (errMuncher.isAlive()) break block28;
                    }
                    if (inMuncher == null || !inMuncher.isAlive()) break block29;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                FileUtil.close(inputStream);
                inputStream = null;
            }
            if (errorStream != null) {
                FileUtil.close(errorStream);
                return n;
            }
            return n;
        }

        public String toString() {
            return Builder.commandLineToString(this.args);
        }

        public static String commandLineToString(List<String> commandLine) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String s : commandLine) {
                boolean tricky;
                boolean bl = tricky = s.contains(" ") || s.length() == 0;
                if (!first) {
                    sb.append(" ");
                }
                first = false;
                if (tricky) {
                    sb.append("\"");
                }
                sb.append(s.replace("\"", "\\\""));
                if (!tricky) continue;
                sb.append("\"");
            }
            return sb.toString();
        }

        public static class StreamMuncher
        extends Thread {
            private final InputStream is;
            private PrintStream output;

            public StreamMuncher(InputStream is, OutputStream output) {
                this.is = is;
                if (output != null) {
                    this.output = new PrintStream(output);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    InputStreamReader isr = null;
                    BufferedReader br = null;
                    try {
                        isr = new InputStreamReader(this.is);
                        br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            if (this.output == null) continue;
                            this.output.println(line);
                            this.output.flush();
                        }
                        FileUtil.close(br);
                    }
                    catch (IOException e) {
                        Exceptions.ignore(e, "When the process exits, a harmless IOException will occur here");
                        break block6;
                    }
                    finally {
                        FileUtil.close(br);
                        FileUtil.close(isr);
                    }
                    FileUtil.close(isr);
                }
            }
        }
    }

    public static class Exceptions {
        public static void ignore(Throwable t, String msg) {
        }
    }

    private static class Logger {
        private Logger() {
        }

        private static void warn(String category, String msg) {
            System.out.println("[" + category + "] " + msg);
        }

        private static void error(String category, String msg) {
            System.err.println("[" + category + "] " + msg);
        }
    }
}

