/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ECJInterceptor
extends Interceptor {
    private static final String BINARY_NAME = "com/semmle/extractor/java/interceptors/ECJInterceptor";
    private static final String ECJ_MAIN_BINARY_NAME = "org/eclipse/jdt/internal/compiler/batch/Main";
    private static Map<Object, EcjInterception> ecjMap = Collections.synchronizedMap(new IdentityHashMap());
    private static final Pattern SQR_BRACKETS = Pattern.compile("\\[[^\\]]*\\]");
    private static final EcjOptionConverter Ignore = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
        }
    };
    private static final EcjOptionConverter Identical = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            javacArgs.add(ecjOpt);
            for (String param : params) {
                javacArgs.add(param);
            }
        }
    };
    private static final EcjOptionConverter StripBrackets = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            javacArgs.add(ecjOpt);
            for (String param : params) {
                javacArgs.add(ECJInterceptor.stripSquareBrackets(param));
            }
        }
    };
    private static final EcjOptionConverter DestinationDir = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            if (params.length <= 0 || !"none".equals(params[0])) {
                Identical.convert(ecjOpt, params, javacArgs);
            }
        }
    };
    private static final EcjOptionConverter NormalizeVersion = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            String[] normParams = new String[params.length];
            for (int i = 0; i < normParams.length; ++i) {
                normParams[i] = params[i].endsWith(".0") ? params[i].substring(0, params[i].length() - 2) : params[i];
            }
            Identical.convert(ecjOpt, normParams, javacArgs);
        }
    };
    private static final EcjOptionConverter ConvertVersion = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            if ("-1.3".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "1.3", "-target", "1.1"));
            } else if ("-1.4".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "1.3", "-target", "1.2"));
            } else if ("-1.5".equals(ecjOpt) || "-5".equals(ecjOpt) || "-5.0".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "1.5", "-target", "1.5"));
            } else if ("-1.6".equals(ecjOpt) || "-6".equals(ecjOpt) || "-6.0".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "1.6", "-target", "1.6"));
            } else if ("-1.7".equals(ecjOpt) || "-7".equals(ecjOpt) || "-7.0".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "1.7", "-target", "1.7"));
            } else if ("-1.8".equals(ecjOpt) || "-8".equals(ecjOpt) || "-8.0".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "1.8", "-target", "1.8"));
            } else if ("-1.9".equals(ecjOpt) || "-9".equals(ecjOpt) || "-9.0".equals(ecjOpt)) {
                javacArgs.addAll(Arrays.asList("-source", "9", "-target", "9"));
            }
        }
    };
    private static final EcjOptionConverter NoWarn = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            javacArgs.add("-nowarn");
        }
    };
    private static final EcjOptionConverter Unexpanded = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            Interceptor.warn(1, "Encountered unexpanded ECJ command line argument: " + ecjOpt);
        }
    };
    private static final EcjOptionConverter MaxProblems = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            if (params.length > 0) {
                javacArgs.addAll(Arrays.asList("-Xmaxerrs", params[0], "-Xmaxwarns", params[0]));
            }
        }
    };
    private static final EcjOptionConverter Help = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            javacArgs.add("-help");
        }
    };
    private static final EcjOptionConverter Version = new EcjOptionConverter(){

        @Override
        public void convert(String ecjOpt, String[] params, List<String> javacArgs) {
            javacArgs.add("-version");
        }
    };

    private static String stripSquareBrackets(String argument) {
        return SQR_BRACKETS.matcher(argument).replaceAll("");
    }

    @Override
    public boolean interceptType(String binaryTypeName) {
        return (this.interceptEcjType(binaryTypeName) || this.interceptShutdownType(binaryTypeName)) && this.javaEnabled();
    }

    private boolean interceptEcjType(String binaryTypeName) {
        return binaryTypeName.equals(ECJ_MAIN_BINARY_NAME);
    }

    private boolean interceptShutdownType(String binaryTypeName) {
        return binaryTypeName.equals("java/lang/Shutdown");
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (this.interceptEcjType(binaryTypeName)) {
            if (methodName.equals("compile") && methodDescriptor.equals("([Ljava/lang/String;)Z")) {
                if (before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordStartTime(Object)", Interceptor.CallWith.THIS);
                }
                return new Interceptor.Interception(BINARY_NAME, "int invokeJavaExtractor(int,Object)", Interceptor.CallWith.THIS);
            }
            if (methodName.equals("configure") && methodDescriptor.equals("([Ljava/lang/String;)V") && !before) {
                return new Interceptor.Interception(BINARY_NAME, "void recordExpandedEcjArgs(Object)", Interceptor.CallWith.THIS);
            }
        }
        if (this.interceptShutdownType(binaryTypeName) && methodName.equals("halt") && before) {
            return new Interceptor.Interception(BINARY_NAME, "void invokeJavaExtractor(Object)", Interceptor.CallWith.THIS);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterceptionMethod
    public static void recordExpandedEcjArgs(Object main) {
        EcjInterception ecji = ecjMap.get(main);
        if (ecji == null) {
            ECJInterceptor.warn(1, "Unexpected interception of configure method, prior to interception of compile method.");
            return;
        }
        Class<?> ecjMainClass = main.getClass();
        try {
            String expectedEcjMainClassName = ECJ_MAIN_BINARY_NAME.replaceAll("/", ".");
            while (!ecjMainClass.getName().equals(expectedEcjMainClassName)) {
                ECJInterceptor.info(2, "Unexpected ECJ class name: " + ecjMainClass.getName() + "; searching super-class...");
                if ((ecjMainClass = ecjMainClass.getSuperclass()) != null) continue;
                ECJInterceptor.warn(1, "Failed to find ECJ Main class with qualified name: " + expectedEcjMainClassName);
                return;
            }
            Field expandedCommandLineField = ecjMainClass.getDeclaredField("expandedCommandLine");
            expandedCommandLineField.setAccessible(true);
            try {
                Object objExpandedCommandLine = expandedCommandLineField.get(main);
                if (objExpandedCommandLine instanceof String[]) {
                    EcjInterception.access$002(ecji, (String[])objExpandedCommandLine);
                } else {
                    ECJInterceptor.warn(1, "ECJ Main.expandedCommandLine field has unexpected type: " + objExpandedCommandLine.getClass());
                }
            }
            catch (IllegalAccessException e) {
                ECJInterceptor.warn(1, "Cannot obtain access to ECJ Main field: " + e);
            }
            finally {
                try {
                    expandedCommandLineField.setAccessible(false);
                }
                catch (SecurityException e) {
                    ECJInterceptor.warn(1, "Failed to reset ECJ Main field accessibility: " + e);
                }
            }
        }
        catch (NoSuchFieldException e) {
            ECJInterceptor.warn(1, "Failed to find ECJ Main.expandedCommandLine field: " + e);
        }
        catch (SecurityException e) {
            ECJInterceptor.warn(1, "Failed to make ECJ Main field accessible: " + e);
        }
    }

    @InterceptionMethod
    public static void recordStartTime(Object main) {
        EcjInterception ecjiPrev = ecjMap.put(main, new EcjInterception());
        if (ecjiPrev != null) {
            ECJInterceptor.warn(1, "Unexpected concurrent invocation of compile method on the same ECJ instance: " + main);
        }
    }

    @InterceptionMethod
    public static void invokeJavaExtractor(Object main) {
        ECJInterceptor.invokeJavaExtractor(0, main);
    }

    @InterceptionMethod
    public static int invokeJavaExtractor(int compilerExitCode, Object main) {
        EcjInterception ecji = ecjMap.remove(main);
        if (ecji != null) {
            if (ecji.expandedEcjArgs != null) {
                return ECJInterceptor.invokeExtractorWithArgs(compilerExitCode, ecji);
            }
            ECJInterceptor.warn(1, "Failed to intercept expanded ECJ command line arguments prior to extractor invocation.");
        }
        return -1;
    }

    private static int invokeExtractorWithArgs(int compilerExitCode, EcjInterception ecji) {
        ECJInterceptor.info(2, "Intercepted ECJ Main: " + Arrays.toString(ecji.expandedEcjArgs));
        String[] javacArgs = ECJInterceptor.convertEcjArgsToJavacArgs(ecji.expandedEcjArgs);
        return Utils.invokeOdasaJavac(compilerExitCode, javacArgs);
    }

    protected static String[] convertEcjArgsToJavacArgs(String[] ecjArgs) {
        GroovyDetection gd = new GroovyDetection();
        ArrayList<String> javacArgs = new ArrayList<String>();
        for (int i = 0; i < ecjArgs.length; ++i) {
            String arg = ecjArgs[i];
            EcjOption opt = EcjOption.match(arg);
            if (opt != null) {
                if (i + opt.numParam < ecjArgs.length) {
                    String[] params = new String[opt.numParam];
                    System.arraycopy(ecjArgs, i + 1, params, 0, opt.numParam);
                    opt.converter.convert(arg, params, javacArgs);
                    gd.recordParams(opt, params);
                } else {
                    ECJInterceptor.warn(1, "Missing argument for option: " + arg);
                }
                i += opt.numParam;
                continue;
            }
            if (arg.startsWith("-")) {
                ECJInterceptor.warn(1, "Unknown ECJ argument: " + arg);
                continue;
            }
            String strippedArg = ECJInterceptor.stripSquareBrackets(arg);
            File fileArg = new File(strippedArg);
            if (fileArg.exists()) {
                if (fileArg.isFile()) {
                    if (strippedArg.endsWith(".java")) {
                        javacArgs.add(strippedArg);
                        continue;
                    }
                    ECJInterceptor.info(2, "Skipping non-Java file: " + arg);
                    gd.groovyFileDetection(strippedArg);
                    continue;
                }
                ArrayList<File> files = new ArrayList<File>();
                Utils.FileUtil.recursiveFind(fileArg, "java", files);
                for (File file : files) {
                    javacArgs.add(file.getAbsolutePath());
                }
                gd.groovyDirDetection(fileArg);
                continue;
            }
            ECJInterceptor.warn(1, "Unknown argument or non-existent file: " + arg);
        }
        gd.groovyClasspathModification(javacArgs);
        return javacArgs.toArray(new String[javacArgs.size()]);
    }

    static /* synthetic */ EcjOptionConverter access$1100() {
        return StripBrackets;
    }

    static /* synthetic */ EcjOptionConverter access$1300() {
        return DestinationDir;
    }

    static /* synthetic */ EcjOptionConverter access$1400() {
        return NormalizeVersion;
    }

    static /* synthetic */ EcjOptionConverter access$1500() {
        return ConvertVersion;
    }

    static /* synthetic */ EcjOptionConverter access$1600() {
        return Ignore;
    }

    static /* synthetic */ EcjOptionConverter access$1700() {
        return NoWarn;
    }

    static /* synthetic */ EcjOptionConverter access$1800() {
        return Unexpanded;
    }

    static /* synthetic */ EcjOptionConverter access$1900() {
        return MaxProblems;
    }

    static /* synthetic */ EcjOptionConverter access$2000() {
        return Help;
    }

    static /* synthetic */ EcjOptionConverter access$2100() {
        return Version;
    }

    private static interface EcjOptionConverter {
        public void convert(String var1, String[] var2, List<String> var3);
    }

    private static class EcjInterception {
        private String[] expandedEcjArgs;

        private EcjInterception() {
        }

        static /* synthetic */ String[] access$002(EcjInterception x0, String[] x1) {
            x0.expandedEcjArgs = x1;
            return x1;
        }
    }

    private static class GroovyDetection {
        private boolean detectedGroovyFile = false;
        private EcjOption classpathOption = null;
        private String[] classpathParams = null;
        private EcjOption destinationDirOption = null;
        private String[] destinationDirParams = null;

        private GroovyDetection() {
        }

        private void groovyFileDetection(String filename) {
            if (!this.detectedGroovyFile && filename.endsWith(".groovy")) {
                Interceptor.info(2, "Detected Groovy source file.");
                this.detectedGroovyFile = true;
            }
        }

        private void groovyDirDetection(File fileArg) {
            ArrayList<File> groovyFiles = new ArrayList<File>();
            Utils.FileUtil.recursiveFind(fileArg, "groovy", groovyFiles);
            if (groovyFiles.size() > 0) {
                this.groovyFileDetection(".groovy");
            }
        }

        private void recordParams(EcjOption opt, String[] params) {
            if (opt == EcjOption.CLASSPATH || opt == EcjOption.CP) {
                this.classpathOption = opt;
                this.classpathParams = params;
            } else if (opt == EcjOption.D) {
                this.destinationDirOption = opt;
                this.destinationDirParams = params;
            }
        }

        private void groovyClasspathModification(List<String> javacArgs) {
            if (this.detectedGroovyFile) {
                if (this.classpathOption != null && this.destinationDirOption != null) {
                    String destDir;
                    ArrayList<String> classpathArg = new ArrayList<String>();
                    this.classpathOption.converter.convert(this.classpathOption.text, this.classpathParams, classpathArg);
                    ArrayList<String> destinationDirArg = new ArrayList<String>();
                    this.destinationDirOption.converter.convert(this.destinationDirOption.text, this.destinationDirParams, destinationDirArg);
                    String classpath = classpathArg.size() == 2 ? (String)classpathArg.get(1) : null;
                    String string = destDir = destinationDirArg.size() == 2 ? (String)destinationDirArg.get(1) : null;
                    if (classpath != null && destDir != null) {
                        Interceptor.info(2, "Modifying classpath by appending destination directory.");
                        javacArgs.add(this.classpathOption.text);
                        javacArgs.add(classpath + File.pathSeparatorChar + destDir);
                    } else {
                        Interceptor.warn(1, "Failed to parse destination directory or classpath.");
                    }
                } else {
                    Interceptor.warn(1, "Cannot append destination directory to classpath. Missing option.");
                }
            }
        }
    }

    private static enum EcjOption {
        BOOTCLASSPATH("-bootclasspath", false, 1, ECJInterceptor.access$1100()),
        CP("-cp", false, 1, ECJInterceptor.access$1100()),
        CLASSPATH("-classpath", false, 1, ECJInterceptor.access$1100()),
        EXT_DIRS("-extdirs", false, 1, ECJInterceptor.access$1200()),
        ENDORSED_DIRS("-endorseddirs", false, 1, ECJInterceptor.access$1200()),
        SOURCEPATH("-sourcepath", false, 1, ECJInterceptor.access$1100()),
        D("-d", false, 1, ECJInterceptor.access$1300()),
        ENCODING("-encoding", false, 1, ECJInterceptor.access$1200()),
        SYSTEM("--system", false, 1, ECJInterceptor.access$1200()),
        MODULE_PATH("--module-path", false, 1, ECJInterceptor.access$1200()),
        P("-p", false, 1, ECJInterceptor.access$1200()),
        MODULE_SOURCE_PATH("--module-source-path", false, 1, ECJInterceptor.access$1200()),
        ADD_EXPORTS("--add-exports", false, 1, ECJInterceptor.access$1200()),
        ADD_READS("--add-reads", false, 1, ECJInterceptor.access$1200()),
        SOURCE("-source", false, 1, ECJInterceptor.access$1400()),
        TARGET("-target", false, 1, ECJInterceptor.access$1400()),
        V1_3("-1.3", false, 0, ECJInterceptor.access$1500()),
        V1_4("-1.4", false, 0, ECJInterceptor.access$1500()),
        V1_5("-1.5", false, 0, ECJInterceptor.access$1500()),
        V1_6("-1.6", false, 0, ECJInterceptor.access$1500()),
        V1_7("-1.7", false, 0, ECJInterceptor.access$1500()),
        V1_8("-1.8", false, 0, ECJInterceptor.access$1500()),
        V1_9("-1.9", false, 0, ECJInterceptor.access$1500()),
        V5("-5", false, 0, ECJInterceptor.access$1500()),
        V6("-6", false, 0, ECJInterceptor.access$1500()),
        V7("-7", false, 0, ECJInterceptor.access$1500()),
        V8("-8", false, 0, ECJInterceptor.access$1500()),
        V9("-9", false, 0, ECJInterceptor.access$1500()),
        V5_0("-5.0", false, 0, ECJInterceptor.access$1500()),
        V6_0("-6.0", false, 0, ECJInterceptor.access$1500()),
        V7_0("-7.0", false, 0, ECJInterceptor.access$1500()),
        V8_0("-8.0", false, 0, ECJInterceptor.access$1500()),
        V9_0("-9.0", false, 0, ECJInterceptor.access$1500()),
        QUESTIONMARK_WARN("-?:warn", false, 0, ECJInterceptor.access$1600()),
        HELP_WARN("-help:warn", false, 0, ECJInterceptor.access$1600()),
        NOWARN("-nowarn", false, 0, ECJInterceptor.access$1200()),
        WARN_NONE("-warn:none", false, 0, ECJInterceptor.access$1700()),
        NOWARN_SPECIFIC("-nowarn:", true, 0, ECJInterceptor.access$1600()),
        INFO("-info:", true, 0, ECJInterceptor.access$1600()),
        WARN("-warn:", true, 0, ECJInterceptor.access$1600()),
        ERR("-err:", true, 0, ECJInterceptor.access$1600()),
        DEPRECATION("-deprecation", false, 0, ECJInterceptor.access$1200()),
        PROPERTIES("-properties", false, 1, ECJInterceptor.access$1600()),
        G("-g", false, 0, ECJInterceptor.access$1200()),
        G_SPECIFIC("-g:", true, 0, ECJInterceptor.access$1200()),
        PRESERVE_ALL_LOCALS("-preserveAllLocals", true, 0, ECJInterceptor.access$1600()),
        A("-A", true, 0, ECJInterceptor.access$1200()),
        PROC("-proc:", true, 0, ECJInterceptor.access$1200()),
        PROCESSOR("-processor", true, 1, ECJInterceptor.access$1200()),
        S("-s", false, 1, ECJInterceptor.access$1200()),
        X_PRINT_PROCESSOR_INFO("-XprintProcessorInfo", false, 0, ECJInterceptor.access$1200()),
        X_PRINT_ROUNDS("-XprintRounds", false, 0, ECJInterceptor.access$1200()),
        CLASS_NAMES("-classNames", false, 1, ECJInterceptor.access$1600()),
        AT("@", true, 0, ECJInterceptor.access$1800()),
        MAX_PROBLEMS("-maxProblems", false, 1, ECJInterceptor.access$1900()),
        LOG("-log", false, 1, ECJInterceptor.access$1600()),
        PROCEED_ON_ERROR("-proceedOnError", true, 0, ECJInterceptor.access$1600()),
        VERBOSE("-verbose", false, 0, ECJInterceptor.access$1200()),
        REFERENCE_INFO("-referenceInfo", false, 0, ECJInterceptor.access$1600()),
        PROGRESS("-progress", false, 0, ECJInterceptor.access$1600()),
        TIME("-time", false, 0, ECJInterceptor.access$1600()),
        NO_EXIT("-noExit", false, 0, ECJInterceptor.access$1600()),
        REPEAT("-repeat", false, 1, ECJInterceptor.access$1600()),
        INLINE_JSR("-inlineJSR", false, 0, ECJInterceptor.access$1600()),
        ENABLE_JAVADOC("-enableJavadoc", false, 0, ECJInterceptor.access$1600()),
        PARAMETERS("-parameters", false, 0, ECJInterceptor.access$1200()),
        GENERIC_SIGNATURE("-genericsignature", false, 0, ECJInterceptor.access$1600()),
        XEMACS("-Xemacs", false, 0, ECJInterceptor.access$1600()),
        MISSING_NULL_DEFAULT("-missingNullDefault", false, 0, ECJInterceptor.access$1600()),
        ANNOTATION_PATH("-annotationpath", false, 1, ECJInterceptor.access$1600()),
        QUESTION_MARK("-?", false, 0, ECJInterceptor.access$2000()),
        HELP("-help", false, 0, ECJInterceptor.access$2000()),
        V("-v", false, 0, ECJInterceptor.access$2100()),
        VERSION("-version", false, 0, ECJInterceptor.access$2100()),
        SHOWVERSION("-showversion", false, 0, ECJInterceptor.access$2100()),
        J("-J", true, 0, ECJInterceptor.access$1600()),
        X("-X", true, 0, ECJInterceptor.access$1600()),
        O("-O", false, 0, ECJInterceptor.access$1600());

        private final String text;
        private final boolean prefix;
        private final int numParam;
        private final EcjOptionConverter converter;

        private EcjOption(String text, boolean prefix, int numParam, EcjOptionConverter converter) {
            this.text = text;
            this.prefix = prefix;
            this.numParam = numParam;
            this.converter = converter;
        }

        private static EcjOption match(String arg) {
            for (EcjOption opt : EcjOption.values()) {
                if ((opt.prefix || !arg.equals(opt.text)) && (!opt.prefix || !arg.startsWith(opt.text))) continue;
                return opt;
            }
            return null;
        }
    }
}

