/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptingAgent;
import java.util.Arrays;
import java.util.Set;

public abstract class Interceptor {
    protected static void warn(int level, String msg) {
        InterceptingAgent.warn(level, msg);
    }

    protected static void info(int level, String msg) {
        InterceptingAgent.info(level, msg);
    }

    protected boolean javaEnabled() {
        String s = System.getenv("CODEQL_JAVA_AGENT_DISABLE_JAVA");
        return s == null || s.isEmpty();
    }

    protected boolean kotlinEnabled() {
        String s = System.getenv("CODEQL_JAVA_AGENT_DISABLE_KOTLIN");
        return s == null || s.isEmpty();
    }

    public abstract boolean interceptType(String var1);

    public boolean interceptType(String binaryTypeName, ClassLoader loader) {
        return this.interceptType(binaryTypeName);
    }

    public abstract Interception intercept(String var1, Set<String> var2, String var3, String var4, boolean var5);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Interception {
        private final String binaryDeclTypeName;
        private final String methodDecl;
        private final CallWith[] callWith;

        public Interception(String binaryDeclTypeName, String methodDecl, CallWith ... callWith) {
            this.binaryDeclTypeName = binaryDeclTypeName;
            this.methodDecl = methodDecl;
            this.callWith = callWith;
        }

        public String binaryDeclTypeName() {
            return this.binaryDeclTypeName;
        }

        public String methodDecl() {
            return this.methodDecl;
        }

        public CallWith[] callWith() {
            return this.callWith;
        }

        public String toString() {
            return "target method in " + this.binaryDeclTypeName + ": " + this.methodDecl + " passing " + Arrays.toString((Object[])this.callWith);
        }
    }

    public static enum CallWith {
        STACK_TOP,
        THIS,
        CLASS,
        METHOD_NAME_AND_DESC,
        FIRST_ARG,
        ALL_ARGS,
        ALL_ARGS_AS_ARRAY,
        CONSTANT_I_0,
        CONSTANT_I_1;

    }
}

