/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JasperJdtInterceptor
extends Interceptor {
    private static final String BINARY_NAME = "com/semmle/extractor/java/interceptors/JasperJdtInterceptor";
    private static final String JASPER_COMPILER_BINARY_NAME = "org/apache/jasper/compiler/Compiler";
    private static final String JASPER_JDT_COMPILER_BINARY_NAME = "org/apache/jasper/compiler/JDTCompiler";

    @Override
    public boolean interceptType(String binaryTypeName) {
        return this.interceptJasperType(binaryTypeName) && this.javaEnabled();
    }

    private boolean interceptJasperType(String binaryTypeName) {
        return binaryTypeName.equals(JASPER_JDT_COMPILER_BINARY_NAME);
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (this.interceptJasperType(binaryTypeName) && binaryTypeName.equals(JASPER_JDT_COMPILER_BINARY_NAME) && methodName.equals("generateClass") && (methodDescriptor.equals("(Ljava/util/Map;)V") || methodDescriptor.equals("([Ljava/lang/String;)V")) && !before) {
            return new Interceptor.Interception(BINARY_NAME, "void invokeJavaExtractor(Object)", Interceptor.CallWith.THIS);
        }
        return null;
    }

    @InterceptionMethod
    public static void invokeJavaExtractor(Object jasperJdt) {
        LinkedHashMap<String, String> addEnv = new LinkedHashMap<String, String>();
        String[] javacArgs = JasperJdtInterceptor.constructJavacArgs(jasperJdt, addEnv);
        if (javacArgs != null) {
            JasperJdtInterceptor.info(2, "Intercepted Jasper JDTCompiler. JSP webapp root URI: " + (String)addEnv.get("CODEQL_EXTRACTOR_JAVA_JSP_ROOT_URI") + " -- Compiler arguments: " + JasperJdtInterceptor.glue(" ", javacArgs));
            Utils.invokeOdasaJavac(0, javacArgs, false, addEnv);
        } else {
            JasperJdtInterceptor.warn(1, "Could not construct javac arguments for Jasper ECJ interception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] constructJavacArgs(Object jasperJdt, Map<String, String> addEnv) {
        String encoding;
        String target;
        String source;
        Iterator e;
        ArrayList<String> classpathList;
        Object outputDir;
        Object javaEncoding;
        Object targetVM;
        Object sourceVM;
        Class<?> objContextClass;
        Object objContext;
        ArrayList<String> args;
        block45: {
            args = new ArrayList<String>();
            Class<?> jasperJdtClass = jasperJdt.getClass();
            try {
                String expectedJasperJdtClassName = JASPER_COMPILER_BINARY_NAME.replaceAll("/", ".");
                while (!jasperJdtClass.getName().equals(expectedJasperJdtClassName)) {
                    if ((jasperJdtClass = jasperJdtClass.getSuperclass()) != null) continue;
                    JasperJdtInterceptor.warn(1, "Failed to find Jasper class with qualified name: " + expectedJasperJdtClassName);
                    return null;
                }
                Field contextField = jasperJdtClass.getDeclaredField("ctxt");
                contextField.setAccessible(true);
                ArrayList<URL> allUrls = new ArrayList<URL>();
                try {
                    objContext = contextField.get(jasperJdt);
                    objContextClass = objContext.getClass();
                    if ("org.apache.jasper.JspCompilationContext".equals(objContext.getClass().getName())) {
                        Method getOptionsMethod = objContextClass.getMethod("getOptions", new Class[0]);
                        Object options = getOptionsMethod.invoke(objContext, new Object[0]);
                        Class<?> optionsClass = options.getClass().getSuperclass();
                        Method getCompilerSourceVmMethod = optionsClass.getMethod("getCompilerSourceVM", new Class[0]);
                        sourceVM = getCompilerSourceVmMethod.invoke(options, new Object[0]);
                        Method getCompilerTargetVmMethod = optionsClass.getMethod("getCompilerTargetVM", new Class[0]);
                        targetVM = getCompilerTargetVmMethod.invoke(options, new Object[0]);
                        Method getJavaEncodingMethod = optionsClass.getMethod("getJavaEncoding", new Class[0]);
                        javaEncoding = getJavaEncodingMethod.invoke(options, new Object[0]);
                        Method getScratchDirMethod = optionsClass.getMethod("getScratchDir", new Class[0]);
                        outputDir = getScratchDirMethod.invoke(options, new Object[0]);
                        addEnv.put("CODEQL_EXTRACTOR_JAVA_JSP_DEST_DIR", outputDir.toString());
                        Field uriRootField = optionsClass.getDeclaredField("uriRoot");
                        uriRootField.setAccessible(true);
                        Object uriRoot = uriRootField.get(options);
                        addEnv.put("CODEQL_EXTRACTOR_JAVA_JSP_ROOT_URI", uriRoot.toString());
                        Method jspLoaderMethod = objContextClass.getMethod("getJspLoader", new Class[0]);
                        Object clsLoader = jspLoaderMethod.invoke(objContext, new Object[0]);
                        Class<?> clsLoaderClass = clsLoader.getClass();
                        List<URL> urls = null;
                        while (clsLoader != null) {
                            urls = JasperJdtInterceptor.getLoaderClasspath(clsLoader);
                            if (urls == null) {
                                JasperJdtInterceptor.warn(1, "Failed to obtain classpath from class loader for Jasper ECJ compilation");
                                String[] stringArray = null;
                                return stringArray;
                            }
                            allUrls.addAll(0, urls);
                            Method getParentMethod = clsLoaderClass.getMethod("getParent", new Class[0]);
                            clsLoader = getParentMethod.invoke(clsLoader, new Object[0]);
                        }
                    } else {
                        JasperJdtInterceptor.warn(1, "Field has unexpected type: " + objContext.getClass());
                        return args.toArray(new String[0]);
                    }
                    classpathList = new ArrayList<String>();
                    e = allUrls.iterator();
                    break block45;
                }
                catch (IllegalAccessException e2) {
                    JasperJdtInterceptor.warn(1, "Illegal access: " + e2);
                    return args.toArray(new String[0]);
                }
                catch (NoSuchMethodException e3) {
                    JasperJdtInterceptor.warn(1, "Non-existing method: " + e3);
                    return args.toArray(new String[0]);
                }
                catch (IllegalArgumentException e4) {
                    JasperJdtInterceptor.warn(1, "Illegal argument: " + e4);
                    return args.toArray(new String[0]);
                }
                catch (InvocationTargetException e5) {
                    JasperJdtInterceptor.warn(1, "Invocation error: " + e5);
                    return args.toArray(new String[0]);
                }
                finally {
                    try {
                        contextField.setAccessible(false);
                    }
                    catch (SecurityException e6) {
                        JasperJdtInterceptor.warn(1, "Failed to reset field accessibility: " + e6);
                    }
                }
            }
            catch (NoSuchFieldException e7) {
                JasperJdtInterceptor.warn(1, "Failed to find field: " + e7);
                return args.toArray(new String[0]);
            }
            catch (SecurityException e8) {
                JasperJdtInterceptor.warn(1, "Failed to make field accessible: " + e8);
            }
            return args.toArray(new String[0]);
        }
        while (e.hasNext()) {
            URL url = (URL)e.next();
            if ("file".equals(url.getProtocol())) {
                File fileFromURL = JasperJdtInterceptor.getFileFromURL(url);
                if (fileFromURL == null) {
                    return null;
                }
                classpathList.add(fileFromURL.getAbsolutePath());
                continue;
            }
            JasperJdtInterceptor.warn(1, "Unexpected URL protocol: " + url.getProtocol());
        }
        Method getServletJavaFileNameMethod = objContextClass.getMethod("getServletJavaFileName", new Class[0]);
        String filename = (String)getServletJavaFileNameMethod.invoke(objContext, new Object[0]);
        if (sourceVM instanceof String && (source = (String)sourceVM).length() > 0) {
            args.add("-source");
            args.add(source);
        }
        if (targetVM instanceof String && (target = (String)targetVM).length() > 0) {
            args.add("-target");
            args.add(target);
        }
        if (javaEncoding instanceof String && (encoding = (String)javaEncoding).length() > 0) {
            args.add("-encoding");
            args.add(encoding);
        }
        if (outputDir instanceof File) {
            File destDir = (File)outputDir;
            args.add("-d");
            args.add(destDir.getAbsolutePath());
        }
        if (classpathList.size() > 0) {
            args.add("-cp");
            args.add(JasperJdtInterceptor.glue(File.pathSeparator, classpathList));
        }
        if (filename == null) return args.toArray(new String[0]);
        args.add(filename);
        return args.toArray(new String[0]);
    }

    private static File getFileFromURL(URL url) {
        if (!"file".equals(url.getProtocol())) {
            JasperJdtInterceptor.warn(1, "Expecting URL with file protocol, got: " + url);
            return null;
        }
        try {
            return new File(url.toURI().getPath());
        }
        catch (URISyntaxException e) {
            JasperJdtInterceptor.warn(1, "Bad URI syntax: " + e);
            return null;
        }
    }

    public static List<URL> getLoaderClasspath(Object loader) {
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            return Arrays.asList(urls);
        }
        Field ucpField = null;
        try {
            ucpField = loader.getClass().getDeclaredField("ucp");
            ucpField.setAccessible(true);
            Object urlClassPath = ucpField.get(loader);
            Method getURLs = urlClassPath.getClass().getDeclaredMethod("getURLs", new Class[0]);
            URL[] urls = (URL[])getURLs.invoke(urlClassPath, new Object[0]);
            return Arrays.asList(urls);
        }
        catch (Exception e) {
            JasperJdtInterceptor.warn(1, "Tried to get classpath from classloader of type: " + loader.getClass() + " " + e);
            return null;
        }
    }

    public static String glue(String separator, Iterable<?> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(o == null ? "<null>" : o.toString());
        }
        return sb.toString();
    }

    public static String glue(String separator, Object[] values) {
        return JasperJdtInterceptor.glue(separator, Arrays.asList(values));
    }

    public static String glue(String separator, String ... values) {
        return JasperJdtInterceptor.glue(separator, (Object[])values);
    }
}

