/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.util.Set;

public class JasperJspcInterceptor
extends Interceptor {
    private static final String BINARY_NAME = "com/semmle/extractor/java/interceptors/JasperJspcInterceptor";
    private static final String JASPER_JSPC_BINARY_NAME = "org/apache/jasper/JspC";

    @Override
    public boolean interceptType(String binaryTypeName) {
        return this.interceptJasperType(binaryTypeName) && this.javaEnabled();
    }

    private boolean interceptJasperType(String binaryTypeName) {
        return binaryTypeName.equals(JASPER_JSPC_BINARY_NAME);
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (this.interceptJasperType(binaryTypeName)) {
            if (methodName.equals("getMappedFile") && methodDescriptor.equals("()Z") && !before) {
                return new Interceptor.Interception(BINARY_NAME, "boolean getMappedFile(boolean)", new Interceptor.CallWith[0]);
            }
            if (methodName.equals("isSmapSuppressed") && methodDescriptor.equals("()Z") && !before) {
                return new Interceptor.Interception(BINARY_NAME, "boolean isSmapSuppressed(boolean)", new Interceptor.CallWith[0]);
            }
            if (methodName.equals("isSmapDumped") && methodDescriptor.equals("()Z") && !before) {
                return new Interceptor.Interception(BINARY_NAME, "boolean isSmapDumped(boolean)", new Interceptor.CallWith[0]);
            }
        }
        return null;
    }

    @InterceptionMethod
    public static boolean getMappedFile(boolean b) {
        return true;
    }

    @InterceptionMethod
    public static boolean isSmapSuppressed(boolean b) {
        return false;
    }

    @InterceptionMethod
    public static boolean isSmapDumped(boolean b) {
        return true;
    }
}

