/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.util.Arrays;
import java.util.Set;

public class JavacMainInterceptor
extends Interceptor {
    private static final String BINARY_NAME = "com/semmle/extractor/java/interceptors/JavacMainInterceptor";

    @Override
    public boolean interceptType(String binaryTypeName) {
        return binaryTypeName.equals("com/sun/tools/javac/main/Main") && this.javaEnabled();
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (before) {
            return null;
        }
        if (methodName.equals("compile")) {
            if (methodDescriptor.equals("([Ljava/lang/String;Lcom/sun/tools/javac/util/Context;)Lcom/sun/tools/javac/main/Main$Result;")) {
                return new Interceptor.Interception(BINARY_NAME, "void javacMainResult(Object,String[])", Interceptor.CallWith.STACK_TOP, Interceptor.CallWith.FIRST_ARG);
            }
            if (methodDescriptor.equals("([Ljava/lang/String;Lcom/sun/tools/javac/util/Context;)I")) {
                return new Interceptor.Interception(BINARY_NAME, "int javacMainInt(int,String[])", Interceptor.CallWith.FIRST_ARG);
            }
        }
        return null;
    }

    @InterceptionMethod
    public static void javacMainResult(Object result, String[] args) {
        JavacMainInterceptor.info(2, "Intercepted javac Main.compile(String[],Context): " + Arrays.toString(args));
        String resultName = result.toString();
        int javacExitCode = JavacMainInterceptor.getJavacExitCode(resultName);
        int odasaJavacExitCode = Utils.invokeOdasaJavac(javacExitCode, args);
        if (javacExitCode == 0 && odasaJavacExitCode != 0) {
            throw new Error("Fatal extractor error detected. Attempting to abort build commands.");
        }
    }

    private static int getJavacExitCode(String resultName) {
        if ("OK".equals(resultName)) {
            return 0;
        }
        if ("ERROR".equals(resultName)) {
            return 1;
        }
        if ("CMDERR".equals(resultName)) {
            return 2;
        }
        if ("SYSERR".equals(resultName)) {
            return 3;
        }
        if ("ABNORMAL".equals(resultName)) {
            return 4;
        }
        return 5;
    }

    @InterceptionMethod
    public static int javacMainInt(int javacExitCode, String[] args) {
        JavacMainInterceptor.info(2, "Intercepted javac Main.compile(String[],Context): " + Arrays.toString(args));
        return Utils.invokeOdasaJavac(javacExitCode, args);
    }
}

