/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;

public class JavacToolInterceptor
extends Interceptor {
    private static final String GET_TASK_SIGNATURE_PREFIX = "(Ljava/io/Writer;Ljavax/tools/JavaFileManager;Ljavax/tools/DiagnosticListener;Ljava/lang/Iterable;Ljava/lang/Iterable;Ljava/lang/Iterable;";
    private static final Map<Object, ArrayList<String>> task2Args = new WeakHashMap<Object, ArrayList<String>>();
    private static final Map<Object, Boolean> task2ProxyFm = new WeakHashMap<Object, Boolean>();
    private static final Map<Object, Object> task2Fm = new WeakHashMap<Object, Object>();

    @Override
    public boolean interceptType(String binaryTypeName) {
        return (this.isJavacTool(binaryTypeName) || this.isJavacTask(binaryTypeName)) && this.javaEnabled();
    }

    private boolean isJavacTool(String binaryTypeName) {
        return binaryTypeName.equals("com/sun/tools/javac/api/JavacTool");
    }

    private boolean isJavacTask(String binaryTypeName) {
        return binaryTypeName.equals("com/sun/source/util/JavacTask") || binaryTypeName.equals("com/sun/tools/javac/api/JavacTaskImpl");
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (before) {
            return null;
        }
        if (this.isJavacTask(binaryTypeName) && methodName.equals("call") && methodDescriptor.equals("()Ljava/lang/Boolean;")) {
            JavacToolInterceptor.info(3, "Instrumenting " + binaryTypeName + "." + methodName + methodDescriptor);
            return new Interceptor.Interception("com/semmle/extractor/java/interceptors/JavacToolInterceptor", "Boolean CompilationTask_call_after(Boolean,Object)", Interceptor.CallWith.THIS);
        }
        if (this.isJavacTask(binaryTypeName) && methodName.equals("doCall") && methodDescriptor.equals("()Lcom/sun/tools/javac/main/Main$Result;")) {
            JavacToolInterceptor.info(3, "Instrumenting " + binaryTypeName + "." + methodName + methodDescriptor);
            return new Interceptor.Interception("com/semmle/extractor/java/interceptors/JavacToolInterceptor", "void CompilationTask_doCall_after(Object,Object)", Interceptor.CallWith.STACK_TOP, Interceptor.CallWith.THIS);
        }
        JavacToolInterceptor.info(3, "Considering " + binaryTypeName + "." + methodName + methodDescriptor);
        if (this.isJavacTool(binaryTypeName) && methodName.equals("getTask")) {
            if (methodDescriptor.startsWith(GET_TASK_SIGNATURE_PREFIX)) {
                return new Interceptor.Interception("com/semmle/extractor/java/interceptors/JavacToolInterceptor", "void getTask(Object, Object[])", Interceptor.CallWith.STACK_TOP, Interceptor.CallWith.ALL_ARGS_AS_ARRAY);
            }
            JavacToolInterceptor.info(3, "Not instrumenting getTask method: Signature differs.\n\t- wanted:  (Ljava/io/Writer;Ljavax/tools/JavaFileManager;Ljavax/tools/DiagnosticListener;Ljava/lang/Iterable;Ljava/lang/Iterable;Ljava/lang/Iterable;...\n\t- but got: " + methodDescriptor);
        }
        JavacToolInterceptor.info(3, this + ": Not instrumenting method " + binaryTypeName + "." + methodName + methodDescriptor);
        return null;
    }

    private static boolean looksLikeErrorProne(String s) {
        String prefix = "WrappedJavaFileObject[";
        if (s.startsWith("WrappedJavaFileObject[")) {
            s = s.substring("WrappedJavaFileObject[".length());
        }
        return s.startsWith("com.google.errorprone.fixes.SuggestedFixes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterceptionMethod
    public static void getTask(Object task, Object[] arguments) {
        if (task2Args.containsKey(task)) {
            return;
        }
        boolean proxyFileManager = false;
        Object fmArg = arguments[1];
        Class<?> fmClass = fmArg.getClass();
        if (fmClass.getName().equals("com.sun.tools.javac.api.ClientCodeWrapper$WrappedStandardJavaFileManager")) {
            try {
                Field f = fmClass.getSuperclass().getDeclaredField("clientJavaFileManager");
                f.setAccessible(true);
                String fmName = f.get(fmArg).getClass().getName();
                if (fmName.startsWith("com.sun.proxy.$Proxy")) {
                    proxyFileManager = true;
                }
            }
            catch (NoSuchFieldException e) {
                JavacToolInterceptor.warn(1, "Could not find 'clientJavaFileManager' field: " + e);
            }
            catch (IllegalAccessException e) {
                JavacToolInterceptor.warn(1, "Could not access 'clientJavaFileManager' field: " + e);
            }
        } else if (fmClass.getName().equals("com.google.devtools.build.buildjar.javac.BlazeJavacMain$ClassloaderMaskingFileManager")) {
            JavacToolInterceptor.info(3, "Recording Bazel file manager argument.");
            task2Fm.put(task, fmArg);
        }
        Iterable options = (Iterable)arguments[3];
        Iterable compilationUnits = (Iterable)arguments[5];
        JavacToolInterceptor.info(2, "Intercepted JavacTool.getTask: " + options);
        ArrayList<String> args = new ArrayList<String>();
        if (options != null) {
            for (Object option : options) {
                args.add((String)option);
            }
        }
        if (compilationUnits != null) {
            String prefix = "SimpleFileObject[";
            String suffix = "]";
            URI cwd = new File("").toURI();
            for (Object file : compilationUnits) {
                Class<?> fileObjectClass = file.getClass();
                Method toUriMethod = null;
                boolean accessible = true;
                String toString = file.toString();
                if (toString != null && JavacToolInterceptor.looksLikeErrorProne(toString)) {
                    JavacToolInterceptor.info(3, "Ignoring file object " + toString + " that looks like it came from an Error-Prone fix evaluation");
                    task2Args.put(task, null);
                    return;
                }
                try {
                    URI uri;
                    toUriMethod = fileObjectClass.getMethod("toUri", new Class[0]);
                    accessible = toUriMethod.isAccessible();
                    if (!accessible) {
                        toUriMethod.setAccessible(true);
                    }
                    try {
                        uri = (URI)toUriMethod.invoke(file, new Object[0]);
                    }
                    finally {
                        if (!accessible) {
                            toUriMethod.setAccessible(false);
                        }
                    }
                    try {
                        args.add(new File(cwd.resolve(uri)).getPath());
                    }
                    catch (IllegalArgumentException e) {
                        JavacToolInterceptor.warn(1, "Failed to convert " + uri + " to file: " + e);
                    }
                }
                catch (Exception e) {
                    if (toString != null && toString.startsWith(prefix) && toString.endsWith(suffix)) {
                        String path = toString.substring(prefix.length(), toString.length() - suffix.length());
                        args.add(path);
                        continue;
                    }
                    throw new RuntimeException("Unknown file object: " + file.toString(), e);
                }
            }
        }
        task2Args.put(task, args);
        task2ProxyFm.put(task, proxyFileManager);
    }

    private static List<String> processFm(Object fmArg) {
        ArrayList<String> fileMgrJavacArgs = new ArrayList<String>();
        try {
            Class<?> fmClass = fmArg.getClass();
            ArrayList locationObjs = new ArrayList();
            Field f = fmClass.getSuperclass().getSuperclass().getDeclaredField("locations");
            f.setAccessible(true);
            Object locations = f.get(fmArg);
            Field handlerField = locations.getClass().getDeclaredField("handlersForLocation");
            handlerField.setAccessible(true);
            Object handlers = handlerField.get(locations);
            if (handlers instanceof Map) {
                Map map = (Map)handlers;
                for (Object l : map.keySet()) {
                    locationObjs.add(l);
                }
            }
            Method[] methods = fmClass.getSuperclass().getDeclaredMethods();
            for (Method m : methods) {
                if (!"getLocation".equals(m.getName())) continue;
                for (Object sl : locationObjs) {
                    String javacOption = JavacToolInterceptor.convertStandardLocationToJavacOption(sl.toString());
                    if (javacOption != null) {
                        m.setAccessible(true);
                        Object pathIterable = null;
                        try {
                            pathIterable = m.invoke(fmArg, sl);
                            if (pathIterable instanceof Iterable) {
                                Iterable paths = (Iterable)pathIterable;
                                StringBuilder sb = new StringBuilder(File.pathSeparator);
                                for (Object p : paths) {
                                    if (p instanceof File) {
                                        String absPath = ((File)p).getAbsolutePath();
                                        sb.append(absPath);
                                        sb.append(File.pathSeparator);
                                        continue;
                                    }
                                    JavacToolInterceptor.warn(1, "Expected File instead of: " + p.getClass());
                                }
                                fileMgrJavacArgs.add(javacOption);
                                fileMgrJavacArgs.add(sb.toString());
                                continue;
                            }
                            if (pathIterable == null) continue;
                            JavacToolInterceptor.warn(1, "Expected Iterable instead of: " + pathIterable.getClass());
                        }
                        catch (InvocationTargetException e) {
                            JavacToolInterceptor.warn(1, "File manager method invocation completed abnormally for " + sl + ": " + e);
                        }
                        continue;
                    }
                    JavacToolInterceptor.warn(1, "Ignoring unknown file manager option: " + sl);
                }
            }
            return fileMgrJavacArgs;
        }
        catch (NoSuchFieldException e) {
            JavacToolInterceptor.warn(1, "Could not find file manager locations field: " + e);
        }
        catch (IllegalAccessException e) {
            JavacToolInterceptor.warn(1, "Could not access file manager field or method: " + e);
        }
        return new ArrayList<String>();
    }

    private static String convertStandardLocationToJavacOption(String standardLocation) {
        if ("CLASS_OUTPUT".equals(standardLocation)) {
            return "-d";
        }
        if ("SOURCE_OUTPUT".equals(standardLocation)) {
            return "-s";
        }
        if ("NATIVE_HEADER_OUTPUT".equals(standardLocation)) {
            return "-h";
        }
        if ("CLASS_PATH".equals(standardLocation)) {
            return "-classpath";
        }
        if ("SOURCE_PATH".equals(standardLocation)) {
            return "-sourcepath";
        }
        if ("PLATFORM_CLASS_PATH".equals(standardLocation)) {
            return "-bootclasspath";
        }
        if ("ANNOTATION_PROCESSOR_PATH".equals(standardLocation)) {
            return "-processorpath";
        }
        return null;
    }

    @InterceptionMethod
    public static Boolean CompilationTask_call_after(Boolean callResult, Object thiz) {
        ArrayList<String> args = task2Args.get(thiz);
        Boolean proxyFm = task2ProxyFm.get(thiz);
        Object fmArg = task2Fm.get(thiz);
        if (args != null) {
            task2Args.put(thiz, null);
            if (callResult != null && callResult.booleanValue()) {
                if (fmArg != null) {
                    List<String> fileMgrArgs = JavacToolInterceptor.processFm(fmArg);
                    ArrayList<String> newArgs = new ArrayList<String>(fileMgrArgs);
                    newArgs.addAll(args);
                    args = newArgs;
                }
                return Utils.invokeOdasaJavac(callResult != false ? 0 : 1, args.toArray(new String[args.size()]), proxyFm != null && proxyFm != false) == 0;
            }
            JavacToolInterceptor.warn(1, "Not invoking Java extractor for failed 'CompilationTask.call'.");
            return callResult;
        }
        return task2Args.containsKey(thiz) ? callResult : Boolean.valueOf(false);
    }

    @InterceptionMethod
    public static void CompilationTask_doCall_after(Object callResult, Object thiz) {
        JavacToolInterceptor.CompilationTask_call_after(Objects.toString(callResult).equals("OK"), thiz);
    }
}

