/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class KotlinInterceptor
extends Interceptor {
    private static final String BINARY_NAME = "com/semmle/extractor/java/interceptors/KotlinInterceptor";
    private static Map<String, ClassLoader> loaderMap = new LinkedHashMap<String, ClassLoader>();
    private static String kotlincType = "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler";
    private static String parseCommandLineArgumentsKtType = "org/jetbrains/kotlin/cli/common/arguments/ParseCommandLineArgumentsKt";
    private static ThreadLocal<String[]> compilerArguments = new ThreadLocal<String[]>(){

        @Override
        protected String[] initialValue() {
            return new String[0];
        }
    };
    private static String acceptableVersionLimitStr = "1.8.30";
    private static Version acceptableVersionLimit = new Version(acceptableVersionLimitStr);
    private static Pattern simpleArg = Pattern.compile("^[-a-zA-Z0-9_./:][-a-zA-Z0-9_.+/:=]*$");

    @Override
    public boolean interceptType(String binaryTypeName) {
        return (binaryTypeName.equals(kotlincType) || binaryTypeName.equals(parseCommandLineArgumentsKtType)) && this.kotlinEnabled();
    }

    @Override
    public boolean interceptType(String binaryTypeName, ClassLoader loader) {
        if (this.interceptType(binaryTypeName)) {
            loaderMap.put(binaryTypeName, loader);
            return true;
        }
        return false;
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (binaryTypeName.equals(parseCommandLineArgumentsKtType) && methodName.equals("parseCommandLineArguments") && (methodDescriptor.equals("(Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V") || methodDescriptor.equals("(Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;Z)V")) && !before) {
            return new Interceptor.Interception(BINARY_NAME, "void afterArgParse(Object)", Interceptor.CallWith.FIRST_ARG);
        }
        if (binaryTypeName.equals(kotlincType) && methodName.equals("doExecute") && (methodDescriptor.equals("(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/utils/KotlinPaths;)Lorg/jetbrains/kotlin/cli/common/ExitCode;") || methodDescriptor.equals("(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/utils/KotlinPaths;)Lorg/jetbrains/kotlin/cli/common/ExitCode;")) && before) {
            return new Interceptor.Interception(BINARY_NAME, "void beforeKotlinExecute(String, String, String, Object)", Interceptor.CallWith.CLASS, Interceptor.CallWith.METHOD_NAME_AND_DESC, Interceptor.CallWith.FIRST_ARG);
        }
        return null;
    }

    private static String getKotlinVersion(String binaryTypeName) {
        try {
            ClassLoader loader = loaderMap.get(binaryTypeName);
            if (loader != null) {
                Class<?> c = Class.forName("kotlin.KotlinVersion", true, loader);
                Field currentField = c.getField("CURRENT");
                Object current = currentField.get(null);
                Method toString = c.getMethod("toString", new Class[0]);
                String str = (String)toString.invoke(current, new Object[0]);
                return str;
            }
            KotlinInterceptor.warn(1, "Failed to get current Kotlin version. getKotlinVersion has no class loader.");
        }
        catch (ReflectiveOperationException e) {
            KotlinInterceptor.warn(1, "Failed to get current Kotlin version. getKotlinVersion failed:\n" + e.toString());
        }
        return "unknown";
    }

    private static CompilerDependencyVariant getCompilerDependencyVariant(String binaryTypeName) {
        if (KotlinInterceptor.hasType(binaryTypeName, "org.jetbrains.kotlin.com.intellij.mock.MockProject")) {
            return CompilerDependencyVariant.Embeddable;
        }
        if (KotlinInterceptor.hasType(binaryTypeName, "com.intellij.mock.MockProject")) {
            return CompilerDependencyVariant.Standalone;
        }
        return CompilerDependencyVariant.Unknown;
    }

    private static String getExtractorJarPath(CompilerDependencyVariant compilerDependencyVariant, String versionString) {
        if (compilerDependencyVariant == CompilerDependencyVariant.Unknown) {
            throw new RuntimeException("Unknown compiler dependency variant");
        }
        Version executingVersion = new Version(versionString);
        if (executingVersion.compareTo(acceptableVersionLimit) >= 0) {
            throw new KotlinVersionTooRecentError("Kotlin version " + versionString + " is too recent. CodeQL currently supports versions below " + acceptableVersionLimitStr);
        }
        final String jarPrefix = compilerDependencyVariant == CompilerDependencyVariant.Embeddable ? "codeql-extractor-kotlin-embeddable-" : "codeql-extractor-kotlin-standalone-";
        String javaRoot = KotlinInterceptor.getEnv("Kotlin extractor", "CODEQL_EXTRACTOR_JAVA_ROOT");
        if (javaRoot == null) {
            throw new RuntimeException("CODEQL_EXTRACTOR_JAVA_ROOT not set");
        }
        String tools = javaRoot + "/tools/";
        File dir = new File(tools);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(jarPrefix) && name.endsWith(".jar");
            }
        });
        ArrayList<Pair<File, Version>> pairs = new ArrayList<Pair<File, Version>>();
        for (File file : files) {
            Version version;
            String fileName = file.getName();
            String v = fileName.substring(jarPrefix.length(), fileName.indexOf(".jar"));
            int dash = v.indexOf(45);
            if (dash != -1) {
                v = v.substring(0, dash);
            }
            if ((version = new Version(v)).compareTo(executingVersion, 2) != 0) continue;
            pairs.add(new Pair<File, Version>(file, version));
        }
        if (pairs.size() == 0) {
            KotlinInterceptor.info(2, "No Kotlin extractor plugin found for version " + versionString + ". There is no extractor plugin with matching major and minor version numbers.");
            return null;
        }
        Collections.sort(pairs, new Comparator<Pair<File, Version>>(){

            @Override
            public int compare(Pair<File, Version> o1, Pair<File, Version> o2) {
                return o1.getSecond().compareTo(o2.getSecond());
            }
        });
        for (int i = pairs.size() - 1; i >= 0; --i) {
            if (((Version)((Pair)pairs.get(i)).getSecond()).compareTo(executingVersion) > 0) continue;
            return ((File)((Pair)pairs.get(i)).getFirst()).getAbsolutePath();
        }
        KotlinInterceptor.info(2, "No Kotlin extractor plugin found for version " + versionString + ". There is no extractor plugin with lower version number.");
        return null;
    }

    private static boolean hasType(String binaryTypeName, String typeName) {
        try {
            ClassLoader loader = loaderMap.get(binaryTypeName);
            if (loader != null) {
                Class.forName(typeName, true, loader);
                return true;
            }
            KotlinInterceptor.warn(1, "Failed to get Kotlin plugin variant. No class loader for " + binaryTypeName);
        }
        catch (ReflectiveOperationException e) {
            KotlinInterceptor.warn(1, "Failed to get Kotlin plugin variant. hasType failed:\n" + e.toString());
        }
        return false;
    }

    private static String initializeExtractionContext(String version, String binaryTypeName, String methodName, String methodDesc, String jarPath, String[] arguments) {
        String trapRoot = KotlinInterceptor.getEnv("Java TRAP directory", "CODEQL_EXTRACTOR_JAVA_TRAP_DIR");
        if (trapRoot == null || trapRoot.isEmpty()) {
            trapRoot = "kotlin-extractor/trap";
        }
        String invocationTrapDir = trapRoot + "/invocations";
        try {
            File dir = new File(invocationTrapDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File invocationTrapFile = File.createTempFile("kotlin.", ".trap", dir);
            String invocationTrapFilePath = invocationTrapFile.getAbsolutePath();
            try (FileWriter fw = new FileWriter(invocationTrapFilePath);
                 BufferedWriter bufWriter = new BufferedWriter(fw);){
                bufWriter.write("// Intercepted:\n");
                bufWriter.write("//     Class path: " + System.getProperty("java.class.path").replace("\n", "\n//        ") + "\n");
                bufWriter.write("//     Class:      " + binaryTypeName.replace("\n", "\n//        ") + "\n");
                bufWriter.write("//     Method:     " + methodName.replace("\n", "\n//        ") + "\n");
                bufWriter.write("//     Desc:       " + methodDesc.replace("\n", "\n//        ") + "\n");
                bufWriter.write("// Kotlin version: " + version + "\n");
                bufWriter.write("// Using extractor: " + jarPath.replace("\n", "\n//     ") + "\n");
                bufWriter.write("// Working directory: " + Paths.get("", new String[0]).toAbsolutePath().toString() + "\n");
                bufWriter.write("// Environment:\n");
                for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                    String k = entry.getKey().replace("\n", "\n//        ");
                    String v = entry.getValue().replace("\n", "\n//        ");
                    bufWriter.write("//     " + k + " = " + v + "\n");
                }
                bufWriter.write("// Arguments: " + KotlinInterceptor.argsForShell(arguments) + "\n");
                for (String arg : arguments) {
                    String content;
                    if (!arg.startsWith("@") || (content = KotlinInterceptor.readFile(arg.substring(1))) == null) continue;
                    bufWriter.write("// Arguments in file: " + arg + ":\n");
                    bufWriter.write("//" + content.replace("\n", "\n//") + "\n");
                }
                bufWriter.write("#compilation = *\n");
                bufWriter.write("compilations(#compilation, 2, " + KotlinInterceptor.trapString(System.getProperty("user.dir")) + ", " + KotlinInterceptor.trapString(invocationTrapFilePath) + ")\n");
                for (int i = 0; i < arguments.length; ++i) {
                    String arg = arguments[i];
                    bufWriter.write("compilation_args(#compilation, " + i + ", " + KotlinInterceptor.trapString(arg) + ")\n");
                }
            }
            return invocationTrapFilePath;
        }
        catch (Exception e) {
            KotlinInterceptor.warn(0, "Failed to initialize Kotlin extraction context: " + e);
            e.printStackTrace();
            return null;
        }
    }

    private static String trapString(String arg) {
        return '\"' + arg.replace("\"", "\"\"") + '\"';
    }

    private static String readFile(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
        }
        catch (Exception e) {
            KotlinInterceptor.info(2, "Failed to read file: " + filePath);
            return null;
        }
        return contentBuilder.toString();
    }

    private static String getEnv(String what, String v) {
        String result = System.getenv(v);
        if (result == null) {
            KotlinInterceptor.info(2, "Cannot find " + what + ": " + v + " is not set.");
            return null;
        }
        if (result.isEmpty()) {
            KotlinInterceptor.info(2, "Cannot find " + what + ": " + v + " is empty.");
            return null;
        }
        return result;
    }

    private static File getLogFile(String logDir) throws IOException {
        String filename;
        long time = System.currentTimeMillis();
        int i = 0;
        File logFile = null;
        while (!(logFile = new File(logDir, filename = "agent.kotlin-extractor." + Long.toString(time) + "." + Integer.toString(i++) + ".log")).createNewFile()) {
        }
        return logFile;
    }

    private static void addItemsToParsedArguments(Object args, String fieldName, String ... items) throws Exception {
        KotlinInterceptor.info(2, "Adding items to field '" + fieldName + "': " + Arrays.toString(items));
        Field field = args.getClass().getSuperclass().getDeclaredField(fieldName + "$delegate");
        field.setAccessible(true);
        Object freezableVarValue = field.get(args);
        Field valueField = freezableVarValue.getClass().getDeclaredField("value");
        valueField.setAccessible(true);
        Object value = valueField.get(freezableVarValue);
        Object[] arr = (String[])value;
        KotlinInterceptor.info(2, "Found '" + fieldName + "': " + Arrays.toString(arr));
        if (arr == null) {
            arr = new String[]{};
        }
        String[] copy = (String[])Arrays.copyOf(arr, arr.length + items.length);
        for (int i = 0; i < items.length; ++i) {
            copy[arr.length + i] = items[i];
        }
        valueField.set(freezableVarValue, copy);
    }

    private static void setBooleanArgument(Object args, String fieldName, Boolean value) throws Exception {
        KotlinInterceptor.info(2, "Setting value to field '" + fieldName + "': " + value);
        Field field = args.getClass().getDeclaredField(fieldName + "$delegate");
        field.setAccessible(true);
        Object freezableVarValue = field.get(args);
        Field valueField = freezableVarValue.getClass().getDeclaredField("value");
        valueField.setAccessible(true);
        Object ov = valueField.get(freezableVarValue);
        Boolean currentValue = (Boolean)ov;
        KotlinInterceptor.info(2, "Found '" + fieldName + "': " + currentValue);
        if (currentValue.equals(value)) {
            KotlinInterceptor.info(2, "Value is already set to " + value + ".");
            return;
        }
        valueField.set(freezableVarValue, value);
    }

    @InterceptionMethod
    public static void beforeKotlinExecute(String binaryTypeName, String methodName, String methodDesc, Object args) {
        try {
            KotlinInterceptor.info(2, "Intercepted before kotlin execute");
            String version = KotlinInterceptor.getKotlinVersion(kotlincType);
            KotlinInterceptor.info(2, "Kotlin version: " + version);
            CompilerDependencyVariant compilerDependencyVariant = KotlinInterceptor.getCompilerDependencyVariant(kotlincType);
            KotlinInterceptor.info(2, "Selected compiler dependency variant: " + (Object)((Object)compilerDependencyVariant));
            String jarPath = KotlinInterceptor.getExtractorJarPath(compilerDependencyVariant, version);
            if (jarPath == null) {
                KotlinInterceptor.warn(1, "Failed to find Kotlin extractor jar");
                return;
            }
            KotlinInterceptor.addItemsToParsedArguments(args, "pluginClasspaths", jarPath);
            String invocationTrapFilePath = KotlinInterceptor.initializeExtractionContext(version, binaryTypeName, methodName, methodDesc, jarPath, compilerArguments.get());
            compilerArguments.set(new String[0]);
            if (invocationTrapFilePath == null) {
                KotlinInterceptor.warn(1, "Failed to get invocation trap file path");
                return;
            }
            KotlinInterceptor.addItemsToParsedArguments(args, "pluginOptions", "plugin:kotlin-extractor:invocationTrapFile=" + invocationTrapFilePath, "plugin:kotlin-extractor:checkTrapIdentical=true", "plugin:kotlin-extractor:compilationStartTime=" + System.currentTimeMillis());
            if (version.startsWith("1.4")) {
                KotlinInterceptor.setBooleanArgument(args, "useIR", true);
            }
        }
        catch (Exception e) {
            KotlinInterceptor.warn(0, "Failed to adjust Kotlin compiler parameters: " + e);
            e.printStackTrace();
        }
    }

    private static String argsForShell(String[] args) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                result.append(' ');
            }
            first = false;
            if (simpleArg.matcher(arg).matches()) {
                result.append(arg);
                continue;
            }
            result.append('\'');
            result.append(arg.replace("'", "'\\''"));
            result.append('\'');
        }
        return result.toString();
    }

    @InterceptionMethod
    public static void afterArgParse(Object argsList) {
        String[] args;
        block8: {
            KotlinInterceptor.info(2, "Intercepted after argument parsing");
            args = ((List)argsList).toArray(new String[0]);
            Object[] previousArgs = compilerArguments.get();
            if (previousArgs.length != 0) {
                KotlinInterceptor.info(2, "Ignoring previously logged compiler arguments: " + Arrays.toString(previousArgs));
                try {
                    String logDir = KotlinInterceptor.getEnv("Kotlin log directory", "CODEQL_EXTRACTOR_JAVA_LOG_DIR");
                    if (logDir == null) break block8;
                    File logFile = KotlinInterceptor.getLogFile(logDir);
                    KotlinInterceptor.info(2, "Writing ignored compiler arguments to " + logFile.getAbsolutePath());
                    try (BufferedWriter bufWriter = new BufferedWriter(new FileWriter(logFile));){
                        bufWriter.write("Parsing compiler arguments:\n");
                        bufWriter.write(KotlinInterceptor.argsForShell(args) + "\n");
                        bufWriter.write("Previously parsed compiler arguments haven't been used in a compilation:\n");
                        bufWriter.write(KotlinInterceptor.argsForShell((String[])previousArgs) + "\n");
                    }
                }
                catch (Exception e) {
                    KotlinInterceptor.warn(0, "Failed to write previously logged Kotlin compiler arguments to log file: " + e);
                    e.printStackTrace();
                }
            }
        }
        compilerArguments.set(args);
    }

    public static enum CompilerDependencyVariant {
        Unknown,
        Standalone,
        Embeddable;

    }

    private static class Version
    implements Comparable<Version> {
        private final int[] components;

        public Version(String version) {
            String[] components = version.split("\\.");
            this.components = new int[components.length];
            for (int i = 0; i < components.length; ++i) {
                this.components[i] = Integer.parseInt(components[i]);
            }
        }

        public boolean hasSameVersion(Version other, int maxComponents) {
            int length = Math.max(this.components.length, other.components.length);
            for (int i = 0; i < length && i < maxComponents; ++i) {
                int otherComp;
                int thisComp = i < this.components.length ? this.components[i] : 0;
                int n = otherComp = i < other.components.length ? other.components[i] : 0;
                if (thisComp == otherComp) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Version other, int maxComponents) {
            int length = Math.max(this.components.length, other.components.length);
            for (int i = 0; i < length && i < maxComponents; ++i) {
                int otherComp;
                int thisComp = i < this.components.length ? this.components[i] : 0;
                int n = otherComp = i < other.components.length ? other.components[i] : 0;
                if (thisComp < otherComp) {
                    return -1;
                }
                if (thisComp <= otherComp) continue;
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(Version other) {
            return this.compareTo(other, Integer.MAX_VALUE);
        }
    }

    private static class KotlinVersionTooRecentError
    extends Error {
        public KotlinVersionTooRecentError(String msg) {
            super(msg);
        }
    }

    private static class Pair<T1, T2> {
        private final T1 first;
        private final T2 second;

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }

        public T1 getFirst() {
            return this.first;
        }

        public T2 getSecond() {
            return this.second;
        }
    }
}

