/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class SpecificMethodInterceptor
extends Interceptor {
    private static final int TIMES_TO_LOG = 3;
    private static final Object methodCountLock = new Object();
    private static final Map<String, Integer> methodCount = new LinkedHashMap<String, Integer>();
    private static final Logger log = Logger.getLogger(SpecificMethodInterceptor.class.toString());
    private final Map<String, Set<String>> methodsToInterceptByType;

    public SpecificMethodInterceptor(String csvFile, String logFile) {
        log.setUseParentHandlers(false);
        this.methodsToInterceptByType = new LinkedHashMap<String, Set<String>>();
        try {
            this.setupLog(logFile);
            this.readMethodsToIntercept(csvFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("Starting to log first 3 calls to each method specified in file " + logFile + ".");
    }

    private void setupLog(String logFile) throws IOException {
        FileHandler fileHandler = new FileHandler(logFile, true);
        fileHandler.setFormatter(new SimpleFormatter());
        log.addHandler(fileHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMethodsToIntercept(String csvFile) throws IOException {
        log.info("Reading methods to intercept from file: " + csvFile + ".");
        BufferedReader csvReader = null;
        try {
            String line;
            csvReader = new BufferedReader(new FileReader(csvFile));
            while ((line = csvReader.readLine()) != null) {
                String[] splitLine = line.split(",");
                if (splitLine.length == 3) {
                    String typeName = splitLine[0];
                    String methodName = splitLine[1];
                    String methodDesc = splitLine[2];
                    Set<String> methods = this.methodsToInterceptByType.get(typeName);
                    if (methods == null) {
                        methods = new LinkedHashSet<String>();
                        this.methodsToInterceptByType.put(typeName, methods);
                    }
                    methods.add(methodName + methodDesc);
                    continue;
                }
                log.info("Could not parse line \"" + line + "\" so it has been ignored.");
            }
        }
        finally {
            if (csvReader != null) {
                try {
                    csvReader.close();
                }
                catch (IOException e) {
                    this.ignore(e);
                }
            }
        }
    }

    private void ignore(Exception e) {
    }

    @Override
    public boolean interceptType(String binaryTypeName) {
        return this.methodsToInterceptByType.containsKey(binaryTypeName);
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (!before) {
            return null;
        }
        if (this.methodsToInterceptByType.get(binaryTypeName).contains(methodName + methodDescriptor)) {
            return new Interceptor.Interception("com/semmle/extractor/java/interceptors/SpecificMethodInterceptor", "void interceptBody(String, String, Object, Object[])", Interceptor.CallWith.METHOD_NAME_AND_DESC, Interceptor.CallWith.THIS, Interceptor.CallWith.ALL_ARGS_AS_ARRAY);
        }
        return null;
    }

    @InterceptionMethod
    public static void interceptBody(String methodName, String methodDesc, Object thiz, Object[] methodArgs) {
        if (SpecificMethodInterceptor.shouldLog(methodName, methodDesc, thiz)) {
            SpecificMethodInterceptor.logMethodCall(methodName, methodDesc, thiz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldLog(String methodName, String methodDesc, Object thiz) {
        Integer timesLogged;
        String key = thiz.getClass() + " " + methodName + methodDesc;
        Object object = methodCountLock;
        synchronized (object) {
            timesLogged = methodCount.get(key);
            if (timesLogged == null) {
                timesLogged = 1;
                methodCount.put(key, timesLogged);
            } else if (timesLogged <= 3) {
                timesLogged = timesLogged + 1;
                methodCount.put(key, timesLogged);
            }
        }
        return timesLogged <= 3;
    }

    private static void logMethodCall(String methodName, String methodDesc, Object thiz) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            log.log(Level.INFO, "Method Name: " + methodName + "    Method Description: " + methodDesc + "    Declaring Type: " + thiz.getClass(), e);
            return;
        }
    }
}

