/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TakariLifecycleJdtInterceptor
extends Interceptor {
    private static final String BINARY_NAME = "com/semmle/extractor/java/interceptors/TakariLifecycleJdtInterceptor";
    private static final String TAKARI_AC_BINARY_NAME = "io/takari/maven/plugins/compile/AbstractCompiler";
    private static final String TAKARI_JDT_BINARY_NAME = "io/takari/maven/plugins/compile/jdt/CompilerJdt";
    private static Map<Object, TakariInterception> takariMap = Collections.synchronizedMap(new IdentityHashMap());

    @Override
    public boolean interceptType(String binaryTypeName) {
        return this.interceptTakariType(binaryTypeName) && this.javaEnabled();
    }

    private boolean interceptTakariType(String binaryTypeName) {
        return binaryTypeName.equals(TAKARI_JDT_BINARY_NAME) || binaryTypeName.equals(TAKARI_AC_BINARY_NAME);
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        if (this.interceptTakariType(binaryTypeName)) {
            if (binaryTypeName.equals(TAKARI_JDT_BINARY_NAME)) {
                String customDescriptor;
                String standardDescriptor;
                if (methodName.equals("compile") && methodDescriptor.equals("()I") && !before) {
                    return new Interceptor.Interception(BINARY_NAME, "int invokeJavaExtractor(int,Object)", Interceptor.CallWith.THIS);
                }
                if (methodName.equals("skipCompile") && methodDescriptor.equals("()V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void skipCompile(Object)", Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setSources")) {
                    standardDescriptor = "(Ljava/util/List;)Z";
                    customDescriptor = "(Lio/takari/maven/plugins/compile/AbstractCompileMojo$Sources;)Z";
                    if ((methodDescriptor.equals(standardDescriptor) || methodDescriptor.equals(customDescriptor)) && before) {
                        return new Interceptor.Interception(BINARY_NAME, "void recordSources(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                    }
                }
                if (methodName.equals("setClasspath")) {
                    standardDescriptor = "(Ljava/util/List;Ljava/io/File;Ljava/util/Set;)Z";
                    customDescriptor = "(Ljava/util/List;Ljava/io/File;Ljava/util/Set;Ljava/util/List;)Z";
                    if ((methodDescriptor.equals(standardDescriptor) || methodDescriptor.equals(customDescriptor)) && before) {
                        return new Interceptor.Interception(BINARY_NAME, "void recordClasspath(Object[],Object)", Interceptor.CallWith.ALL_ARGS_AS_ARRAY, Interceptor.CallWith.THIS);
                    }
                }
                if (methodName.equals("setSourcepath") && methodDescriptor.equals("(Ljava/util/List;Ljava/util/Set;)Z") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordSourcepath(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setProcessorpath") && methodDescriptor.equals("(Ljava/util/List;)Z") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordProcessorpath(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
            }
            if (binaryTypeName.equals(TAKARI_AC_BINARY_NAME)) {
                if (methodName.equals("setSource") && methodDescriptor.equals("(Ljava/lang/String;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordSource(String,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setTarget") && methodDescriptor.equals("(Ljava/lang/String;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordTarget(String,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setSourceEncoding") && methodDescriptor.equals("(Ljava/nio/charset/Charset;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordSourceEncoding(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setOutputDirectory") && methodDescriptor.equals("(Ljava/io/File;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordOutputDirectory(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setGeneratedSourcesDirectory") && methodDescriptor.equals("(Ljava/io/File;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordGeneratedSourcesDirectory(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setProc") && methodDescriptor.equals("(Lio/takari/maven/plugins/compile/AbstractCompileMojo$Proc;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordProc(Object,Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
                if (methodName.equals("setAnnotationProcessors") && methodDescriptor.equals("([Ljava/lang/String;)V") && before) {
                    return new Interceptor.Interception(BINARY_NAME, "void recordAnnotationProcessors(String[],Object)", Interceptor.CallWith.FIRST_ARG, Interceptor.CallWith.THIS);
                }
            }
        }
        return null;
    }

    @InterceptionMethod
    public static void recordSources(Object sources, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        Iterable sourcesResourceList = (Iterable)sources;
        ti.sources = new ArrayList();
        for (Object obj : sourcesResourceList) {
            Class<?> resourceClass = obj.getClass();
            try {
                Method getResourceMethod = resourceClass.getDeclaredMethod("getResource", new Class[0]);
                File f = (File)getResourceMethod.invoke(obj, new Object[0]);
                ti.sources.add(f.getAbsolutePath());
            }
            catch (NoSuchMethodException e) {
                Utils.warn("Method `getResource` not found: " + e);
            }
            catch (InvocationTargetException e) {
                Utils.warn("Method `getResource` completed abnormally: " + e);
            }
            catch (IllegalAccessException e) {
                Utils.warn("Method `getResource` is inaccessible: " + e);
            }
        }
        Utils.info("Recording Takari Lifecycle CompilerJdt sources: " + Arrays.toString(ti.sources.toArray(new String[0])), 1);
    }

    @InterceptionMethod
    public static void recordClasspath(Object[] args, Object takari) {
        Object deps = args[0];
        Object mainClasses = args[1];
        Object directDeps = args[2];
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        Set directDepsSet = (Set)directDeps;
        ti.classpath = new ArrayList(directDepsSet.size());
        for (Object f : directDepsSet) {
            ti.classpath.add(((File)f).getAbsolutePath());
        }
        Utils.info("Recording Takari Lifecycle CompilerJdt classpath directDeps: " + Arrays.toString(ti.classpath.toArray(new String[0])), 1);
        if (mainClasses != null) {
            ti.classpath.add(((File)mainClasses).getAbsolutePath());
            Utils.info("Recording Takari Lifecycle CompilerJdt classpath mainClasses: " + (String)ti.classpath.get(ti.classpath.size() - 1), 1);
        }
        int startIdx = ti.classpath.size();
        List depsList = (List)deps;
        for (Object f : depsList) {
            ti.classpath.add(((File)f).getAbsolutePath());
        }
        Utils.info("Recording Takari Lifecycle CompilerJdt classpath deps: " + Arrays.toString(ti.classpath.subList(startIdx, ti.classpath.size()).toArray(new String[0])), 1);
    }

    @InterceptionMethod
    public static void recordSourcepath(Object path, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        List pathList = (List)path;
        ti.sourcepath = new ArrayList(pathList.size());
        for (Object f : ti.sourcepath) {
            ti.sourcepath.add(((File)f).getAbsolutePath());
        }
        Utils.info("Recording Takari Lifecycle CompilerJdt sourcepath: " + Arrays.toString(ti.sourcepath.toArray(new String[0])), 1);
    }

    @InterceptionMethod
    public static void recordProcessorpath(Object path, Object takari) {
        if (path == null) {
            return;
        }
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        List pathList = (List)path;
        ti.processorpath = new ArrayList(pathList.size());
        for (Object f : ti.processorpath) {
            ti.processorpath.add(((File)f).getAbsolutePath());
        }
        Utils.info("Recording Takari Lifecycle CompilerJdt processorpath: " + Arrays.toString(ti.processorpath.toArray(new String[0])), 1);
    }

    @InterceptionMethod
    public static void recordSource(String source, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        ti.source = source;
        Utils.info("Recording Takari Lifecycle CompilerJdt source: " + ti.source, 1);
    }

    @InterceptionMethod
    public static void recordTarget(String target, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        ti.target = target;
        Utils.info("Recording Takari Lifecycle CompilerJdt target: " + ti.target, 1);
    }

    @InterceptionMethod
    public static void recordOutputDirectory(Object path, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        File file = (File)path;
        ti.outputDir = file.getAbsolutePath();
        Utils.info("Recording Takari Lifecycle CompilerJdt outputDir: " + ti.outputDir, 1);
    }

    @InterceptionMethod
    public static void recordGeneratedSourcesDirectory(Object path, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        File file = (File)path;
        ti.genSourcesDir = file.getAbsolutePath();
        Utils.info("Recording Takari Lifecycle CompilerJdt genSourcesDir: " + ti.genSourcesDir, 1);
    }

    @InterceptionMethod
    public static void recordSourceEncoding(Object enc, Object takari) {
        if (enc == null) {
            return;
        }
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        Charset encoding = (Charset)enc;
        ti.encoding = encoding.name();
        Utils.info("Recording Takari Lifecycle CompilerJdt encoding: " + ti.encoding, 1);
    }

    @InterceptionMethod
    public static void recordAnnotationProcessors(String[] annProcs, Object takari) {
        if (annProcs == null) {
            return;
        }
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        ti.annotationProcs = TakariLifecycleJdtInterceptor.glue(",", annProcs);
        Utils.info("Recording Takari Lifecycle CompilerJdt annotation processors: " + ti.annotationProcs, 1);
    }

    @InterceptionMethod
    public static void recordProc(Object proc, Object takari) {
        TakariInterception ti = TakariLifecycleJdtInterceptor.getOrCreateTakariInterception(takari);
        Enum procEnum = (Enum)proc;
        if (procEnum != null) {
            if (procEnum.name().startsWith("only")) {
                ti.proc = "only";
            } else if (procEnum.name().equals("none")) {
                ti.proc = "none";
            }
        }
        Utils.info("Recording Takari Lifecycle CompilerJdt proc: " + ti.proc, 1);
    }

    private static TakariInterception getOrCreateTakariInterception(Object takari) {
        TakariInterception ti = takariMap.get(takari);
        if (ti == null) {
            ti = new TakariInterception();
            takariMap.put(takari, ti);
        }
        return ti;
    }

    @InterceptionMethod
    public static void skipCompile(Object takari) {
        Utils.info("Removing Takari Lifecycle CompilerJdt record due to skipped compilation", 1);
        takariMap.remove(takari);
    }

    @InterceptionMethod
    public static int invokeJavaExtractor(int compilerExitCode, Object takari) {
        TakariInterception ti = takariMap.remove(takari);
        if (ti != null) {
            return TakariLifecycleJdtInterceptor.invokeExtractorWithArgs(compilerExitCode, ti);
        }
        Utils.warn("Failed to intercept Takari Lifecycle CompilerJdt arguments prior to extractor invocation.");
        return -1;
    }

    private static int invokeExtractorWithArgs(int compilerExitCode, TakariInterception ti) {
        String[] javacArgs = TakariLifecycleJdtInterceptor.constructJavacArgs(ti);
        Utils.info("Intercepted Takari Lifecycle JDT: " + TakariLifecycleJdtInterceptor.glue(" ", javacArgs), 1);
        if (ti.sources != null && !ti.sources.isEmpty()) {
            return Utils.invokeOdasaJavac(compilerExitCode, javacArgs);
        }
        Utils.info("Skipping Takari Lifecycle JDT interception without source files: " + TakariLifecycleJdtInterceptor.glue(" ", javacArgs), 1);
        return compilerExitCode;
    }

    private static String[] constructJavacArgs(TakariInterception ti) {
        ArrayList<String> args = new ArrayList<String>();
        if (ti.classpath != null && ti.classpath.size() > 0) {
            args.add("-cp");
            args.add(TakariLifecycleJdtInterceptor.glue(File.pathSeparator, ti.classpath));
        }
        if (ti.sourcepath != null && ti.sourcepath.size() > 0) {
            args.add("-sourcepath");
            args.add(TakariLifecycleJdtInterceptor.glue(File.pathSeparator, ti.sourcepath));
        }
        if (ti.proc != null) {
            args.add("-proc:" + ti.proc);
        }
        if (ti.processorpath != null) {
            args.add("-processorpath");
            args.add(TakariLifecycleJdtInterceptor.glue(File.pathSeparator, ti.processorpath));
        }
        if (ti.annotationProcs != null) {
            args.add("-processor");
            args.add(ti.annotationProcs);
        }
        if (ti.source != null) {
            args.add("-source");
            args.add(ti.source);
        }
        if (ti.target != null) {
            args.add("-target");
            args.add(ti.target);
        }
        if (ti.encoding != null) {
            args.add("-encoding");
            args.add(ti.encoding);
        }
        if (ti.outputDir != null) {
            args.add("-d");
            args.add(ti.outputDir);
        }
        if (ti.genSourcesDir != null) {
            args.add("-s");
            args.add(ti.genSourcesDir);
        }
        if (ti.sources != null) {
            args.addAll(ti.sources);
        }
        return args.toArray(new String[0]);
    }

    public static String glue(String separator, Iterable<?> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(o == null ? "<null>" : o.toString());
        }
        return sb.toString();
    }

    public static String glue(String separator, Object[] values) {
        return TakariLifecycleJdtInterceptor.glue(separator, Arrays.asList(values));
    }

    public static String glue(String separator, String ... values) {
        return TakariLifecycleJdtInterceptor.glue(separator, (Object[])values);
    }

    private static class TakariInterception {
        private List<String> sources;
        private List<String> classpath;
        private List<String> sourcepath;
        private String source;
        private String target;
        private String encoding;
        private String outputDir;
        private String genSourcesDir;
        private String proc;
        private String annotationProcs;
        private List<String> processorpath;

        private TakariInterception() {
        }
    }
}

