/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.extractor.java.interceptors;

import com.semmle.extractor.java.InterceptionMethod;
import com.semmle.extractor.java.Utils;
import com.semmle.extractor.java.interceptors.Interceptor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;

public class TracingInterceptor
extends Interceptor {
    private static ThreadLocal<Boolean> looping = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static FileOutputStream out = new FileOutputStream(FileDescriptor.out);
    private static ThreadLocal<Integer> depth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public TracingInterceptor() {
    }

    public TracingInterceptor(File logDir) {
        if (logDir.isDirectory()) {
            try {
                File logFile = File.createTempFile("tracer.", ".txt", logDir);
                out = new FileOutputStream(logFile);
            }
            catch (IOException e) {
                Utils.Exceptions.ignore(e, "Trace to stdout instead.");
            }
        }
    }

    @InterceptionMethod
    public static void intercept(String binaryTypeName, String methodName, String methodDesc, Object thisPointer, Object[] args, boolean before) {
        if (!looping.get().booleanValue()) {
            looping.set(true);
            try {
                if (before) {
                    int currentDepth = depth.get();
                    depth.set(currentDepth + 1);
                    String prefix = currentDepth >= 0 ? new String(new char[currentDepth]).replace("\u0000", "-") : "?";
                    out.write((prefix + "Intercepted " + binaryTypeName + " " + methodName + " (" + methodDesc + ") with thisPointer = " + System.identityHashCode(thisPointer) + " and args " + System.identityHashCode(args) + "\n").getBytes());
                } else {
                    depth.set(depth.get() - 1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            looping.set(false);
        }
    }

    @Override
    public boolean interceptType(String binaryTypeName) {
        return true;
    }

    @Override
    public Interceptor.Interception intercept(String binaryTypeName, Set<String> classMembers, String methodName, String methodDescriptor, boolean before) {
        return new Interceptor.Interception("com/semmle/extractor/java/interceptors/TracingInterceptor", "void intercept(String, String, String, Object, Object[], boolean)", Interceptor.CallWith.CLASS, Interceptor.CallWith.METHOD_NAME_AND_DESC, Interceptor.CallWith.THIS, Interceptor.CallWith.ALL_ARGS_AS_ARRAY, before ? Interceptor.CallWith.CONSTANT_I_1 : Interceptor.CallWith.CONSTANT_I_0);
    }
}

