/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.Logger;
import com.github.codeql.utils.GetByFqNameKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/github/codeql/PrimitiveTypeMapping;", "", "logger", "Lcom/github/codeql/Logger;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "(Lcom/github/codeql/Logger;Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "getLogger", "()Lcom/github/codeql/Logger;", "mapping", "", "Lorg/jetbrains/kotlin/name/Name;", "Lcom/github/codeql/PrimitiveTypeMapping$PrimitiveTypeInfo;", "getPluginContext", "()Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "findClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fqName", "", "fallback", "getPrimitiveInfo", "s", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "PrimitiveTypeInfo", "codeql-kotlin-extractor"})
public final class PrimitiveTypeMapping {
    @NotNull
    private final Logger logger;
    @NotNull
    private final IrPluginContext pluginContext;
    @NotNull
    private final Map<Name, PrimitiveTypeInfo> mapping;

    public PrimitiveTypeMapping(@NotNull Logger logger, @NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        this.logger = logger;
        this.pluginContext = pluginContext;
        IrClass kotlinByte = (IrClass)this.pluginContext.getIrBuiltIns().getByteClass().getOwner();
        IrClass javaLangByte = this.findClass("java.lang.Byte", kotlinByte);
        IrClass kotlinShort = (IrClass)this.pluginContext.getIrBuiltIns().getShortClass().getOwner();
        IrClass javaLangShort = this.findClass("java.lang.Short", kotlinShort);
        IrClass kotlinInt = (IrClass)this.pluginContext.getIrBuiltIns().getIntClass().getOwner();
        IrClass javaLangInteger = this.findClass("java.lang.Integer", kotlinInt);
        IrClass kotlinLong = (IrClass)this.pluginContext.getIrBuiltIns().getLongClass().getOwner();
        IrClass javaLangLong = this.findClass("java.lang.Long", kotlinLong);
        IrClass kotlinUByte = this.findClass("kotlin.UByte", kotlinByte);
        IrClass kotlinUShort = this.findClass("kotlin.UShort", kotlinShort);
        IrClass kotlinUInt = this.findClass("kotlin.UInt", kotlinInt);
        IrClass kotlinULong = this.findClass("kotlin.ULong", kotlinLong);
        IrClass kotlinDouble = (IrClass)this.pluginContext.getIrBuiltIns().getDoubleClass().getOwner();
        IrClass javaLangDouble = this.findClass("java.lang.Double", kotlinDouble);
        IrClass kotlinFloat = (IrClass)this.pluginContext.getIrBuiltIns().getFloatClass().getOwner();
        IrClass javaLangFloat = this.findClass("java.lang.Float", kotlinFloat);
        IrClass kotlinBoolean = (IrClass)this.pluginContext.getIrBuiltIns().getBooleanClass().getOwner();
        IrClass javaLangBoolean = this.findClass("java.lang.Boolean", kotlinBoolean);
        IrClass kotlinChar = (IrClass)this.pluginContext.getIrBuiltIns().getCharClass().getOwner();
        IrClass javaLangCharacter = this.findClass("java.lang.Character", kotlinChar);
        IrClass kotlinUnit = (IrClass)this.pluginContext.getIrBuiltIns().getUnitClass().getOwner();
        IrClass kotlinNothing = (IrClass)this.pluginContext.getIrBuiltIns().getNothingClass().getOwner();
        IrClass javaLangVoid = this.findClass("java.lang.Void", kotlinNothing);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames._byte.shortName(), (Object)new PrimitiveTypeInfo("byte", true, javaLangByte, "kotlin", "Byte")), TuplesKt.to((Object)StandardNames.FqNames._short.shortName(), (Object)new PrimitiveTypeInfo("short", true, javaLangShort, "kotlin", "Short")), TuplesKt.to((Object)StandardNames.FqNames._int.shortName(), (Object)new PrimitiveTypeInfo("int", true, javaLangInteger, "kotlin", "Int")), TuplesKt.to((Object)StandardNames.FqNames._long.shortName(), (Object)new PrimitiveTypeInfo("long", true, javaLangLong, "kotlin", "Long")), TuplesKt.to((Object)StandardNames.FqNames.uByteFqName.shortName(), (Object)new PrimitiveTypeInfo("byte", true, kotlinUByte, "kotlin", "UByte")), TuplesKt.to((Object)StandardNames.FqNames.uShortFqName.shortName(), (Object)new PrimitiveTypeInfo("short", true, kotlinUShort, "kotlin", "UShort")), TuplesKt.to((Object)StandardNames.FqNames.uIntFqName.shortName(), (Object)new PrimitiveTypeInfo("int", true, kotlinUInt, "kotlin", "UInt")), TuplesKt.to((Object)StandardNames.FqNames.uLongFqName.shortName(), (Object)new PrimitiveTypeInfo("long", true, kotlinULong, "kotlin", "ULong")), TuplesKt.to((Object)StandardNames.FqNames._double.shortName(), (Object)new PrimitiveTypeInfo("double", true, javaLangDouble, "kotlin", "Double")), TuplesKt.to((Object)StandardNames.FqNames._float.shortName(), (Object)new PrimitiveTypeInfo("float", true, javaLangFloat, "kotlin", "Float")), TuplesKt.to((Object)StandardNames.FqNames._boolean.shortName(), (Object)new PrimitiveTypeInfo("boolean", true, javaLangBoolean, "kotlin", "Boolean")), TuplesKt.to((Object)StandardNames.FqNames._char.shortName(), (Object)new PrimitiveTypeInfo("char", true, javaLangCharacter, "kotlin", "Char")), TuplesKt.to((Object)StandardNames.FqNames.unit.shortName(), (Object)new PrimitiveTypeInfo("void", false, kotlinUnit, "kotlin", "Unit")), TuplesKt.to((Object)StandardNames.FqNames.nothing.shortName(), (Object)new PrimitiveTypeInfo(null, true, javaLangVoid, "kotlin", "Nothing"))};
        this.mapping = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final IrPluginContext getPluginContext() {
        return this.pluginContext;
    }

    @Nullable
    public final PrimitiveTypeInfo getPrimitiveInfo(@NotNull IrSimpleType s) {
        PrimitiveTypeInfo primitiveTypeInfo;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)((IrType)s));
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = ((IrClass)it.getOwner()).getParent();
            IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
            primitiveTypeInfo = Intrinsics.areEqual((Object)(irPackageFragment != null ? irPackageFragment.getFqName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) ? this.mapping.get(((IrClass)it.getOwner()).getName()) : null;
        } else {
            primitiveTypeInfo = null;
        }
        return primitiveTypeInfo;
    }

    private final IrClass findClass(String fqName, IrClass fallback) {
        IrClassSymbol symbol = GetByFqNameKt.getClassByFqName(this.pluginContext, fqName);
        if (symbol == null) {
            this.logger.warn("Can't find " + fqName);
            return fallback;
        }
        return (IrClass)symbol.getOwner();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/github/codeql/PrimitiveTypeMapping$PrimitiveTypeInfo;", "", "primitiveName", "", "otherIsPrimitive", "", "javaClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "kotlinPackageName", "kotlinClassName", "(Ljava/lang/String;ZLorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/lang/String;Ljava/lang/String;)V", "getJavaClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getKotlinClassName", "()Ljava/lang/String;", "getKotlinPackageName", "getOtherIsPrimitive", "()Z", "getPrimitiveName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "codeql-kotlin-extractor"})
    public static final class PrimitiveTypeInfo {
        @Nullable
        private final String primitiveName;
        private final boolean otherIsPrimitive;
        @NotNull
        private final IrClass javaClass;
        @NotNull
        private final String kotlinPackageName;
        @NotNull
        private final String kotlinClassName;

        public PrimitiveTypeInfo(@Nullable String primitiveName, boolean otherIsPrimitive, @NotNull IrClass javaClass, @NotNull String kotlinPackageName, @NotNull String kotlinClassName) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinPackageName, (String)"kotlinPackageName");
            Intrinsics.checkNotNullParameter((Object)kotlinClassName, (String)"kotlinClassName");
            this.primitiveName = primitiveName;
            this.otherIsPrimitive = otherIsPrimitive;
            this.javaClass = javaClass;
            this.kotlinPackageName = kotlinPackageName;
            this.kotlinClassName = kotlinClassName;
        }

        @Nullable
        public final String getPrimitiveName() {
            return this.primitiveName;
        }

        public final boolean getOtherIsPrimitive() {
            return this.otherIsPrimitive;
        }

        @NotNull
        public final IrClass getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final String getKotlinPackageName() {
            return this.kotlinPackageName;
        }

        @NotNull
        public final String getKotlinClassName() {
            return this.kotlinClassName;
        }

        @Nullable
        public final String component1() {
            return this.primitiveName;
        }

        public final boolean component2() {
            return this.otherIsPrimitive;
        }

        @NotNull
        public final IrClass component3() {
            return this.javaClass;
        }

        @NotNull
        public final String component4() {
            return this.kotlinPackageName;
        }

        @NotNull
        public final String component5() {
            return this.kotlinClassName;
        }

        @NotNull
        public final PrimitiveTypeInfo copy(@Nullable String primitiveName, boolean otherIsPrimitive, @NotNull IrClass javaClass, @NotNull String kotlinPackageName, @NotNull String kotlinClassName) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinPackageName, (String)"kotlinPackageName");
            Intrinsics.checkNotNullParameter((Object)kotlinClassName, (String)"kotlinClassName");
            return new PrimitiveTypeInfo(primitiveName, otherIsPrimitive, javaClass, kotlinPackageName, kotlinClassName);
        }

        public static /* synthetic */ PrimitiveTypeInfo copy$default(PrimitiveTypeInfo primitiveTypeInfo, String string, boolean bl, IrClass irClass, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = primitiveTypeInfo.primitiveName;
            }
            if ((n & 2) != 0) {
                bl = primitiveTypeInfo.otherIsPrimitive;
            }
            if ((n & 4) != 0) {
                irClass = primitiveTypeInfo.javaClass;
            }
            if ((n & 8) != 0) {
                string2 = primitiveTypeInfo.kotlinPackageName;
            }
            if ((n & 0x10) != 0) {
                string3 = primitiveTypeInfo.kotlinClassName;
            }
            return primitiveTypeInfo.copy(string, bl, irClass, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PrimitiveTypeInfo(primitiveName=" + this.primitiveName + ", otherIsPrimitive=" + this.otherIsPrimitive + ", javaClass=" + this.javaClass + ", kotlinPackageName=" + this.kotlinPackageName + ", kotlinClassName=" + this.kotlinClassName + ')';
        }

        public int hashCode() {
            int result = this.primitiveName == null ? 0 : this.primitiveName.hashCode();
            int n = this.otherIsPrimitive ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.javaClass.hashCode();
            result = result * 31 + this.kotlinPackageName.hashCode();
            result = result * 31 + this.kotlinClassName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrimitiveTypeInfo)) {
                return false;
            }
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)other;
            if (!Intrinsics.areEqual((Object)this.primitiveName, (Object)primitiveTypeInfo.primitiveName)) {
                return false;
            }
            if (this.otherIsPrimitive != primitiveTypeInfo.otherIsPrimitive) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.javaClass, (Object)primitiveTypeInfo.javaClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinPackageName, (Object)primitiveTypeInfo.kotlinPackageName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinClassName, (Object)primitiveTypeInfo.kotlinClassName);
        }
    }
}

