/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeql;

import com.github.codeql.FileLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\"\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH$J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\rH$J\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/codeql/TrapFileWriter;", "", "logger", "Lcom/github/codeql/FileLogger;", "trapName", "", "extension", "(Lcom/github/codeql/FileLogger;Ljava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "getLogger", "()Lcom/github/codeql/FileLogger;", "parentDir", "Ljava/io/File;", "kotlin.jvm.PlatformType", "realFile", "tempFile", "debugInfo", "deleteTemp", "", "exists", "", "getReader", "Ljava/io/BufferedReader;", "file", "getRealReader", "getTempReader", "getTempWriter", "Ljava/io/BufferedWriter;", "getWriter", "makeParentDirectory", "renameTempToDifferent", "renameTempToReal", "codeql-kotlin-extractor"})
abstract class TrapFileWriter {
    @NotNull
    private final FileLogger logger;
    @NotNull
    private final String extension;
    @NotNull
    private final File realFile;
    private final File parentDir;
    private File tempFile;

    public TrapFileWriter(@NotNull FileLogger logger, @NotNull String trapName, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)trapName, (String)"trapName");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.logger = logger;
        this.extension = extension;
        this.realFile = new File(trapName + this.extension);
        this.parentDir = this.realFile.getParentFile();
    }

    @NotNull
    public final FileLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @NotNull
    public final String debugInfo() {
        if (this.tempFile != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Partial TRAP file location is ");
            File file = this.tempFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
                file = null;
            }
            return stringBuilder.append(file).toString();
        }
        return "Temporary file not yet created.";
    }

    public final void makeParentDirectory() {
        this.parentDir.mkdirs();
    }

    public final boolean exists() {
        return this.realFile.exists();
    }

    @NotNull
    protected abstract BufferedReader getReader(@NotNull File var1);

    @NotNull
    protected abstract BufferedWriter getWriter(@NotNull File var1);

    @NotNull
    public final BufferedReader getRealReader() {
        return this.getReader(this.realFile);
    }

    @NotNull
    public final BufferedReader getTempReader() {
        File file = this.tempFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
            file = null;
        }
        return this.getReader(file);
    }

    @NotNull
    public final BufferedWriter getTempWriter() {
        if (this.tempFile != null) {
            this.logger.error("Temp writer reinitialized for " + this.realFile);
        }
        File file = File.createTempFile(this.realFile.getName() + '.', ".trap.tmp" + this.extension, this.parentDir);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(realFile.\u2026\" + extension, parentDir)");
        this.tempFile = file;
        File file2 = this.tempFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
            file2 = null;
        }
        return this.getWriter(file2);
    }

    public final void deleteTemp() {
        File file = this.tempFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
            file = null;
        }
        if (!file.delete()) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to delete ");
            File file2 = this.tempFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
                file2 = null;
            }
            this.logger.warn(stringBuilder.append(file2).toString());
        }
    }

    public final void renameTempToDifferent() {
        File trapDifferentFile = File.createTempFile(this.realFile.getName() + '.', ".trap.different" + this.extension, this.parentDir);
        File file = this.tempFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
            file = null;
        }
        if (file.renameTo(trapDifferentFile)) {
            this.logger.warn("TRAP difference: " + this.realFile + " vs " + trapDifferentFile);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to rename ");
            File file2 = this.tempFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
                file2 = null;
            }
            this.logger.warn(stringBuilder.append(file2).append(" to ").append(this.realFile).toString());
        }
    }

    public final void renameTempToReal() {
        File file = this.tempFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
            file = null;
        }
        if (!file.renameTo(this.realFile)) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to rename ");
            File file2 = this.tempFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tempFile");
                file2 = null;
            }
            this.logger.warn(stringBuilder.append(file2).append(" to ").append(this.realFile).toString());
        }
    }
}

