/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.cli;

import com.semmle.cli.SimpleExtractor;
import com.semmle.cli.SimpleExtractorOptions;
import com.semmle.util.trap.CSVtoTRAP;
import com.semmle.util.trap.TrapWriter;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.MarkerFactory;

public class CsvExtractor
extends SimpleExtractor {
    public static void main(String[] args) {
        CsvExtractor.create(args).run();
    }

    public static CsvExtractor create(String[] args) {
        SimpleExtractorOptions csvOptions = CsvExtractor.getExtractorOptions(args, SimpleExtractorOptions.class);
        Set<String> extensions = Collections.singleton("csv");
        if (csvOptions.isExtensions()) {
            extensions = new LinkedHashSet<String>(csvOptions.getExtensions());
        }
        return new CsvExtractor(csvOptions, extensions);
    }

    public CsvExtractor(SimpleExtractorOptions opts, Set<String> defaultExtensions) {
        super(opts, defaultExtensions, MarkerFactory.getMarker("CSVExtractor"));
    }

    @Override
    protected void extractFile(File f, TrapWriter writer) {
        CSVtoTRAP.convert(f, writer, f.getPath());
    }
}

