/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.frontend.util;

import com.semmle.util.data.Pair;
import com.semmle.util.jmx.MBeans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    private static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private static TracedClauses instance = null;

    public static boolean shouldTrace(String name) {
        return instance.shouldTrace(name);
    }

    public static void addTraceClause(String regex) {
        instance.addTraceClause(regex);
    }

    public static void addTraceClauses(List<String> regexes) {
        instance.addTraceClauses(regexes);
    }

    static {
        String setting = System.getProperty("semmle.compiler.traceClauses");
        List traceClauses = null;
        if (setting != null) {
            try {
                traceClauses = Arrays.asList(setting.split(",")).stream().map(r -> new Pair<String, Predicate<String>>((String)r, Pattern.compile(r).asPredicate())).collect(Collectors.toList());
            }
            catch (PatternSyntaxException e) {
                logger.warn("Syntax error in regular expression pattern \"{}\"; disabling clause tracing", (Object)e.getPattern());
            }
        }
        instance = new TracedClauses(traceClauses);
        MBeans.register(instance, new String[0]);
    }

    private static class TracedClauses
    implements TracedClausesMBean {
        private List<Pair<String, Predicate<String>>> traceClauses = null;

        private TracedClauses(List<Pair<String, Predicate<String>>> traceClauses) {
            this.traceClauses = traceClauses;
        }

        @Override
        public boolean shouldTrace(String name) {
            if (this.traceClauses == null) {
                return false;
            }
            return this.traceClauses.stream().anyMatch(p -> ((Predicate)p.snd()).test(name));
        }

        @Override
        public void addTraceClause(String regex) {
            if (this.traceClauses == null) {
                this.traceClauses = new ArrayList<Pair<String, Predicate<String>>>();
            }
            try {
                this.traceClauses.add(new Pair<String, Predicate<String>>(regex, Pattern.compile(regex).asPredicate()));
            }
            catch (PatternSyntaxException e) {
                logger.warn("Syntax error in regular expression pattern \"{}\"; ignoring clause tracing pattern", (Object)e.getPattern());
            }
        }

        @Override
        public void addTraceClauses(List<String> regexes) {
            for (String regex : regexes) {
                this.addTraceClause(regex);
            }
        }

        @Override
        public void setTraceClauses(List<String> regexes) {
            this.traceClauses = new ArrayList<Pair<String, Predicate<String>>>();
            this.addTraceClauses(regexes);
        }

        @Override
        public List<String> getTraceClauses() {
            if (this.traceClauses == null) {
                return null;
            }
            return this.traceClauses.stream().map(p -> (String)p.fst()).collect(Collectors.toList());
        }

        @Override
        public void removeTraceClause(String regex) {
            if (this.traceClauses == null) {
                return;
            }
            this.traceClauses = this.traceClauses.stream().filter(p -> !((String)p.fst()).equals(regex)).collect(Collectors.toList());
        }
    }

    public static interface TracedClausesMBean {
        public void setTraceClauses(List<String> var1);

        public List<String> getTraceClauses();

        public boolean shouldTrace(String var1);

        public void addTraceClause(String var1);

        public void addTraceClauses(List<String> var1);

        public void removeTraceClause(String var1);
    }
}

