/*
 * Decompiled with CFR 0.152.
 */
package com.semmle.util.exception;

public abstract class NestedError
extends RuntimeException {
    private static final long serialVersionUID = -3145876396931008989L;

    public NestedError(String message) {
        super(message);
    }

    public NestedError(Throwable throwable) {
        super(throwable);
    }

    public NestedError(String message, Throwable throwable) {
        super(NestedError.buildMessage(message, throwable), throwable);
    }

    private static String buildMessage(String message, Throwable throwable) {
        if (throwable == null) {
            return message;
        }
        while (throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        String banner = "eventual cause: " + throwable.getClass().getSimpleName();
        String rootmsg = throwable.getMessage();
        if (rootmsg != null) {
            int p = rootmsg.indexOf(10);
            if (p >= 0) {
                rootmsg = rootmsg.substring(0, p) + "...";
            }
            if (rootmsg.length() > 100) {
                rootmsg = rootmsg.substring(0, 80) + "...";
            }
            banner = banner + " \"" + rootmsg + "\"";
        }
        if (message.contains(banner)) {
            return message;
        }
        return message + "\n(" + banner + ")";
    }
}

